/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.methods;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.proc.ProcOperations;
import org.jruby.truffle.core.proc.ProcType;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.control.BreakID;
import org.jruby.truffle.language.control.FrameOnStackMarker;
import org.jruby.truffle.language.locals.ReadFrameSlotNode;
import org.jruby.truffle.language.locals.ReadFrameSlotNodeGen;
import org.jruby.truffle.language.methods.SharedMethodInfo;

public class BlockDefinitionNode
extends RubyNode {
    private final ProcType type;
    private final SharedMethodInfo sharedMethodInfo;
    private final CallTarget callTargetForProcs;
    private final CallTarget callTargetForLambdas;
    private final BreakID breakID;
    @Node.Child
    private ReadFrameSlotNode readFrameOnStackMarkerNode;

    public BlockDefinitionNode(RubyContext context, SourceSection sourceSection, ProcType type, SharedMethodInfo sharedMethodInfo, CallTarget callTargetForProcs, CallTarget callTargetForLambdas, BreakID breakID, FrameSlot frameOnStackMarkerSlot) {
        super(context, sourceSection);
        this.type = type;
        this.sharedMethodInfo = sharedMethodInfo;
        this.callTargetForProcs = callTargetForProcs;
        this.callTargetForLambdas = callTargetForLambdas;
        this.breakID = breakID;
        this.readFrameOnStackMarkerNode = frameOnStackMarkerSlot == null ? null : ReadFrameSlotNodeGen.create(frameOnStackMarkerSlot);
    }

    public BreakID getBreakID() {
        return this.breakID;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object frameOnStackMarkerValue;
        FrameOnStackMarker frameOnStackMarker = this.readFrameOnStackMarkerNode == null ? null : ((frameOnStackMarkerValue = this.readFrameOnStackMarkerNode.executeRead(frame)) instanceof FrameOnStackMarker ? (FrameOnStackMarker)frameOnStackMarkerValue : null);
        return ProcOperations.createRubyProc(this.coreLibrary().getProcFactory(), this.type, this.sharedMethodInfo, this.callTargetForProcs, this.callTargetForLambdas, frame.materialize(), RubyArguments.getMethod(frame), RubyArguments.getSelf(frame), RubyArguments.getBlock(frame), frameOnStackMarker);
    }
}

