/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.methods;

import com.oracle.truffle.api.source.SourceSection;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.truffle.language.LexicalScope;
import org.jruby.truffle.language.methods.Arity;

public class SharedMethodInfo {
    private final SourceSection sourceSection;
    private final LexicalScope lexicalScope;
    private final Arity arity;
    private final String name;
    private final boolean isBlock;
    private final ArgumentDescriptor[] argumentDescriptors;
    private final boolean alwaysClone;
    private final boolean alwaysInline;
    private final boolean needsCallerFrame;

    public SharedMethodInfo(SourceSection sourceSection, LexicalScope lexicalScope, Arity arity, String name, boolean isBlock, ArgumentDescriptor[] argumentDescriptors, boolean alwaysClone, boolean alwaysInline, boolean needsCallerFrame) {
        if (argumentDescriptors == null) {
            argumentDescriptors = new ArgumentDescriptor[]{};
        }
        this.sourceSection = sourceSection;
        this.lexicalScope = lexicalScope;
        this.arity = arity;
        this.name = name;
        this.isBlock = isBlock;
        this.argumentDescriptors = argumentDescriptors;
        this.alwaysClone = alwaysClone;
        this.alwaysInline = alwaysInline;
        this.needsCallerFrame = needsCallerFrame;
    }

    public SourceSection getSourceSection() {
        return this.sourceSection;
    }

    public LexicalScope getLexicalScope() {
        return this.lexicalScope;
    }

    public Arity getArity() {
        return this.arity;
    }

    public String getName() {
        return this.name;
    }

    public boolean isBlock() {
        return this.isBlock;
    }

    public ArgumentDescriptor[] getArgumentDescriptors() {
        return this.argumentDescriptors;
    }

    public boolean shouldAlwaysClone() {
        return this.alwaysClone;
    }

    public boolean shouldAlwaysInline() {
        return this.alwaysInline;
    }

    public boolean needsCallerFrame() {
        return this.needsCallerFrame;
    }

    public SharedMethodInfo withName(String newName) {
        return new SharedMethodInfo(this.sourceSection, this.lexicalScope, this.arity, newName, this.isBlock, this.argumentDescriptors, this.alwaysClone, this.alwaysInline, this.needsCallerFrame);
    }

    public String toString() {
        String prefix = this.isBlock ? "block in " : "";
        String suffix = this.sourceSection == null ? this.name : (this.sourceSection.getSource() == null ? this.sourceSection.getIdentifier() : this.name + " " + this.sourceSection.getShortDescription());
        return prefix + suffix;
    }
}

