/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.supercall;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.array.ArrayOperations;
import org.jruby.truffle.language.RubyNode;

public class ReadSuperArgumentsNode
extends RubyNode {
    @Node.Children
    private final RubyNode[] arguments;
    private final boolean isSplatted;

    public ReadSuperArgumentsNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments, boolean isSplatted) {
        super(context, sourceSection);
        assert (!isSplatted || arguments.length == 1);
        this.arguments = arguments;
        this.isSplatted = isSplatted;
    }

    @Override
    @ExplodeLoop
    public final Object execute(VirtualFrame frame) {
        CompilerAsserts.compilationConstant(this.arguments.length);
        Object[] argumentsObjects = new Object[this.arguments.length];
        for (int i = 0; i < this.arguments.length; ++i) {
            argumentsObjects[i] = this.arguments[i].execute(frame);
        }
        if (this.isSplatted) {
            return ArrayOperations.toObjectArray((DynamicObject)argumentsObjects[0]);
        }
        return argumentsObjects;
    }
}

