/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.stdlib.digest;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jruby.ext.digest.BubbleBabble;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.core.rope.BytesVisitor;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.rope.RopeOperations;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.stdlib.digest.DigestAlgorithm;

@CoreClass(value="Truffle::Digest")
public abstract class DigestNodes {
    @CompilerDirectives.TruffleBoundary
    private static MessageDigest getMessageDigestInstance(String name) {
        try {
            return MessageDigest.getInstance(name);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static DynamicObject createDigest(RubyContext context, DigestAlgorithm algorithm) {
        return Layouts.DIGEST.createDigest(Layouts.CLASS.getInstanceFactory(context.getCoreLibrary().getDigestClass()), algorithm, DigestNodes.getMessageDigestInstance(algorithm.getName()));
    }

    @CoreMethod(names={"bubblebabble"}, onSingleton=true, required=1)
    public static abstract class BubbleBabbleNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(message)"})
        public DynamicObject bubblebabble(DynamicObject message) {
            Rope rope = StringOperations.rope(message);
            return this.createString(BubbleBabble.bubblebabble((byte[])rope.getBytes(), (int)0, (int)rope.byteLength()));
        }
    }

    @CoreMethod(names={"digest_length"}, onSingleton=true, required=1)
    public static abstract class DigestLengthNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int digestLength(DynamicObject digestObject) {
            return Layouts.DIGEST.getAlgorithm(digestObject).getLength();
        }
    }

    @CoreMethod(names={"digest"}, onSingleton=true, required=1)
    public static abstract class DigestNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject digest(DynamicObject digestObject) {
            MessageDigest digest = Layouts.DIGEST.getDigest(digestObject);
            return this.createString(RopeOperations.create(DigestNode.cloneAndDigest(digest), (Encoding)ASCIIEncoding.INSTANCE, CodeRange.CR_VALID));
        }

        @CompilerDirectives.TruffleBoundary
        private static byte[] cloneAndDigest(MessageDigest digest) {
            MessageDigest clonedDigest;
            try {
                clonedDigest = (MessageDigest)digest.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
            return clonedDigest.digest();
        }
    }

    @CoreMethod(names={"reset"}, onSingleton=true, required=1)
    public static abstract class ResetNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject reset(DynamicObject digestObject) {
            Layouts.DIGEST.getDigest(digestObject).reset();
            return digestObject;
        }
    }

    @CoreMethod(names={"update"}, onSingleton=true, required=2)
    public static abstract class UpdateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isRubyString(message)"})
        public DynamicObject update(DynamicObject digestObject, DynamicObject message) {
            final MessageDigest digest = Layouts.DIGEST.getDigest(digestObject);
            RopeOperations.visitBytes(StringOperations.rope(message), new BytesVisitor(){

                @Override
                public void accept(byte[] bytes, int offset, int length) {
                    digest.update(bytes, offset, length);
                }
            });
            return digestObject;
        }
    }

    @CoreMethod(names={"sha512"}, onSingleton=true)
    public static abstract class SHA512Node
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject sha512() {
            return DigestNodes.createDigest(this.getContext(), DigestAlgorithm.SHA512);
        }
    }

    @CoreMethod(names={"sha384"}, onSingleton=true)
    public static abstract class SHA384Node
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject sha384() {
            return DigestNodes.createDigest(this.getContext(), DigestAlgorithm.SHA384);
        }
    }

    @CoreMethod(names={"sha256"}, onSingleton=true)
    public static abstract class SHA256Node
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject sha256() {
            return DigestNodes.createDigest(this.getContext(), DigestAlgorithm.SHA256);
        }
    }

    @CoreMethod(names={"sha1"}, onSingleton=true)
    public static abstract class SHA1Node
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject sha1() {
            return DigestNodes.createDigest(this.getContext(), DigestAlgorithm.SHA1);
        }
    }

    @CoreMethod(names={"md5"}, onSingleton=true)
    public static abstract class MD5Node
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject md5() {
            return DigestNodes.createDigest(this.getContext(), DigestAlgorithm.MD5);
        }
    }
}

