/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.openssl.OpenSSL;
import org.jruby.ext.openssl.SecurityHelper;
import org.jruby.ext.openssl.StringHelper;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class Digest
extends RubyObject {
    private static final long serialVersionUID = 7409857414064319518L;
    private static final ObjectAllocator ALLOCATOR = new ObjectAllocator(){

        public Digest allocate(Ruby runtime, RubyClass klass) {
            return new Digest(runtime, klass);
        }
    };
    private RubyString name;
    private MessageDigest digest;
    private static final byte[] HEX = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    public static void createDigest(Ruby runtime, RubyModule OpenSSL2) {
        runtime.getLoadService().require("digest");
        RubyModule coreDigest = runtime.getModule("Digest");
        RubyClass DigestClass = coreDigest.getClass("Class");
        RubyClass Digest2 = OpenSSL2.defineClassUnder("Digest", DigestClass, ALLOCATOR);
        Digest2.defineAnnotatedMethods(Digest.class);
        RubyClass OpenSSLError = OpenSSL2.getClass("OpenSSLError");
        OpenSSL2.defineClassUnder("DigestError", OpenSSLError, OpenSSLError.getAllocator());
        String digestName = "DSS";
        Digest2.defineClassUnder(digestName, Digest2, (ObjectAllocator)new NamedDigestAllocator(digestName)).defineAnnotatedMethods(Named.class);
        digestName = "DSS1";
        Digest2.defineClassUnder(digestName, Digest2, (ObjectAllocator)new NamedDigestAllocator(digestName)).defineAnnotatedMethods(Named.class);
        digestName = "MD2";
        Digest2.defineClassUnder(digestName, Digest2, (ObjectAllocator)new NamedDigestAllocator(digestName)).defineAnnotatedMethods(Named.class);
        digestName = "MD4";
        Digest2.defineClassUnder(digestName, Digest2, (ObjectAllocator)new NamedDigestAllocator(digestName)).defineAnnotatedMethods(Named.class);
        digestName = "MD5";
        Digest2.defineClassUnder(digestName, Digest2, (ObjectAllocator)new NamedDigestAllocator(digestName)).defineAnnotatedMethods(Named.class);
        digestName = "MDC2";
        Digest2.defineClassUnder(digestName, Digest2, (ObjectAllocator)new NamedDigestAllocator(digestName)).defineAnnotatedMethods(Named.class);
        digestName = "RIPEMD160";
        Digest2.defineClassUnder(digestName, Digest2, (ObjectAllocator)new NamedDigestAllocator(digestName)).defineAnnotatedMethods(Named.class);
        digestName = "SHA";
        Digest2.defineClassUnder(digestName, Digest2, (ObjectAllocator)new NamedDigestAllocator(digestName)).defineAnnotatedMethods(Named.class);
        digestName = "SHA1";
        Digest2.defineClassUnder(digestName, Digest2, (ObjectAllocator)new NamedDigestAllocator(digestName)).defineAnnotatedMethods(Named.class);
        digestName = "SHA224";
        Digest2.defineClassUnder(digestName, Digest2, (ObjectAllocator)new NamedDigestAllocator(digestName)).defineAnnotatedMethods(Named.class);
        digestName = "SHA256";
        Digest2.defineClassUnder(digestName, Digest2, (ObjectAllocator)new NamedDigestAllocator(digestName)).defineAnnotatedMethods(Named.class);
        digestName = "SHA384";
        Digest2.defineClassUnder(digestName, Digest2, (ObjectAllocator)new NamedDigestAllocator(digestName)).defineAnnotatedMethods(Named.class);
        digestName = "SHA512";
        Digest2.defineClassUnder(digestName, Digest2, (ObjectAllocator)new NamedDigestAllocator(digestName)).defineAnnotatedMethods(Named.class);
    }

    static RubyClass _Digest(Ruby runtime) {
        return (RubyClass)runtime.getModule("OpenSSL").getConstantAt("Digest");
    }

    static MessageDigest getDigest(Ruby runtime, String name2) {
        String algorithm = Digest.osslToJava(name2);
        try {
            return SecurityHelper.getMessageDigest(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            OpenSSL.debug(runtime, "getMessageDigest failed: " + e);
            throw runtime.newNotImplementedError("Unsupported digest algorithm (" + name2 + ")");
        }
    }

    private static Digest newInstance(Ruby runtime, IRubyObject name2, IRubyObject data) {
        RubyClass klass = Digest._Digest(runtime);
        Digest instance = new Digest(runtime, klass);
        instance.initializeImpl(runtime, name2.asString(), data);
        return instance;
    }

    public Digest(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    String getRealName() {
        return Digest.osslToJava(this.name.toString());
    }

    MessageDigest getDigestImpl() {
        return this.digest;
    }

    public String getName() {
        return this.name.toString();
    }

    @JRubyMethod(required=1, optional=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context2, IRubyObject[] args) {
        IRubyObject data = context2.nil;
        if (args.length > 1) {
            data = args[1];
        }
        this.initializeImpl(context2.runtime, args[0].asString(), data);
        return this;
    }

    void initializeImpl(Ruby runtime, RubyString name2, IRubyObject data) {
        this.name = name2;
        this.digest = Digest.getDigest(runtime, name2.toString());
        if (!data.isNil()) {
            this.update((IRubyObject)data.asString());
        }
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject obj) {
        this.checkFrozen();
        if (this == obj) {
            return this;
        }
        Digest that = (Digest)obj;
        this.name = (RubyString)that.name.dup();
        try {
            this.digest = (MessageDigest)that.digest.clone();
        }
        catch (CloneNotSupportedException e) {
            Ruby runtime = this.getRuntime();
            OpenSSL.debug(runtime, "MessageDigest.clone() failed: " + e);
            throw runtime.newTypeError("Could not initialize copy of digest (" + this.name + ")");
        }
        return this;
    }

    @JRubyMethod(name={"update"}, alias={"<<"})
    public IRubyObject update(IRubyObject obj) {
        ByteList bytes = obj.asString().getByteList();
        this.digest.update(bytes.getUnsafeBytes(), bytes.getBegin(), bytes.getRealSize());
        return this;
    }

    @JRubyMethod
    public IRubyObject reset() {
        this.digest.reset();
        return this;
    }

    @JRubyMethod
    public RubyString finish() {
        byte[] hash2 = this.digest.digest();
        this.digest.reset();
        return StringHelper.newString(this.getRuntime(), hash2);
    }

    @JRubyMethod
    public RubyString name() {
        return this.name;
    }

    @JRubyMethod
    public IRubyObject digest_length() {
        return RubyFixnum.newFixnum((Ruby)this.getRuntime(), (long)this.digest.getDigestLength());
    }

    @JRubyMethod
    public RubyInteger block_length(ThreadContext context2) {
        Ruby runtime = context2.runtime;
        int blockLength = Digest.getBlockLength(this.digest.getAlgorithm());
        if (blockLength == -1) {
            throw runtime.newRuntimeError(this.getMetaClass() + " doesn't implement block_length()");
        }
        return runtime.newFixnum(blockLength);
    }

    String getAlgorithm() {
        return this.digest.getAlgorithm();
    }

    String getShortAlgorithm() {
        return this.getAlgorithm().replace("-", "");
    }

    private static String osslToJava(String digestName) {
        String name2 = digestName.toString();
        String[] parts = name2.split("::");
        if (parts.length > 1) {
            name2 = parts[parts.length - 1];
        }
        if ("DSS".equalsIgnoreCase(name2)) {
            return "SHA";
        }
        if ("DSS1".equalsIgnoreCase(name2)) {
            return "SHA-1";
        }
        if ("SHA1".equalsIgnoreCase(name2)) {
            return "SHA-1";
        }
        if (name2.toUpperCase().startsWith("SHA") && name2.length() > 4 && name2.charAt(3) != '-') {
            return "SHA-" + name2.substring(3);
        }
        return name2;
    }

    private static int getBlockLength(String algorithm) {
        String alg = algorithm.toUpperCase();
        if (alg.startsWith("SHA")) {
            if (alg.equals("SHA-384")) {
                return 128;
            }
            if (alg.equals("SHA-512")) {
                return 128;
            }
            return 64;
        }
        if (alg.equals("MD5")) {
            return 64;
        }
        if (alg.equals("MD4")) {
            return 64;
        }
        if (alg.equals("MD2")) {
            return 48;
        }
        if (alg.equals("RIPEMD160")) {
            return 64;
        }
        return -1;
    }

    @JRubyMethod(meta=true)
    public static RubyString digest(ThreadContext context2, IRubyObject self, IRubyObject name2, IRubyObject data) {
        return Digest.newInstance(context2.runtime, name2, data).finish();
    }

    @JRubyMethod(meta=true)
    public static RubyString hexdigest(ThreadContext context2, IRubyObject self, IRubyObject name2, IRubyObject data) {
        Ruby runtime = context2.runtime;
        return Digest.hexString(Digest.newInstance(runtime, name2, data).finish());
    }

    private static RubyString hexString(RubyString str) {
        byte[] plain = str.getBytes();
        int len = plain.length;
        ByteList bytes = str.getByteList();
        bytes.length(len * 2);
        bytes.invalidate();
        byte[] unsafeBytes = bytes.getUnsafeBytes();
        int index = bytes.getBegin();
        for (int i2 = 0; i2 < len; ++i2) {
            int b = plain[i2] & 0xFF;
            unsafeBytes[index++] = HEX[b >> 4];
            unsafeBytes[index++] = HEX[b & 0xF];
        }
        return str;
    }

    public static class Named
    extends Digest {
        private static final long serialVersionUID = -8794569678070129828L;
        private final RubyString digestName;

        Named(Ruby runtime, RubyClass type, String digestName) {
            super(runtime, type);
            this.digestName = RubyString.newString((Ruby)runtime, (String)digestName);
        }

        @Override
        @JRubyMethod(required=0, optional=1, visibility=Visibility.PRIVATE)
        public IRubyObject initialize(ThreadContext context2, IRubyObject[] args) {
            IRubyObject data = context2.nil;
            if (args.length > 0) {
                data = args[0];
            }
            this.initializeImpl(context2.runtime, this.digestName, data);
            return this;
        }

        @JRubyMethod(meta=true)
        public static RubyString digest(ThreadContext context2, IRubyObject self, IRubyObject data) {
            return Named.newInstance(context2.runtime, (RubyClass)self, data).finish();
        }

        @JRubyMethod(meta=true)
        public static RubyString hexdigest(ThreadContext context2, IRubyObject self, IRubyObject data) {
            Ruby runtime = context2.runtime;
            return Digest.hexString(Named.newInstance(runtime, (RubyClass)self, data).finish());
        }

        private static Named newInstance(Ruby runtime, RubyClass klass, IRubyObject data) {
            String name2 = klass.getBaseName();
            Named instance = new Named(runtime, klass, name2);
            instance.initializeImpl(runtime, instance.digestName, data);
            return instance;
        }
    }

    private static class NamedDigestAllocator
    implements ObjectAllocator {
        private final String digestName;

        NamedDigestAllocator(String digestName) {
            this.digestName = digestName;
        }

        public Named allocate(Ruby runtime, RubyClass klass) {
            return new Named(runtime, klass, this.digestName);
        }
    }
}

