/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.openssl.Digest;
import org.jruby.ext.openssl.OpenSSL;
import org.jruby.ext.openssl.SecurityHelper;
import org.jruby.ext.openssl.SimpleSecretKey;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class HMAC
extends RubyObject {
    private static final long serialVersionUID = 7602535792884680307L;
    private static final ObjectAllocator ALLOCATOR = new ObjectAllocator(){

        public HMAC allocate(Ruby runtime, RubyClass klass) {
            return new HMAC(runtime, klass);
        }
    };
    private Mac mac;
    private byte[] key;
    private ByteList data = new ByteList(64);
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static void createHMAC(Ruby runtime, RubyModule OpenSSL2) {
        RubyClass HMAC2 = OpenSSL2.defineClassUnder("HMAC", runtime.getObject(), ALLOCATOR);
        RubyClass openSSLError = OpenSSL2.getClass("OpenSSLError");
        OpenSSL2.defineClassUnder("HMACError", openSSLError, openSSLError.getAllocator());
        HMAC2.defineAnnotatedMethods(HMAC.class);
    }

    private static Mac getMacInstance(String algorithmName) throws NoSuchAlgorithmException {
        StringBuilder algName = new StringBuilder(5 + algorithmName.length());
        algName.append("HMAC");
        for (int i2 = 0; i2 < algorithmName.length(); ++i2) {
            char c = algorithmName.charAt(i2);
            if (c == '-') continue;
            algName.append(c);
        }
        try {
            return SecurityHelper.getMac(algName.toString());
        }
        catch (NoSuchAlgorithmException e) {
            algName.insert(5, '-');
            return SecurityHelper.getMac(algName.toString());
        }
    }

    @JRubyMethod(name={"digest"}, meta=true)
    public static IRubyObject digest(IRubyObject self, IRubyObject digest2, IRubyObject key, IRubyObject data) {
        Ruby runtime = self.getRuntime();
        String algName = HMAC.getDigestAlgorithmName(digest2);
        byte[] keyBytes = key.asString().getBytes();
        ByteList bytes = data.asString().getByteList();
        try {
            Mac mac = HMAC.getMacInstance(algName);
            mac.init(new SimpleSecretKey(mac.getAlgorithm(), keyBytes));
            mac.update(bytes.getUnsafeBytes(), bytes.getBegin(), bytes.getRealSize());
            return runtime.newString(new ByteList(mac.doFinal(), false));
        }
        catch (NoSuchAlgorithmException e) {
            throw runtime.newNotImplementedError("Unsupported MAC algorithm (HMAC[-]" + algName + ")");
        }
        catch (GeneralSecurityException e) {
            if (OpenSSL.isDebug(runtime)) {
                e.printStackTrace(runtime.getOut());
            }
            throw runtime.newNotImplementedError(e.getMessage());
        }
    }

    @JRubyMethod(name={"hexdigest"}, meta=true)
    public static IRubyObject hexdigest(IRubyObject self, IRubyObject digest2, IRubyObject key, IRubyObject data) {
        Ruby runtime = self.getRuntime();
        String algName = HMAC.getDigestAlgorithmName(digest2);
        byte[] keyBytes = key.asString().getBytes();
        ByteList bytes = data.asString().getByteList();
        try {
            Mac mac = HMAC.getMacInstance(algName);
            mac.init(new SimpleSecretKey(mac.getAlgorithm(), keyBytes));
            mac.update(bytes.getUnsafeBytes(), bytes.getBegin(), bytes.getRealSize());
            return runtime.newString(HMAC.toHEX(mac.doFinal()));
        }
        catch (NoSuchAlgorithmException e) {
            throw runtime.newNotImplementedError("Unsupported MAC algorithm (HMAC[-]" + algName + ")");
        }
        catch (GeneralSecurityException e) {
            if (OpenSSL.isDebug(runtime)) {
                e.printStackTrace(runtime.getOut());
            }
            throw runtime.newNotImplementedError(e.getMessage());
        }
    }

    public HMAC(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject key, IRubyObject digest2) {
        String algName = HMAC.getDigestAlgorithmName(digest2);
        try {
            this.mac = HMAC.getMacInstance(algName);
            this.key = key.asString().getBytes();
            this.mac.init(SimpleSecretKey.copy(this.mac.getAlgorithm(), this.key));
        }
        catch (NoSuchAlgorithmException e) {
            throw this.getRuntime().newNotImplementedError("Unsupported MAC algorithm (HMAC[-]" + algName + ")");
        }
        catch (GeneralSecurityException e) {
            if (OpenSSL.isDebug(this.getRuntime())) {
                e.printStackTrace(this.getRuntime().getOut());
            }
            throw this.getRuntime().newNotImplementedError(e.getMessage());
        }
        return this;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject obj) {
        if (this == obj) {
            return this;
        }
        this.checkFrozen();
        HMAC that = (HMAC)obj;
        String algName = that.mac.getAlgorithm();
        try {
            this.mac = SecurityHelper.getMac(algName);
            this.key = that.key;
            this.mac.init(SimpleSecretKey.copy(algName, this.key));
        }
        catch (NoSuchAlgorithmException e) {
            throw this.getRuntime().newNotImplementedError("Unsupported MAC algorithm (" + algName + ")");
        }
        catch (GeneralSecurityException e) {
            if (OpenSSL.isDebug(this.getRuntime())) {
                e.printStackTrace(this.getRuntime().getOut());
            }
            throw this.getRuntime().newNotImplementedError(e.getMessage());
        }
        this.data = new ByteList(that.data);
        return this;
    }

    @JRubyMethod(name={"update", "<<"})
    public IRubyObject update(IRubyObject obj) {
        this.data.append(obj.asString().getByteList());
        return this;
    }

    @JRubyMethod
    public IRubyObject reset() {
        this.data = new ByteList(64);
        return this;
    }

    @JRubyMethod
    public IRubyObject digest() {
        return RubyString.newString((Ruby)this.getRuntime(), (byte[])this.getSignatureBytes());
    }

    @JRubyMethod(name={"hexdigest", "inspect", "to_s"})
    public IRubyObject hexdigest() {
        return this.getRuntime().newString(HMAC.toHEX(this.getSignatureBytes()));
    }

    String getAlgorithm() {
        return this.mac.getAlgorithm();
    }

    private byte[] getSignatureBytes() {
        this.mac.reset();
        this.mac.update(this.data.getUnsafeBytes(), this.data.getBegin(), this.data.getRealSize());
        return this.mac.doFinal();
    }

    private static String getDigestAlgorithmName(IRubyObject digest2) {
        if (digest2 instanceof Digest) {
            return ((Digest)digest2).getShortAlgorithm();
        }
        return digest2.asString().toString();
    }

    private static ByteList toHEX(byte[] data) {
        ByteList out = new ByteList(data.length * 2);
        for (int i2 = 0; i2 < data.length; ++i2) {
            byte b = data[i2];
            out.append((int)HEX[b >> 4 & 0xF]);
            out.append((int)HEX[b & 0xF]);
        }
        return out;
    }
}

