/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.text;

import java.text.FieldPosition;
import java.text.ParsePosition;
import org.python.icu.impl.PatternProps;
import org.python.icu.text.NFRuleSet;
import org.python.icu.text.NFSubstitution;
import org.python.icu.text.PluralFormat;
import org.python.icu.text.PluralRules;
import org.python.icu.text.RbnfLenientScanner;
import org.python.icu.text.RuleBasedNumberFormat;

final class NFRule {
    public static final int NEGATIVE_NUMBER_RULE = -1;
    public static final int IMPROPER_FRACTION_RULE = -2;
    public static final int PROPER_FRACTION_RULE = -3;
    public static final int MASTER_RULE = -4;
    private long baseValue;
    private int radix = 10;
    private short exponent = 0;
    private String ruleText = null;
    private PluralFormat rulePatternFormat = null;
    private NFSubstitution sub1 = null;
    private NFSubstitution sub2 = null;
    private final RuleBasedNumberFormat formatter;
    private static final String[] RULE_PREFIXES = new String[]{"<<", "<%", "<#", "<0", ">>", ">%", ">#", ">0", "=%", "=#", "=0"};

    public static Object makeRules(String description, NFRuleSet owner, NFRule predecessor, RuleBasedNumberFormat ownersOwner) {
        NFRule rule1 = new NFRule(ownersOwner);
        description = rule1.parseRuleDescriptor(description);
        int brack1 = description.indexOf("[");
        int brack2 = description.indexOf("]");
        if (brack1 == -1 || brack2 == -1 || brack1 > brack2 || rule1.getBaseValue() == -3L || rule1.getBaseValue() == -1L) {
            rule1.extractSubstitutions(owner, description, predecessor);
            return rule1;
        }
        NFRule rule2 = null;
        StringBuilder sbuf = new StringBuilder();
        if (rule1.baseValue > 0L && (double)rule1.baseValue % Math.pow(rule1.radix, rule1.exponent) == 0.0 || rule1.baseValue == -2L || rule1.baseValue == -4L) {
            rule2 = new NFRule(ownersOwner);
            if (rule1.baseValue >= 0L) {
                rule2.baseValue = rule1.baseValue++;
                if (!owner.isFractionSet()) {
                    // empty if block
                }
            } else if (rule1.baseValue == -2L) {
                rule2.baseValue = -3L;
            } else if (rule1.baseValue == -4L) {
                rule2.baseValue = rule1.baseValue;
                rule1.baseValue = -2L;
            }
            rule2.radix = rule1.radix;
            rule2.exponent = rule1.exponent;
            sbuf.append(description.substring(0, brack1));
            if (brack2 + 1 < description.length()) {
                sbuf.append(description.substring(brack2 + 1));
            }
            rule2.extractSubstitutions(owner, sbuf.toString(), predecessor);
        }
        sbuf.setLength(0);
        sbuf.append(description.substring(0, brack1));
        sbuf.append(description.substring(brack1 + 1, brack2));
        if (brack2 + 1 < description.length()) {
            sbuf.append(description.substring(brack2 + 1));
        }
        rule1.extractSubstitutions(owner, sbuf.toString(), predecessor);
        if (rule2 == null) {
            return rule1;
        }
        return new NFRule[]{rule2, rule1};
    }

    public NFRule(RuleBasedNumberFormat formatter) {
        this.formatter = formatter;
    }

    private String parseRuleDescriptor(String description) {
        int p = description.indexOf(":");
        if (p == -1) {
            this.setBaseValue(0L);
        } else {
            String descriptor = description.substring(0, p);
            ++p;
            while (p < description.length() && PatternProps.isWhiteSpace(description.charAt(p))) {
                ++p;
            }
            description = description.substring(p);
            if (descriptor.equals("0.x")) {
                this.setBaseValue(-3L);
            } else if (descriptor.charAt(0) >= '0' && descriptor.charAt(0) <= '9') {
                long tempValue = 0L;
                int descriptorLength = descriptor.length();
                char c = '\u0000';
                for (p = 0; p < descriptorLength; ++p) {
                    c = descriptor.charAt(p);
                    if (c >= '0' && c <= '9') {
                        tempValue = tempValue * 10L + (long)(c - 48);
                        continue;
                    }
                    if (c == '/' || c == '>') break;
                    if (PatternProps.isWhiteSpace(c) || c == ',' || c == '.') continue;
                    throw new IllegalArgumentException("Illegal character " + c + " in rule descriptor");
                }
                this.setBaseValue(tempValue);
                if (c == '/') {
                    tempValue = 0L;
                    ++p;
                    while (p < descriptorLength) {
                        c = descriptor.charAt(p);
                        if (c >= '0' && c <= '9') {
                            tempValue = tempValue * 10L + (long)(c - 48);
                        } else {
                            if (c == '>') break;
                            if (!PatternProps.isWhiteSpace(c) && c != ',' && c != '.') {
                                throw new IllegalArgumentException("Illegal character " + c + " in rule descriptor");
                            }
                        }
                        ++p;
                    }
                    this.radix = (int)tempValue;
                    if (this.radix == 0) {
                        throw new IllegalArgumentException("Rule can't have radix of 0");
                    }
                    this.exponent = this.expectedExponent();
                }
                if (c == '>') {
                    while (p < descriptorLength) {
                        c = descriptor.charAt(p);
                        if (c != '>' || this.exponent <= 0) {
                            throw new IllegalArgumentException("Illegal character in rule descriptor");
                        }
                        this.exponent = (short)(this.exponent - 1);
                        ++p;
                    }
                }
            } else if (descriptor.equals("-x")) {
                this.setBaseValue(-1L);
            } else if (descriptor.equals("x.x")) {
                this.setBaseValue(-2L);
            } else if (descriptor.equals("x.0")) {
                this.setBaseValue(-4L);
            }
        }
        if (description.length() > 0 && description.charAt(0) == '\'') {
            description = description.substring(1);
        }
        return description;
    }

    private void extractSubstitutions(NFRuleSet owner, String ruleText, NFRule predecessor) {
        int pluralRuleEnd;
        this.ruleText = ruleText;
        this.rulePatternFormat = null;
        this.sub1 = this.extractSubstitution(owner, predecessor);
        this.sub2 = this.sub1.isNullSubstitution() ? this.sub1 : this.extractSubstitution(owner, predecessor);
        ruleText = this.ruleText;
        int pluralRuleStart = ruleText.indexOf("$(");
        int n = pluralRuleEnd = pluralRuleStart >= 0 ? ruleText.indexOf(")$", pluralRuleStart) : -1;
        if (pluralRuleEnd >= 0) {
            PluralRules.PluralType pluralType;
            int endType = ruleText.indexOf(44, pluralRuleStart);
            if (endType < 0) {
                throw new IllegalArgumentException("Rule \"" + ruleText + "\" does not have a defined type");
            }
            String type = this.ruleText.substring(pluralRuleStart + 2, endType);
            if ("cardinal".equals(type)) {
                pluralType = PluralRules.PluralType.CARDINAL;
            } else if ("ordinal".equals(type)) {
                pluralType = PluralRules.PluralType.ORDINAL;
            } else {
                throw new IllegalArgumentException(type + " is an unknown type");
            }
            this.rulePatternFormat = this.formatter.createPluralFormat(pluralType, ruleText.substring(endType + 1, pluralRuleEnd));
        }
    }

    private NFSubstitution extractSubstitution(NFRuleSet owner, NFRule predecessor) {
        int subEnd;
        int subStart = NFRule.indexOfAny(this.ruleText, RULE_PREFIXES);
        if (subStart == -1) {
            return NFSubstitution.makeSubstitution(this.ruleText.length(), this, predecessor, owner, this.formatter, "");
        }
        if (this.ruleText.substring(subStart).startsWith(">>>")) {
            subEnd = subStart + 2;
        } else {
            char c = this.ruleText.charAt(subStart);
            subEnd = this.ruleText.indexOf(c, subStart + 1);
            if (c == '<' && subEnd != -1 && subEnd < this.ruleText.length() - 1 && this.ruleText.charAt(subEnd + 1) == c) {
                ++subEnd;
            }
        }
        if (subEnd == -1) {
            return NFSubstitution.makeSubstitution(this.ruleText.length(), this, predecessor, owner, this.formatter, "");
        }
        NFSubstitution result = NFSubstitution.makeSubstitution(subStart, this, predecessor, owner, this.formatter, this.ruleText.substring(subStart, subEnd + 1));
        this.ruleText = this.ruleText.substring(0, subStart) + this.ruleText.substring(subEnd + 1);
        return result;
    }

    final void setBaseValue(long newBaseValue) {
        this.baseValue = newBaseValue;
        if (this.baseValue >= 1L) {
            this.radix = 10;
            this.exponent = this.expectedExponent();
            if (this.sub1 != null) {
                this.sub1.setDivisor(this.radix, this.exponent);
            }
            if (this.sub2 != null) {
                this.sub2.setDivisor(this.radix, this.exponent);
            }
        } else {
            this.radix = 10;
            this.exponent = 0;
        }
    }

    private short expectedExponent() {
        if (this.radix == 0 || this.baseValue < 1L) {
            return 0;
        }
        short tempResult = (short)(Math.log(this.baseValue) / Math.log(this.radix));
        if (Math.pow(this.radix, tempResult + 1) <= (double)this.baseValue) {
            return (short)(tempResult + 1);
        }
        return tempResult;
    }

    private static int indexOfAny(String ruleText, String[] strings) {
        int result = -1;
        if (ruleText.length() > 0) {
            for (String string : strings) {
                int pos = ruleText.indexOf(string);
                if (pos == -1 || result != -1 && pos >= result) continue;
                result = pos;
            }
        }
        return result;
    }

    public boolean equals(Object that) {
        if (that instanceof NFRule) {
            NFRule that2 = (NFRule)that;
            return this.baseValue == that2.baseValue && this.radix == that2.radix && this.exponent == that2.exponent && this.ruleText.equals(that2.ruleText) && this.sub1.equals(that2.sub1) && this.sub2.equals(that2.sub2);
        }
        return false;
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.baseValue == -1L) {
            result.append("-x: ");
        } else if (this.baseValue == -2L) {
            result.append("x.x: ");
        } else if (this.baseValue == -3L) {
            result.append("0.x: ");
        } else if (this.baseValue == -4L) {
            result.append("x.0: ");
        } else {
            result.append(String.valueOf(this.baseValue));
            if (this.radix != 10) {
                result.append('/').append(this.radix);
            }
            int numCarets = this.expectedExponent() - this.exponent;
            for (int i = 0; i < numCarets; ++i) {
                result.append('>');
            }
            result.append(": ");
        }
        if (this.ruleText.startsWith(" ") && (this.sub1 == null || this.sub1.getPos() != 0)) {
            result.append("'");
        }
        StringBuilder ruleTextCopy = new StringBuilder(this.ruleText);
        ruleTextCopy.insert(this.sub2.getPos(), this.sub2.toString());
        ruleTextCopy.insert(this.sub1.getPos(), this.sub1.toString());
        result.append(ruleTextCopy.toString());
        result.append(';');
        return result.toString();
    }

    public final long getBaseValue() {
        return this.baseValue;
    }

    public double getDivisor() {
        return Math.pow(this.radix, this.exponent);
    }

    public void doFormat(long number, StringBuffer toInsertInto, int pos) {
        int pluralRuleStart = this.ruleText.length();
        int lengthOffset = 0;
        if (this.rulePatternFormat == null) {
            toInsertInto.insert(pos, this.ruleText);
        } else {
            pluralRuleStart = this.ruleText.indexOf("$(");
            int pluralRuleEnd = this.ruleText.indexOf(")$", pluralRuleStart);
            int initialLength = toInsertInto.length();
            if (pluralRuleEnd < this.ruleText.length() - 1) {
                toInsertInto.insert(pos, this.ruleText.substring(pluralRuleEnd + 2));
            }
            toInsertInto.insert(pos, this.rulePatternFormat.format((long)((double)number / Math.pow(this.radix, this.exponent))));
            if (pluralRuleStart > 0) {
                toInsertInto.insert(pos, this.ruleText.substring(0, pluralRuleStart));
            }
            lengthOffset = this.ruleText.length() - (toInsertInto.length() - initialLength);
        }
        if (!this.sub2.isNullSubstitution()) {
            this.sub2.doSubstitution(number, toInsertInto, pos - (this.sub2.getPos() > pluralRuleStart ? lengthOffset : 0));
        }
        if (!this.sub1.isNullSubstitution()) {
            this.sub1.doSubstitution(number, toInsertInto, pos - (this.sub1.getPos() > pluralRuleStart ? lengthOffset : 0));
        }
    }

    public void doFormat(double number, StringBuffer toInsertInto, int pos) {
        int pluralRuleStart = this.ruleText.length();
        int lengthOffset = 0;
        if (this.rulePatternFormat == null) {
            toInsertInto.insert(pos, this.ruleText);
        } else {
            pluralRuleStart = this.ruleText.indexOf("$(");
            int pluralRuleEnd = this.ruleText.indexOf(")$", pluralRuleStart);
            int initialLength = toInsertInto.length();
            if (pluralRuleEnd < this.ruleText.length() - 1) {
                toInsertInto.insert(pos, this.ruleText.substring(pluralRuleEnd + 2));
            }
            toInsertInto.insert(pos, this.rulePatternFormat.format((long)(number / Math.pow(this.radix, this.exponent))));
            if (pluralRuleStart > 0) {
                toInsertInto.insert(pos, this.ruleText.substring(0, pluralRuleStart));
            }
            lengthOffset = this.ruleText.length() - (toInsertInto.length() - initialLength);
        }
        if (!this.sub2.isNullSubstitution()) {
            this.sub2.doSubstitution(number, toInsertInto, pos - (this.sub2.getPos() > pluralRuleStart ? lengthOffset : 0));
        }
        if (!this.sub1.isNullSubstitution()) {
            this.sub1.doSubstitution(number, toInsertInto, pos - (this.sub1.getPos() > pluralRuleStart ? lengthOffset : 0));
        }
    }

    public boolean shouldRollBack(double number) {
        return (this.sub1.isModulusSubstitution() || this.sub2.isModulusSubstitution()) && number % Math.pow(this.radix, this.exponent) == 0.0 && (double)this.baseValue % Math.pow(this.radix, this.exponent) != 0.0;
    }

    public Number doParse(String text, ParsePosition parsePosition, boolean isFractionRule, double upperBound) {
        ParsePosition pp = new ParsePosition(0);
        String workText = this.stripPrefix(text, this.ruleText.substring(0, this.sub1.getPos()), pp);
        int prefixLength = text.length() - workText.length();
        if (pp.getIndex() == 0 && this.sub1.getPos() != 0) {
            return 0L;
        }
        int highWaterMark = 0;
        double result = 0.0;
        int start = 0;
        double tempBaseValue = Math.max(0L, this.baseValue);
        do {
            pp.setIndex(0);
            double partialResult = this.matchToDelimiter(workText, start, tempBaseValue, this.ruleText.substring(this.sub1.getPos(), this.sub2.getPos()), this.rulePatternFormat, pp, this.sub1, upperBound).doubleValue();
            if (pp.getIndex() == 0 && !this.sub1.isNullSubstitution()) continue;
            start = pp.getIndex();
            String workText2 = workText.substring(pp.getIndex());
            ParsePosition pp2 = new ParsePosition(0);
            partialResult = this.matchToDelimiter(workText2, 0, partialResult, this.ruleText.substring(this.sub2.getPos()), this.rulePatternFormat, pp2, this.sub2, upperBound).doubleValue();
            if (pp2.getIndex() == 0 && !this.sub2.isNullSubstitution() || prefixLength + pp.getIndex() + pp2.getIndex() <= highWaterMark) continue;
            highWaterMark = prefixLength + pp.getIndex() + pp2.getIndex();
            result = partialResult;
        } while (this.sub1.getPos() != this.sub2.getPos() && pp.getIndex() > 0 && pp.getIndex() < workText.length() && pp.getIndex() != start);
        parsePosition.setIndex(highWaterMark);
        if (isFractionRule && highWaterMark > 0 && this.sub1.isNullSubstitution()) {
            result = 1.0 / result;
        }
        if (result == (double)((long)result)) {
            return (long)result;
        }
        return new Double(result);
    }

    private String stripPrefix(String text, String prefix, ParsePosition pp) {
        if (prefix.length() == 0) {
            return text;
        }
        int pfl = this.prefixLength(text, prefix);
        if (pfl != 0) {
            pp.setIndex(pp.getIndex() + pfl);
            return text.substring(pfl);
        }
        return text;
    }

    private Number matchToDelimiter(String text, int startPos, double baseVal, String delimiter, PluralFormat pluralFormatDelimiter, ParsePosition pp, NFSubstitution sub, double upperBound) {
        if (!this.allIgnorable(delimiter)) {
            ParsePosition tempPP = new ParsePosition(0);
            int[] temp = this.findText(text, delimiter, pluralFormatDelimiter, startPos);
            int dPos = temp[0];
            int dLen = temp[1];
            while (dPos >= 0) {
                String subText = text.substring(0, dPos);
                if (subText.length() > 0) {
                    Number tempResult = sub.doParse(subText, tempPP, baseVal, upperBound, this.formatter.lenientParseEnabled());
                    if (tempPP.getIndex() == dPos) {
                        pp.setIndex(dPos + dLen);
                        return tempResult;
                    }
                }
                tempPP.setIndex(0);
                temp = this.findText(text, delimiter, pluralFormatDelimiter, dPos + dLen);
                dPos = temp[0];
                dLen = temp[1];
            }
            pp.setIndex(0);
            return 0L;
        }
        ParsePosition tempPP = new ParsePosition(0);
        Number result = 0L;
        Number tempResult = sub.doParse(text, tempPP, baseVal, upperBound, this.formatter.lenientParseEnabled());
        if (tempPP.getIndex() != 0 || sub.isNullSubstitution()) {
            pp.setIndex(tempPP.getIndex());
            if (tempResult != null) {
                result = tempResult;
            }
        }
        return result;
    }

    private int prefixLength(String str, String prefix) {
        if (prefix.length() == 0) {
            return 0;
        }
        RbnfLenientScanner scanner = this.formatter.getLenientScanner();
        if (scanner != null) {
            return scanner.prefixLength(str, prefix);
        }
        if (str.startsWith(prefix)) {
            return prefix.length();
        }
        return 0;
    }

    private int[] findText(String str, String key, PluralFormat pluralFormatKey, int startingAt) {
        RbnfLenientScanner scanner = this.formatter.getLenientScanner();
        if (pluralFormatKey != null) {
            FieldPosition position = new FieldPosition(0);
            position.setBeginIndex(startingAt);
            pluralFormatKey.parseType(str, scanner, position);
            int start = position.getBeginIndex();
            if (start >= 0) {
                int pluralRuleStart = this.ruleText.indexOf("$(");
                int pluralRuleSuffix = this.ruleText.indexOf(")$", pluralRuleStart) + 2;
                int matchLen = position.getEndIndex() - start;
                String prefix = this.ruleText.substring(0, pluralRuleStart);
                String suffix = this.ruleText.substring(pluralRuleSuffix);
                if (str.regionMatches(start - prefix.length(), prefix, 0, prefix.length()) && str.regionMatches(start + matchLen, suffix, 0, suffix.length())) {
                    return new int[]{start - prefix.length(), matchLen + prefix.length() + suffix.length()};
                }
            }
            return new int[]{-1, 0};
        }
        if (scanner != null) {
            return scanner.findText(str, key, startingAt);
        }
        return new int[]{str.indexOf(key, startingAt), key.length()};
    }

    private boolean allIgnorable(String str) {
        if (str.length() == 0) {
            return true;
        }
        RbnfLenientScanner scanner = this.formatter.getLenientScanner();
        return scanner != null && scanner.allIgnorable(str);
    }
}

