/*
 * Decompiled with CFR 0.152.
 */
package org.python.netty.handler.ssl;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.python.apache.tomcat.jni.Library;
import org.python.apache.tomcat.jni.Pool;
import org.python.apache.tomcat.jni.SSL;
import org.python.apache.tomcat.jni.SSLContext;
import org.python.netty.handler.ssl.CipherSuiteConverter;
import org.python.netty.handler.ssl.OpenSslEngine;
import org.python.netty.util.internal.NativeLibraryLoader;
import org.python.netty.util.internal.logging.InternalLogger;
import org.python.netty.util.internal.logging.InternalLoggerFactory;

public final class OpenSsl {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(OpenSsl.class);
    private static final Throwable UNAVAILABILITY_CAUSE;
    private static final Set<String> AVAILABLE_CIPHER_SUITES;

    public static boolean isAvailable() {
        return UNAVAILABILITY_CAUSE == null;
    }

    public static void ensureAvailability() {
        if (UNAVAILABILITY_CAUSE != null) {
            throw (Error)new UnsatisfiedLinkError("failed to load the required native library").initCause(UNAVAILABILITY_CAUSE);
        }
    }

    public static Throwable unavailabilityCause() {
        return UNAVAILABILITY_CAUSE;
    }

    public static Set<String> availableCipherSuites() {
        return AVAILABLE_CIPHER_SUITES;
    }

    public static boolean isCipherSuiteAvailable(String cipherSuite) {
        String converted = CipherSuiteConverter.toOpenSsl(cipherSuite);
        if (converted != null) {
            cipherSuite = converted;
        }
        return AVAILABLE_CIPHER_SUITES.contains(cipherSuite);
    }

    static boolean isError(long errorCode) {
        return errorCode != 0L;
    }

    private OpenSsl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Throwable cause = null;
        try {
            NativeLibraryLoader.load("netty-tcnative", SSL.class.getClassLoader());
            Library.initialize((String)"provided");
            SSL.initialize(null);
        }
        catch (Throwable t) {
            cause = t;
            logger.debug("Failed to load netty-tcnative; " + OpenSslEngine.class.getSimpleName() + " will be unavailable.", t);
        }
        UNAVAILABILITY_CAUSE = cause;
        if (cause == null) {
            LinkedHashSet<String> availableCipherSuites = new LinkedHashSet<String>(128);
            long aprPool = Pool.create((long)0L);
            try {
                long sslCtx = SSLContext.make((long)aprPool, (int)28, (int)1);
                try {
                    SSLContext.setOptions((long)sslCtx, (int)4095);
                    SSLContext.setCipherSuite((long)sslCtx, (String)"ALL");
                    long ssl = SSL.newSSL((long)sslCtx, (boolean)true);
                    try {
                        for (String c : SSL.getCiphers((long)ssl)) {
                            if (c == null || c.length() == 0 || availableCipherSuites.contains(c)) continue;
                            availableCipherSuites.add(c);
                        }
                    }
                    finally {
                        SSL.freeSSL((long)ssl);
                    }
                }
                finally {
                    SSLContext.free((long)sslCtx);
                }
            }
            catch (Exception e) {
                logger.warn("Failed to get the list of available OpenSSL cipher suites.", e);
            }
            finally {
                Pool.destroy((long)aprPool);
            }
            AVAILABLE_CIPHER_SUITES = Collections.unmodifiableSet(availableCipherSuites);
        } else {
            AVAILABLE_CIPHER_SUITES = Collections.emptySet();
        }
    }
}

