/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.controlFlow;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowPolicy;
import com.intellij.psi.controlFlow.Instruction;
import com.intellij.psi.controlFlow.ReadVariableInstruction;
import com.intellij.psi.controlFlow.WriteVariableInstruction;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.containers.Queue;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefUseUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInspection.defUse.DefUseUtil");
    private static final ControlFlowPolicy ourPolicy = new ControlFlowPolicy(){

        @Override
        public PsiVariable getUsedVariable(@NotNull PsiReferenceExpression refExpr) {
            if (refExpr == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refExpr", "com/intellij/psi/controlFlow/DefUseUtil$3", "getUsedVariable"));
            }
            if (refExpr.isQualified()) {
                return null;
            }
            PsiElement refElement = refExpr.resolve();
            if (refElement instanceof PsiLocalVariable || refElement instanceof PsiParameter) {
                return (PsiVariable)refElement;
            }
            return null;
        }

        @Override
        public boolean isParameterAccepted(@NotNull PsiParameter psiParameter) {
            if (psiParameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiParameter", "com/intellij/psi/controlFlow/DefUseUtil$3", "isParameterAccepted"));
            }
            return true;
        }

        @Override
        public boolean isLocalVariableAccepted(@NotNull PsiLocalVariable psiVariable) {
            if (psiVariable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiVariable", "com/intellij/psi/controlFlow/DefUseUtil$3", "isLocalVariableAccepted"));
            }
            return true;
        }
    };

    private DefUseUtil() {
    }

    @Nullable
    public static List<Info> getUnusedDefs(PsiCodeBlock body, Set<PsiVariable> outUsedVariables) {
        ControlFlow flow;
        if (body == null) {
            return null;
        }
        try {
            flow = ControlFlowFactory.getInstance(body.getProject()).getControlFlow(body, ourPolicy);
        }
        catch (AnalysisCanceledException e) {
            return null;
        }
        List<Instruction> instructions = flow.getInstructions();
        if (LOG.isDebugEnabled()) {
            LOG.debug(flow.toString());
        }
        THashSet<PsiVariable> assignedVariables = new THashSet<PsiVariable>();
        THashSet<PsiVariable> readVariables = new THashSet<PsiVariable>();
        for (int i = 0; i < instructions.size(); ++i) {
            Instruction instruction = instructions.get(i);
            ProgressManager.checkCanceled();
            if (instruction instanceof WriteVariableInstruction) {
                WriteVariableInstruction writeInstruction = (WriteVariableInstruction)instruction;
                PsiElement context = flow.getElement(i);
                context = PsiTreeUtil.getParentOfType(context, PsiStatement.class, false);
                PsiVariable psiVariable = writeInstruction.variable;
                if (context == null || context instanceof PsiDeclarationStatement && psiVariable.getInitializer() == null) continue;
                assignedVariables.add(psiVariable);
                continue;
            }
            if (!(instruction instanceof ReadVariableInstruction)) continue;
            ReadVariableInstruction readInstruction = (ReadVariableInstruction)instruction;
            readVariables.add(readInstruction.variable);
        }
        InstructionState[] states = DefUseUtil.getStates(instructions);
        boolean[] defsArmed = new boolean[instructions.size()];
        Queue<InstructionState> queue = new Queue<InstructionState>(8);
        for (int i = states.length - 1; i >= 0; --i) {
            InstructionState outerState = states[i];
            if (outerState.isVisited()) continue;
            outerState.touch();
            for (PsiVariable psiVariable : assignedVariables) {
                if (!(psiVariable instanceof PsiField)) continue;
                outerState.mergeUseArmed(psiVariable);
            }
            queue.addLast(outerState);
            while (!queue.isEmpty()) {
                ProgressManager.checkCanceled();
                InstructionState state2 = (InstructionState)queue.pullFirst();
                state2.markVisited();
                int idx = state2.getInstructionIdx();
                if (idx < instructions.size()) {
                    Instruction instruction = instructions.get(idx);
                    if (instruction instanceof WriteVariableInstruction) {
                        WriteVariableInstruction writeInstruction = (WriteVariableInstruction)instruction;
                        PsiVariable psiVariable = writeInstruction.variable;
                        outUsedVariables.add(psiVariable);
                        if (state2.mergeUseDisarmed(psiVariable)) {
                            defsArmed[idx] = true;
                        }
                    } else if (instruction instanceof ReadVariableInstruction) {
                        ReadVariableInstruction readInstruction = (ReadVariableInstruction)instruction;
                        state2.mergeUseArmed(readInstruction.variable);
                        outUsedVariables.add(readInstruction.variable);
                    } else {
                        state2.touch();
                    }
                }
                IntArrayList backwardTraces = state2.getBackwardTraces();
                for (int j = 0; j < backwardTraces.size(); ++j) {
                    int prevIdx = backwardTraces.get(j);
                    InstructionState prevState = states[prevIdx];
                    if (prevState.contains(state2)) continue;
                    prevState.merge(state2);
                    queue.addLast(prevState);
                }
            }
        }
        ArrayList<Info> unusedDefs = new ArrayList<Info>();
        for (int i = 0; i < instructions.size(); ++i) {
            Instruction instruction = instructions.get(i);
            if (!(instruction instanceof WriteVariableInstruction)) continue;
            WriteVariableInstruction writeInstruction = (WriteVariableInstruction)instruction;
            if (defsArmed[i]) continue;
            Object context = PsiTreeUtil.getNonStrictParentOfType(flow.getElement(i), PsiStatement.class, PsiAssignmentExpression.class, PsiPostfixExpression.class, PsiPrefixExpression.class);
            PsiVariable psiVariable = writeInstruction.variable;
            if (context == null || context instanceof PsiTryStatement) continue;
            if (context instanceof PsiDeclarationStatement && psiVariable.getInitializer() == null) {
                if (assignedVariables.contains(psiVariable)) continue;
                unusedDefs.add(new Info(psiVariable, (PsiElement)context, false));
                continue;
            }
            unusedDefs.add(new Info(psiVariable, (PsiElement)context, readVariables.contains(psiVariable)));
        }
        return unusedDefs;
    }

    @NotNull
    public static PsiElement[] getDefs(PsiCodeBlock body, final PsiVariable def, PsiElement ref) {
        PsiElement[] psiElementArray;
        try {
            RefsDefs refsDefs = new RefsDefs(body){
                private final InstructionState[] states;
                {
                    super(body);
                    this.states = DefUseUtil.getStates(this.instructions);
                }

                @Override
                protected int nNext(int index2) {
                    return this.states[index2].getBackwardTraces().size();
                }

                @Override
                protected int getNext(int index2, int no) {
                    return this.states[index2].getBackwardTraces().get(no);
                }

                @Override
                protected boolean defs() {
                    return true;
                }

                @Override
                protected void processInstruction(final Set<PsiElement> res, Instruction instruction, int index2) {
                    if (instruction instanceof WriteVariableInstruction) {
                        WriteVariableInstruction instructionW = (WriteVariableInstruction)instruction;
                        if (instructionW.variable == def) {
                            PsiElement element = this.flow.getElement(index2);
                            element.accept(new JavaRecursiveElementWalkingVisitor(){

                                @Override
                                public void visitReferenceExpression(PsiReferenceExpression ref) {
                                    if (PsiUtil.isAccessedForWriting(ref) && ref.resolve() == def) {
                                        res.add(ref);
                                    }
                                }

                                @Override
                                public void visitVariable(PsiVariable var) {
                                    if (var == def && (var instanceof PsiParameter || var.hasInitializer())) {
                                        res.add(var);
                                    }
                                }
                            });
                        }
                    }
                }
            };
            psiElementArray = refsDefs.get(def, ref);
        }
        catch (AnalysisCanceledException e) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/DefUseUtil", "getDefs"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/DefUseUtil", "getDefs"));
        }
        return psiElementArray;
    }

    @NotNull
    public static PsiElement[] getRefs(PsiCodeBlock body, final PsiVariable def, PsiElement ref) {
        PsiElement[] psiElementArray;
        try {
            RefsDefs refsDefs = new RefsDefs(body){

                @Override
                protected int nNext(int index2) {
                    return ((Instruction)this.instructions.get(index2)).nNext();
                }

                @Override
                protected int getNext(int index2, int no) {
                    return ((Instruction)this.instructions.get(index2)).getNext(index2, no);
                }

                @Override
                protected boolean defs() {
                    return false;
                }

                @Override
                protected void processInstruction(final Set<PsiElement> res, Instruction instruction, int index2) {
                    if (instruction instanceof ReadVariableInstruction) {
                        ReadVariableInstruction instructionR = (ReadVariableInstruction)instruction;
                        if (instructionR.variable == def) {
                            PsiElement element = this.flow.getElement(index2);
                            element.accept(new JavaRecursiveElementWalkingVisitor(){

                                @Override
                                public void visitReferenceExpression(PsiReferenceExpression ref) {
                                    if (ref.resolve() == def) {
                                        res.add(ref);
                                    }
                                }
                            });
                        }
                    }
                }
            };
            psiElementArray = refsDefs.get(def, ref);
        }
        catch (AnalysisCanceledException e) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/DefUseUtil", "getRefs"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/DefUseUtil", "getRefs"));
        }
        return psiElementArray;
    }

    private static InstructionState[] getStates(List<Instruction> instructions) {
        int i;
        InstructionState[] states = new InstructionState[instructions.size()];
        for (i = 0; i < states.length; ++i) {
            states[i] = new InstructionState(i);
        }
        for (i = 0; i < instructions.size(); ++i) {
            Instruction instruction = instructions.get(i);
            for (int j = 0; j != instruction.nNext(); ++j) {
                int next = instruction.getNext(i, j);
                if (next >= states.length) continue;
                states[next].addBackwardTrace(i);
            }
        }
        return states;
    }

    private static abstract class RefsDefs {
        final List<Instruction> instructions;
        final ControlFlow flow;
        final PsiCodeBlock body;

        protected abstract int nNext(int var1);

        protected abstract int getNext(int var1, int var2);

        protected RefsDefs(PsiCodeBlock body) throws AnalysisCanceledException {
            this.body = body;
            this.flow = ControlFlowFactory.getInstance(body.getProject()).getControlFlow(body, ourPolicy);
            this.instructions = this.flow.getInstructions();
        }

        protected abstract void processInstruction(Set<PsiElement> var1, Instruction var2, int var3);

        protected abstract boolean defs();

        @NotNull
        private PsiElement[] get(final PsiVariable def, PsiElement refOrDef) {
            int elem;
            if (this.body == null) {
                if (PsiElement.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/DefUseUtil$RefsDefs", "get"));
                }
                return PsiElement.EMPTY_ARRAY;
            }
            final boolean[] visited2 = new boolean[this.instructions.size() + 1];
            visited2[visited2.length - 1] = true;
            int n = elem = this.defs() ? this.flow.getStartOffset(refOrDef) : this.flow.getEndOffset(refOrDef);
            if (elem == -1 && def instanceof PsiParameter) {
                elem = 0;
            }
            if (elem != -1) {
                if (!this.defs() && this.instructions.get(elem) instanceof ReadVariableInstruction) {
                    LOG.assertTrue(this.nNext(elem) == 1);
                    LOG.assertTrue(this.getNext(elem, 0) == elem + 1);
                    ++elem;
                }
                final THashSet res = new THashSet();
                class Inner {
                    Inner() {
                    }

                    void traverse(int index2) {
                        visited2[index2] = true;
                        if (RefsDefs.this.defs()) {
                            Instruction instruction = RefsDefs.this.instructions.get(index2);
                            RefsDefs.this.processInstruction(res, instruction, index2);
                            if (instruction instanceof WriteVariableInstruction) {
                                WriteVariableInstruction instructionW = (WriteVariableInstruction)instruction;
                                if (instructionW.variable == def) {
                                    return;
                                }
                            }
                            if (index2 == 0 && def instanceof PsiParameter) {
                                res.add(def.getNameIdentifier());
                            }
                        }
                        int nNext = RefsDefs.this.nNext(index2);
                        for (int i = 0; i < nNext; ++i) {
                            int prev = RefsDefs.this.getNext(index2, i);
                            if (visited2[prev]) continue;
                            if (!RefsDefs.this.defs()) {
                                Instruction instruction = RefsDefs.this.instructions.get(prev);
                                if (instruction instanceof WriteVariableInstruction) {
                                    WriteVariableInstruction instructionW = (WriteVariableInstruction)instruction;
                                    if (instructionW.variable == def) {
                                        continue;
                                    }
                                } else {
                                    RefsDefs.this.processInstruction(res, instruction, prev);
                                }
                            }
                            this.traverse(prev);
                        }
                    }
                }
                new Inner().traverse(elem);
                PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(res);
                if (psiElementArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/DefUseUtil$RefsDefs", "get"));
                }
                return psiElementArray;
            }
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/DefUseUtil$RefsDefs", "get"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
    }

    private static class InstructionState {
        private Set<PsiVariable> myVariablesUseArmed;
        private final int myInstructionIdx;
        private final IntArrayList myBackwardTraces;
        private boolean myIsVisited = false;

        public InstructionState(int instructionIdx) {
            this.myInstructionIdx = instructionIdx;
            this.myBackwardTraces = new IntArrayList();
            this.myVariablesUseArmed = null;
        }

        public void addBackwardTrace(int i) {
            this.myBackwardTraces.add(i);
        }

        public IntArrayList getBackwardTraces() {
            return this.myBackwardTraces;
        }

        public int getInstructionIdx() {
            return this.myInstructionIdx;
        }

        void mergeUseArmed(PsiVariable psiVariable) {
            this.touch();
            this.myVariablesUseArmed.add(psiVariable);
        }

        boolean mergeUseDisarmed(PsiVariable psiVariable) {
            this.touch();
            boolean result2 = this.myVariablesUseArmed.contains(psiVariable);
            this.myVariablesUseArmed.remove(psiVariable);
            return result2;
        }

        private void touch() {
            if (this.myVariablesUseArmed == null) {
                this.myVariablesUseArmed = new THashSet<PsiVariable>();
            }
        }

        public void merge(InstructionState state2) {
            this.touch();
            this.myVariablesUseArmed.addAll(state2.myVariablesUseArmed);
        }

        public boolean contains(InstructionState state2) {
            return this.myVariablesUseArmed != null && state2.myVariablesUseArmed != null && this.myVariablesUseArmed.containsAll(state2.myVariablesUseArmed);
        }

        public boolean markVisited() {
            boolean old = this.myIsVisited;
            this.myIsVisited = true;
            return old;
        }

        public boolean isVisited() {
            return this.myIsVisited;
        }
    }

    public static class Info {
        private final PsiVariable myVariable;
        private final PsiElement myContext;
        private final boolean myIsRead;

        public Info(PsiVariable variable, PsiElement context, boolean read) {
            this.myVariable = variable;
            this.myContext = context;
            this.myIsRead = read;
        }

        public PsiVariable getVariable() {
            return this.myVariable;
        }

        public PsiElement getContext() {
            return this.myContext;
        }

        public boolean isRead() {
            return this.myIsRead;
        }
    }
}

