/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.KtLightClass;
import org.jetbrains.kotlin.asJava.KtLightPackage;
import org.jetbrains.kotlin.asJava.LightClassGenerationSupport;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.jvm.KotlinFinderMarker;

public class JavaElementFinder
extends PsiElementFinder
implements KotlinFinderMarker {
    private final Project project;
    private final PsiManager psiManager;
    private final LightClassGenerationSupport lightClassGenerationSupport;

    @NotNull
    public static JavaElementFinder getInstance(@NotNull Project project) {
        PsiElementFinder[] extensions;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/asJava/JavaElementFinder", "getInstance"));
        }
        for (PsiElementFinder extension : extensions = Extensions.getArea(project).getExtensionPoint(PsiElementFinder.EP_NAME).getExtensions()) {
            if (!(extension instanceof JavaElementFinder)) continue;
            JavaElementFinder javaElementFinder = (JavaElementFinder)extension;
            if (javaElementFinder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/JavaElementFinder", "getInstance"));
            }
            return javaElementFinder;
        }
        throw new IllegalStateException(JavaElementFinder.class.getSimpleName() + " is not found for project " + project);
    }

    public JavaElementFinder(@NotNull Project project, @NotNull LightClassGenerationSupport lightClassGenerationSupport) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/asJava/JavaElementFinder", "<init>"));
        }
        if (lightClassGenerationSupport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lightClassGenerationSupport", "org/jetbrains/kotlin/asJava/JavaElementFinder", "<init>"));
        }
        this.project = project;
        this.psiManager = PsiManager.getInstance(project);
        this.lightClassGenerationSupport = lightClassGenerationSupport;
    }

    @Override
    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/kotlin/asJava/JavaElementFinder", "findClass"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/asJava/JavaElementFinder", "findClass"));
        }
        PsiClass[] allClasses = this.findClasses(qualifiedName, scope);
        return allClasses.length > 0 ? allClasses[0] : null;
    }

    @Override
    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedNameString, @NotNull GlobalSearchScope scope) {
        if (qualifiedNameString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedNameString", "org/jetbrains/kotlin/asJava/JavaElementFinder", "findClasses"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/asJava/JavaElementFinder", "findClasses"));
        }
        if (!FqNamesUtilKt.isValidJavaFqName(qualifiedNameString)) {
            if (PsiClass.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/JavaElementFinder", "findClasses"));
            }
            return PsiClass.EMPTY_ARRAY;
        }
        SmartList<PsiClass> answer = new SmartList<PsiClass>();
        FqName qualifiedName = new FqName(qualifiedNameString);
        this.findClassesAndObjects(qualifiedName, scope, answer);
        answer.addAll(this.lightClassGenerationSupport.getFacadeClasses(qualifiedName, scope));
        answer.addAll(this.lightClassGenerationSupport.getMultifilePartClasses(qualifiedName, scope));
        PsiClass[] psiClassArray = JavaElementFinder.sortByClasspath(answer, scope).toArray(new PsiClass[answer.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/JavaElementFinder", "findClasses"));
        }
        return psiClassArray;
    }

    private void findClassesAndObjects(FqName qualifiedName, GlobalSearchScope scope, List<PsiClass> answer) {
        this.findInterfaceDefaultImpls(qualifiedName, scope, answer);
        Collection<KtClassOrObject> classOrObjectDeclarations = this.lightClassGenerationSupport.findClassOrObjectDeclarations(qualifiedName, scope);
        for (KtClassOrObject declaration : classOrObjectDeclarations) {
            KtLightClass lightClass;
            if (declaration instanceof KtEnumEntry || (lightClass = LightClassUtilsKt.toLightClass(declaration)) == null) continue;
            answer.add(lightClass);
        }
    }

    private void findInterfaceDefaultImpls(FqName qualifiedName, GlobalSearchScope scope, List<PsiClass> answer) {
        if (qualifiedName.isRoot()) {
            return;
        }
        if (!qualifiedName.shortName().asString().equals("DefaultImpls")) {
            return;
        }
        for (KtClassOrObject classOrObject : this.lightClassGenerationSupport.findClassOrObjectDeclarations(qualifiedName.parent(), scope)) {
            PsiClass implsClass;
            KtLightClass interfaceClass;
            if (!(classOrObject instanceof KtClass) || !((KtClass)classOrObject).isInterface() || (interfaceClass = LightClassUtilsKt.toLightClass(classOrObject)) == null || (implsClass = interfaceClass.findInnerClassByName("DefaultImpls", false)) == null) continue;
            answer.add(implsClass);
        }
    }

    @Override
    @NotNull
    public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "org/jetbrains/kotlin/asJava/JavaElementFinder", "getClassNames"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/asJava/JavaElementFinder", "getClassNames"));
        }
        FqName packageFQN = new FqName(psiPackage.getQualifiedName());
        Collection<KtClassOrObject> declarations = this.lightClassGenerationSupport.findClassOrObjectDeclarationsInPackage(packageFQN, scope);
        HashSet<String> answer = Sets.newHashSet();
        answer.addAll(this.lightClassGenerationSupport.getFacadeNames(packageFQN, scope));
        for (KtClassOrObject declaration : declarations) {
            String name = declaration.getName();
            if (name == null) continue;
            answer.add(name);
        }
        HashSet<String> hashSet = answer;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/JavaElementFinder", "getClassNames"));
        }
        return hashSet;
    }

    @Override
    public PsiPackage findPackage(@NotNull String qualifiedNameString) {
        if (qualifiedNameString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedNameString", "org/jetbrains/kotlin/asJava/JavaElementFinder", "findPackage"));
        }
        if (!FqNamesUtilKt.isValidJavaFqName(qualifiedNameString)) {
            return null;
        }
        FqName fqName2 = new FqName(qualifiedNameString);
        GlobalSearchScope allScope = GlobalSearchScope.allScope(this.project);
        if (this.lightClassGenerationSupport.packageExists(fqName2, allScope)) {
            return new KtLightPackage(this.psiManager, fqName2, allScope);
        }
        return null;
    }

    @Override
    @NotNull
    public PsiPackage[] getSubPackages(@NotNull PsiPackage psiPackage, final @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "org/jetbrains/kotlin/asJava/JavaElementFinder", "getSubPackages"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/asJava/JavaElementFinder", "getSubPackages"));
        }
        FqName packageFQN = new FqName(psiPackage.getQualifiedName());
        Collection<FqName> subpackages = this.lightClassGenerationSupport.getSubPackages(packageFQN, scope);
        Collection<PsiPackage> answer = Collections2.transform(subpackages, new Function<FqName, PsiPackage>(){

            @Override
            public PsiPackage apply(@Nullable FqName input) {
                return new KtLightPackage(JavaElementFinder.this.psiManager, input, scope);
            }
        });
        PsiPackage[] psiPackageArray = answer.toArray(new PsiPackage[answer.size()]);
        if (psiPackageArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/JavaElementFinder", "getSubPackages"));
        }
        return psiPackageArray;
    }

    @Override
    @NotNull
    public PsiClass[] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "org/jetbrains/kotlin/asJava/JavaElementFinder", "getClasses"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/asJava/JavaElementFinder", "getClasses"));
        }
        SmartList<PsiClass> answer = new SmartList<PsiClass>();
        FqName packageFQN = new FqName(psiPackage.getQualifiedName());
        answer.addAll(this.lightClassGenerationSupport.getFacadeClassesInPackage(packageFQN, scope));
        Collection<KtClassOrObject> declarations = this.lightClassGenerationSupport.findClassOrObjectDeclarationsInPackage(packageFQN, scope);
        for (KtClassOrObject declaration : declarations) {
            KtLightClass aClass2 = LightClassUtilsKt.toLightClass(declaration);
            if (aClass2 == null) continue;
            answer.add(aClass2);
        }
        PsiClass[] psiClassArray = JavaElementFinder.sortByClasspath(answer, scope).toArray(new PsiClass[answer.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/JavaElementFinder", "getClasses"));
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    public PsiFile[] getPackageFiles(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "org/jetbrains/kotlin/asJava/JavaElementFinder", "getPackageFiles"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/asJava/JavaElementFinder", "getPackageFiles"));
        }
        FqName packageFQN = new FqName(psiPackage.getQualifiedName());
        Collection<KtFile> result2 = this.lightClassGenerationSupport.findFilesForPackage(packageFQN, scope);
        PsiFile[] psiFileArray = result2.toArray(new PsiFile[result2.size()]);
        if (psiFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/JavaElementFinder", "getPackageFiles"));
        }
        return psiFileArray;
    }

    @Override
    @Nullable
    public Condition<PsiFile> getPackageFilesFilter(final @NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "org/jetbrains/kotlin/asJava/JavaElementFinder", "getPackageFilesFilter"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/asJava/JavaElementFinder", "getPackageFilesFilter"));
        }
        return new Condition<PsiFile>(){

            @Override
            public boolean value(PsiFile input) {
                if (!(input instanceof KtFile)) {
                    return true;
                }
                return psiPackage.getQualifiedName().equals(((KtFile)input).getPackageFqName().asString());
            }
        };
    }

    @NotNull
    public static Comparator<PsiElement> byClasspathComparator(final @NotNull GlobalSearchScope searchScope) {
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "org/jetbrains/kotlin/asJava/JavaElementFinder", "byClasspathComparator"));
        }
        Comparator<PsiElement> comparator = new Comparator<PsiElement>(){

            @Override
            public int compare(@NotNull PsiElement o1, @NotNull PsiElement o2) {
                VirtualFile f2;
                if (o1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "org/jetbrains/kotlin/asJava/JavaElementFinder$3", "compare"));
                }
                if (o2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "org/jetbrains/kotlin/asJava/JavaElementFinder$3", "compare"));
                }
                VirtualFile f1 = PsiUtilCore.getVirtualFile(o1);
                if (f1 == (f2 = PsiUtilCore.getVirtualFile(o2))) {
                    return 0;
                }
                if (f1 == null) {
                    return -1;
                }
                if (f2 == null) {
                    return 1;
                }
                return searchScope.compare(f2, f1);
            }
        };
        if (comparator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/JavaElementFinder", "byClasspathComparator"));
        }
        return comparator;
    }

    private static Collection<PsiClass> sortByClasspath(@NotNull List<PsiClass> classes2, @NotNull GlobalSearchScope searchScope) {
        if (classes2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "org/jetbrains/kotlin/asJava/JavaElementFinder", "sortByClasspath"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "org/jetbrains/kotlin/asJava/JavaElementFinder", "sortByClasspath"));
        }
        if (classes2.size() > 1) {
            ContainerUtil.quickSort(classes2, JavaElementFinder.byClasspathComparator(searchScope));
        }
        return classes2;
    }
}

