/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.builtins;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/builtins/CompanionObjectMapping;", "", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "(Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;)V", "classes", "Ljava/util/LinkedHashSet;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "allClassesWithIntrinsicCompanions", "", "hasMappingToObject", "", "classDescriptor", "kotlin-compiler"})
public final class CompanionObjectMapping {
    private final LinkedHashSet<ClassDescriptor> classes;
    private final KotlinBuiltIns builtIns;

    @NotNull
    public final Set<ClassDescriptor> allClassesWithIntrinsicCompanions() {
        Set<ClassDescriptor> set = Collections.unmodifiableSet((Set)this.classes);
        Intrinsics.checkExpressionValueIsNotNull(set, "Collections.unmodifiableSet(classes)");
        return set;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasMappingToObject(@NotNull ClassDescriptor classDescriptor) {
        Intrinsics.checkParameterIsNotNull(classDescriptor, "classDescriptor");
        if (!DescriptorUtils.isCompanionObject(classDescriptor)) return false;
        Iterable iterable = this.classes;
        DeclarationDescriptor declarationDescriptor = classDescriptor.getContainingDeclaration();
        Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "classDescriptor.containingDeclaration");
        if (!CollectionsKt.contains(iterable, declarationDescriptor)) return false;
        return true;
    }

    public CompanionObjectMapping(@NotNull KotlinBuiltIns builtIns) {
        Intrinsics.checkParameterIsNotNull(builtIns, "builtIns");
        this.builtIns = builtIns;
        this.classes = SetsKt.linkedSetOf(new ClassDescriptor[0]);
        for (PrimitiveType type2 : PrimitiveType.NUMBER_TYPES) {
            this.classes.add(this.builtIns.getPrimitiveClassDescriptor(type2));
        }
        this.classes.add(this.builtIns.getString());
        this.classes.add(this.builtIns.getEnum());
    }
}

