/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.context;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsScope;
import com.google.dart.compiler.backend.js.ast.metadata.MetadataProperties;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.js.inline.FunctionReader;
import org.jetbrains.kotlin.js.inline.util.FunctionUtilsKt;
import org.jetbrains.kotlin.js.inline.util.InvocationUtilsKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\b\u001a\u00020\tH\u0002J\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/js/inline/context/FunctionContext;", "", "function", "Lcom/google/dart/compiler/backend/js/ast/JsFunction;", "functionReader", "Lorg/jetbrains/kotlin/js/inline/FunctionReader;", "(Lcom/google/dart/compiler/backend/js/ast/JsFunction;Lorg/jetbrains/kotlin/js/inline/FunctionReader;)V", "getFunctionDefinition", "call", "Lcom/google/dart/compiler/backend/js/ast/JsInvocation;", "getFunctionDefinitionImpl", "getScope", "Lcom/google/dart/compiler/backend/js/ast/JsScope;", "hasFunctionDefinition", "", "lookUpStaticFunction", "functionName", "Lcom/google/dart/compiler/backend/js/ast/JsName;", "kotlin-compiler"})
public abstract class FunctionContext {
    private final JsFunction function;
    private final FunctionReader functionReader;

    @Nullable
    protected abstract JsFunction lookUpStaticFunction(@Nullable JsName var1);

    @NotNull
    public final JsFunction getFunctionDefinition(@NotNull JsInvocation call) {
        Intrinsics.checkParameterIsNotNull(call, "call");
        JsFunction jsFunction = this.getFunctionDefinitionImpl(call);
        if (jsFunction == null) {
            Intrinsics.throwNpe();
        }
        return jsFunction;
    }

    public final boolean hasFunctionDefinition(@NotNull JsInvocation call) {
        Intrinsics.checkParameterIsNotNull(call, "call");
        return this.getFunctionDefinitionImpl(call) != null;
    }

    @NotNull
    public final JsScope getScope() {
        JsScope jsScope = this.function.getScope();
        Intrinsics.checkExpressionValueIsNotNull(jsScope, "function.scope");
        return jsScope;
    }

    private final JsFunction getFunctionDefinitionImpl(JsInvocation call) {
        JsFunction jsFunction;
        JsExpression qualifier;
        JsExpression jsExpression;
        CallableDescriptor descriptor2 = MetadataProperties.getDescriptor(call);
        if (descriptor2 != null && this.functionReader.contains(descriptor2)) {
            return this.functionReader.get(descriptor2);
        }
        if (InvocationUtilsKt.isCallInvocation(call)) {
            JsExpression jsExpression2 = call.getQualifier();
            if (jsExpression2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.google.dart.compiler.backend.js.ast.JsNameRef");
            }
            JsExpression jsExpression3 = ((JsNameRef)jsExpression2).getQualifier();
            if (jsExpression3 == null) {
                Intrinsics.throwNpe();
            }
            jsExpression = jsExpression3;
            Intrinsics.checkExpressionValueIsNotNull(jsExpression3, "(call.qualifier as JsNameRef).qualifier!!");
        } else {
            JsExpression jsExpression4 = call.getQualifier();
            jsExpression = jsExpression4;
            Intrinsics.checkExpressionValueIsNotNull(jsExpression4, "call.qualifier");
        }
        JsExpression callQualifier = jsExpression;
        JsExpression jsExpression5 = qualifier = InvocationUtilsKt.getTransitiveStaticRef(callQualifier);
        if (jsExpression5 instanceof JsInvocation) {
            JsName jsName = InvocationUtilsKt.getSimpleName((JsInvocation)qualifier);
            if (jsName == null) {
                Intrinsics.throwNpe();
            }
            JsFunction jsFunction2 = this.lookUpStaticFunction(jsName);
            if (jsFunction2 != null) {
                JsFunction jsFunction3 = jsFunction2;
                JsFunction it = jsFunction3;
                jsFunction = FunctionUtilsKt.isFunctionCreator(it) ? it : (JsFunction)null;
            } else {
                jsFunction = null;
            }
        } else {
            jsFunction = jsExpression5 instanceof JsNameRef ? this.lookUpStaticFunction(((JsNameRef)qualifier).getName()) : (jsExpression5 instanceof JsFunction ? (JsFunction)qualifier : (JsFunction)null);
        }
        return jsFunction;
    }

    public FunctionContext(@NotNull JsFunction function, @NotNull FunctionReader functionReader) {
        Intrinsics.checkParameterIsNotNull(function, "function");
        Intrinsics.checkParameterIsNotNull(functionReader, "functionReader");
        this.function = function;
        this.functionReader = functionReader;
    }
}

