/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptorKt;
import org.jetbrains.kotlin.js.translate.context.TemporaryVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.reference.CachedAccessTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;

public final class BackingFieldAccessTranslator
extends AbstractTranslator
implements CachedAccessTranslator {
    @NotNull
    private final PropertyDescriptor descriptor;

    public static BackingFieldAccessTranslator newInstance(@NotNull KtSimpleNameExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/reference/BackingFieldAccessTranslator", "newInstance"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/BackingFieldAccessTranslator", "newInstance"));
        }
        PropertyDescriptor referencedProperty = SyntheticFieldDescriptorKt.getReferencedProperty(BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), expression));
        assert (referencedProperty != null);
        return new BackingFieldAccessTranslator(referencedProperty, context);
    }

    private BackingFieldAccessTranslator(@NotNull PropertyDescriptor descriptor2, @NotNull TranslationContext context) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/reference/BackingFieldAccessTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/BackingFieldAccessTranslator", "<init>"));
        }
        super(context);
        this.descriptor = descriptor2;
    }

    @Override
    @NotNull
    public JsExpression translateAsGet() {
        JsNameRef jsNameRef = TranslationUtils.backingFieldReference(this.context(), this.descriptor);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/BackingFieldAccessTranslator", "translateAsGet"));
        }
        return jsNameRef;
    }

    @Override
    @NotNull
    public JsExpression translateAsSet(@NotNull JsExpression setTo) {
        if (setTo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "setTo", "org/jetbrains/kotlin/js/translate/reference/BackingFieldAccessTranslator", "translateAsSet"));
        }
        JsExpression jsExpression = TranslationUtils.assignmentToBackingField(this.context(), this.descriptor, setTo);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/BackingFieldAccessTranslator", "translateAsSet"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public CachedAccessTranslator getCached() {
        BackingFieldAccessTranslator backingFieldAccessTranslator = this;
        if (backingFieldAccessTranslator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/BackingFieldAccessTranslator", "getCached"));
        }
        return backingFieldAccessTranslator;
    }

    @Override
    @NotNull
    public List<TemporaryVariable> declaredTemporaries() {
        List<TemporaryVariable> list2 = Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/BackingFieldAccessTranslator", "declaredTemporaries"));
        }
        return list2;
    }
}

