/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.js.translate.context.TemporaryVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.intrinsic.objects.ObjectIntrinsic;
import org.jetbrains.kotlin.js.translate.reference.CachedAccessTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;

public class CompanionObjectIntrinsicAccessTranslator
extends AbstractTranslator
implements CachedAccessTranslator {
    @NotNull
    private final JsExpression referenceToCompanionObject;

    @NotNull
    static CompanionObjectIntrinsicAccessTranslator newInstance(@NotNull KtSimpleNameExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/reference/CompanionObjectIntrinsicAccessTranslator", "newInstance"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/CompanionObjectIntrinsicAccessTranslator", "newInstance"));
        }
        DeclarationDescriptor referenceDescriptor = BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), expression);
        assert (referenceDescriptor != null) : "JetSimpleName expression must reference a descriptor " + expression.getText();
        CompanionObjectIntrinsicAccessTranslator companionObjectIntrinsicAccessTranslator = new CompanionObjectIntrinsicAccessTranslator(referenceDescriptor, context);
        if (companionObjectIntrinsicAccessTranslator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CompanionObjectIntrinsicAccessTranslator", "newInstance"));
        }
        return companionObjectIntrinsicAccessTranslator;
    }

    static boolean isCompanionObjectReference(@NotNull KtReferenceExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/reference/CompanionObjectIntrinsicAccessTranslator", "isCompanionObjectReference"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/CompanionObjectIntrinsicAccessTranslator", "isCompanionObjectReference"));
        }
        DeclarationDescriptor descriptor2 = BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), expression);
        return descriptor2 instanceof ClassDescriptor && context.intrinsics().getObjectIntrinsic((ClassDescriptor)descriptor2).exists();
    }

    private CompanionObjectIntrinsicAccessTranslator(@NotNull DeclarationDescriptor descriptor2, @NotNull TranslationContext context) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/reference/CompanionObjectIntrinsicAccessTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/CompanionObjectIntrinsicAccessTranslator", "<init>"));
        }
        super(context);
        this.referenceToCompanionObject = CompanionObjectIntrinsicAccessTranslator.generateReferenceToCompanionObject(descriptor2, context);
    }

    @NotNull
    private static JsExpression generateReferenceToCompanionObject(@NotNull DeclarationDescriptor descriptor2, @NotNull TranslationContext context) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/reference/CompanionObjectIntrinsicAccessTranslator", "generateReferenceToCompanionObject"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/CompanionObjectIntrinsicAccessTranslator", "generateReferenceToCompanionObject"));
        }
        ObjectIntrinsic objectIntrinsic = context.intrinsics().getObjectIntrinsic((ClassDescriptor)descriptor2);
        JsExpression jsExpression = objectIntrinsic.apply(context);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CompanionObjectIntrinsicAccessTranslator", "generateReferenceToCompanionObject"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsExpression translateAsGet() {
        JsExpression jsExpression = this.referenceToCompanionObject;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CompanionObjectIntrinsicAccessTranslator", "translateAsGet"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsExpression translateAsSet(@NotNull JsExpression toSetTo) {
        if (toSetTo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toSetTo", "org/jetbrains/kotlin/js/translate/reference/CompanionObjectIntrinsicAccessTranslator", "translateAsSet"));
        }
        throw new IllegalStateException("companion object can't be set");
    }

    @Override
    @NotNull
    public CachedAccessTranslator getCached() {
        CompanionObjectIntrinsicAccessTranslator companionObjectIntrinsicAccessTranslator = this;
        if (companionObjectIntrinsicAccessTranslator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CompanionObjectIntrinsicAccessTranslator", "getCached"));
        }
        return companionObjectIntrinsicAccessTranslator;
    }

    @Override
    @NotNull
    public List<TemporaryVariable> declaredTemporaries() {
        List<TemporaryVariable> list2 = Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CompanionObjectIntrinsicAccessTranslator", "declaredTemporaries"));
        }
        return list2;
    }
}

