/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java;

import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.load.java.lazy.types.LazyJavaTypeResolver;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/load/java/InternalFlexibleTypeTransformer;", "Lorg/jetbrains/kotlin/resolve/TypeResolver$TypeTransformerForTests;", "()V", "FLEXIBLE_TYPE_CLASSIFIER", "Lorg/jetbrains/kotlin/name/ClassId;", "transformType", "Lorg/jetbrains/kotlin/types/KotlinType;", "kotlinType", "kotlin-compiler"})
public final class InternalFlexibleTypeTransformer
extends TypeResolver.TypeTransformerForTests {
    @JvmField
    @NotNull
    public static final ClassId FLEXIBLE_TYPE_CLASSIFIER;
    public static final InternalFlexibleTypeTransformer INSTANCE;

    @Override
    @Nullable
    public KotlinType transformType(@NotNull KotlinType kotlinType) {
        Intrinsics.checkParameterIsNotNull(kotlinType, "kotlinType");
        ClassifierDescriptor descriptor2 = kotlinType.getConstructor().getDeclarationDescriptor();
        if (descriptor2 != null && Intrinsics.areEqual(FLEXIBLE_TYPE_CLASSIFIER.asSingleFqName().toUnsafe(), DescriptorUtils.getFqName(descriptor2)) && kotlinType.getArguments().size() == 2) {
            KotlinType kotlinType2 = kotlinType.getArguments().get(0).getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "kotlinType.arguments[0].type");
            KotlinType kotlinType3 = kotlinType.getArguments().get(1).getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType3, "kotlinType.arguments[1].type");
            return LazyJavaTypeResolver.FlexibleJavaClassifierTypeFactory.INSTANCE.create(kotlinType2, kotlinType3);
        }
        return null;
    }

    private InternalFlexibleTypeTransformer() {
        INSTANCE = this;
        ClassId classId = ClassId.topLevel(new FqName("kotlin.internal.flexible.ft"));
        Intrinsics.checkExpressionValueIsNotNull(classId, "ClassId.topLevel(FqName(\u2026n.internal.flexible.ft\"))");
        FLEXIBLE_TYPE_CLASSIFIER = classId;
    }

    static {
        new InternalFlexibleTypeTransformer();
    }
}

