/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.results;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.OverrideResolver;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallImpl;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.calls.results.OverloadingConflictResolver;
import org.jetbrains.kotlin.resolve.calls.results.ResolutionStatus;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;

public class ResolutionResultsHandler {
    private final OverloadingConflictResolver overloadingConflictResolver;

    public ResolutionResultsHandler(@NotNull OverloadingConflictResolver overloadingConflictResolver) {
        if (overloadingConflictResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overloadingConflictResolver", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "<init>"));
        }
        this.overloadingConflictResolver = overloadingConflictResolver;
    }

    @NotNull
    public <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> computeResultAndReportErrors(@NotNull CallResolutionContext context, @NotNull TracingStrategy tracing, @NotNull Collection<MutableResolvedCall<D>> candidates) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeResultAndReportErrors"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeResultAndReportErrors"));
        }
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeResultAndReportErrors"));
        }
        LinkedHashSet<MutableResolvedCall<D>> successfulCandidates = Sets.newLinkedHashSet();
        LinkedHashSet<MutableResolvedCall<D>> failedCandidates = Sets.newLinkedHashSet();
        LinkedHashSet<MutableResolvedCall<D>> incompleteCandidates = Sets.newLinkedHashSet();
        LinkedHashSet candidatesWithWrongReceiver = Sets.newLinkedHashSet();
        for (MutableResolvedCall<D> candidateCall : candidates) {
            ResolutionStatus status2 = candidateCall.getStatus();
            assert (status2 != ResolutionStatus.UNKNOWN_STATUS) : "No resolution for " + candidateCall.getCandidateDescriptor();
            if (status2.isSuccess()) {
                successfulCandidates.add(candidateCall);
                continue;
            }
            if (status2 == ResolutionStatus.INCOMPLETE_TYPE_INFERENCE) {
                incompleteCandidates.add(candidateCall);
                continue;
            }
            if (candidateCall.getStatus() == ResolutionStatus.RECEIVER_TYPE_ERROR) {
                candidatesWithWrongReceiver.add(candidateCall);
                continue;
            }
            if (candidateCall.getStatus() == ResolutionStatus.RECEIVER_PRESENCE_ERROR) continue;
            failedCandidates.add(candidateCall);
        }
        if (!successfulCandidates.isEmpty() || !incompleteCandidates.isEmpty()) {
            OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = this.computeSuccessfulResult(context, tracing, successfulCandidates, incompleteCandidates, context.checkArguments);
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeResultAndReportErrors"));
            }
            return overloadResolutionResultsImpl;
        }
        if (!failedCandidates.isEmpty()) {
            OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = this.computeFailedResult(tracing, context.trace, failedCandidates, context.checkArguments);
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeResultAndReportErrors"));
            }
            return overloadResolutionResultsImpl;
        }
        if (!candidatesWithWrongReceiver.isEmpty()) {
            tracing.unresolvedReferenceWrongReceiver(context.trace, candidatesWithWrongReceiver);
            OverloadResolutionResultsImpl overloadResolutionResultsImpl = OverloadResolutionResultsImpl.candidatesWithWrongReceiver(candidatesWithWrongReceiver);
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeResultAndReportErrors"));
            }
            return overloadResolutionResultsImpl;
        }
        tracing.unresolvedReference(context.trace);
        OverloadResolutionResultsImpl overloadResolutionResultsImpl = OverloadResolutionResultsImpl.nameNotFound();
        if (overloadResolutionResultsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeResultAndReportErrors"));
        }
        return overloadResolutionResultsImpl;
    }

    @NotNull
    private <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> computeSuccessfulResult(@NotNull CallResolutionContext context, @NotNull TracingStrategy tracing, @NotNull Set<MutableResolvedCall<D>> successfulCandidates, @NotNull Set<MutableResolvedCall<D>> incompleteCandidates, @NotNull CheckArgumentTypesMode checkArgumentsMode) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeSuccessfulResult"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeSuccessfulResult"));
        }
        if (successfulCandidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "successfulCandidates", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeSuccessfulResult"));
        }
        if (incompleteCandidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "incompleteCandidates", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeSuccessfulResult"));
        }
        if (checkArgumentsMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkArgumentsMode", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeSuccessfulResult"));
        }
        LinkedHashSet<MutableResolvedCall<D>> successfulAndIncomplete = Sets.newLinkedHashSet();
        successfulAndIncomplete.addAll(successfulCandidates);
        successfulAndIncomplete.addAll(incompleteCandidates);
        OverloadResolutionResultsImpl<D> results = this.chooseAndReportMaximallySpecific(successfulAndIncomplete, true, context.isDebuggerContext, checkArgumentsMode);
        if (results.isSingleResult()) {
            ResolvedCall resultingCall = results.getResultingCall();
            resultingCall.getTrace().moveAllMyDataTo(context.trace);
            if (resultingCall.getStatus() == ResolutionStatus.INCOMPLETE_TYPE_INFERENCE) {
                OverloadResolutionResultsImpl overloadResolutionResultsImpl = OverloadResolutionResultsImpl.incompleteTypeInference(resultingCall);
                if (overloadResolutionResultsImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeSuccessfulResult"));
                }
                return overloadResolutionResultsImpl;
            }
        }
        if (results.isAmbiguity()) {
            tracing.recordAmbiguity(context.trace, results.getResultingCalls());
            boolean allCandidatesIncomplete = ResolutionResultsHandler.allIncomplete(results.getResultingCalls());
            if (context.checkArguments != CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS || !CallUtilKt.hasUnresolvedArguments(context.call, context)) {
                if (allCandidatesIncomplete) {
                    tracing.cannotCompleteResolve(context.trace, results.getResultingCalls());
                } else {
                    tracing.ambiguity(context.trace, results.getResultingCalls());
                }
            }
            if (allCandidatesIncomplete) {
                OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = OverloadResolutionResultsImpl.incompleteTypeInference(results.getResultingCalls());
                if (overloadResolutionResultsImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeSuccessfulResult"));
                }
                return overloadResolutionResultsImpl;
            }
        }
        OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = results;
        if (overloadResolutionResultsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeSuccessfulResult"));
        }
        return overloadResolutionResultsImpl;
    }

    @NotNull
    private <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> computeFailedResult(@NotNull TracingStrategy tracing, @NotNull BindingTrace trace, @NotNull Set<MutableResolvedCall<D>> failedCandidates, @NotNull CheckArgumentTypesMode checkArgumentsMode) {
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeFailedResult"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeFailedResult"));
        }
        if (failedCandidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "failedCandidates", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeFailedResult"));
        }
        if (checkArgumentsMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkArgumentsMode", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeFailedResult"));
        }
        if (failedCandidates.size() != 1) {
            for (EnumSet<ResolutionStatus> severityLevel : ResolutionStatus.SEVERITY_LEVELS) {
                LinkedHashSet<MutableResolvedCall<D>> thisLevel = Sets.newLinkedHashSet();
                for (MutableResolvedCall<D> candidate : failedCandidates) {
                    if (!severityLevel.contains((Object)candidate.getStatus())) continue;
                    thisLevel.add(candidate);
                }
                if (thisLevel.isEmpty()) continue;
                if (severityLevel.contains((Object)ResolutionStatus.ARGUMENTS_MAPPING_ERROR)) {
                    OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = ResolutionResultsHandler.recordFailedInfo(tracing, trace, thisLevel);
                    if (overloadResolutionResultsImpl == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeFailedResult"));
                    }
                    return overloadResolutionResultsImpl;
                }
                OverloadResolutionResultsImpl<D> results = this.chooseAndReportMaximallySpecific(thisLevel, false, false, checkArgumentsMode);
                OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = ResolutionResultsHandler.recordFailedInfo(tracing, trace, results.getResultingCalls());
                if (overloadResolutionResultsImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeFailedResult"));
                }
                return overloadResolutionResultsImpl;
            }
            assert (false) : "Should not be reachable, cause every status must belong to some level";
            Set<MutableResolvedCall<D>> noOverrides = OverrideResolver.filterOutOverridden(failedCandidates, ResolvedCallImpl.MAP_TO_CANDIDATE);
            OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = ResolutionResultsHandler.recordFailedInfo(tracing, trace, noOverrides);
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeFailedResult"));
            }
            return overloadResolutionResultsImpl;
        }
        OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = ResolutionResultsHandler.recordFailedInfo(tracing, trace, failedCandidates);
        if (overloadResolutionResultsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeFailedResult"));
        }
        return overloadResolutionResultsImpl;
    }

    @NotNull
    private static <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> recordFailedInfo(@NotNull TracingStrategy tracing, @NotNull BindingTrace trace, @NotNull Collection<MutableResolvedCall<D>> candidates) {
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "recordFailedInfo"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "recordFailedInfo"));
        }
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "recordFailedInfo"));
        }
        if (candidates.size() == 1) {
            MutableResolvedCall<D> failed = candidates.iterator().next();
            failed.getTrace().moveAllMyDataTo(trace);
            OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = OverloadResolutionResultsImpl.singleFailedCandidate(failed);
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "recordFailedInfo"));
            }
            return overloadResolutionResultsImpl;
        }
        tracing.noneApplicable(trace, candidates);
        tracing.recordAmbiguity(trace, candidates);
        OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = OverloadResolutionResultsImpl.manyFailedCandidates(candidates);
        if (overloadResolutionResultsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "recordFailedInfo"));
        }
        return overloadResolutionResultsImpl;
    }

    private static <D extends CallableDescriptor> boolean allIncomplete(@NotNull Collection<MutableResolvedCall<D>> results) {
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "allIncomplete"));
        }
        for (MutableResolvedCall<D> result2 : results) {
            if (result2.getStatus() == ResolutionStatus.INCOMPLETE_TYPE_INFERENCE) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> chooseAndReportMaximallySpecific(@NotNull Set<MutableResolvedCall<D>> candidates, boolean discriminateGenerics, boolean isDebuggerContext, @NotNull CheckArgumentTypesMode checkArgumentsMode) {
        MutableResolvedCall maximallySpecificGenericsDiscriminated;
        Set noOverrides;
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "chooseAndReportMaximallySpecific"));
        }
        if (checkArgumentsMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkArgumentsMode", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "chooseAndReportMaximallySpecific"));
        }
        if (candidates.size() == 1) {
            OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = OverloadResolutionResultsImpl.success(candidates.iterator().next());
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "chooseAndReportMaximallySpecific"));
            }
            return overloadResolutionResultsImpl;
        }
        if (candidates.iterator().next() instanceof VariableAsFunctionResolvedCall) {
            candidates = this.overloadingConflictResolver.findMaximallySpecificVariableAsFunctionCalls(candidates);
        }
        if ((noOverrides = OverrideResolver.filterOutOverridden(candidates, ResolvedCallImpl.MAP_TO_RESULT)).size() == 1) {
            OverloadResolutionResultsImpl<?> overloadResolutionResultsImpl = OverloadResolutionResultsImpl.success(noOverrides.iterator().next());
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "chooseAndReportMaximallySpecific"));
            }
            return overloadResolutionResultsImpl;
        }
        MutableResolvedCall<?> maximallySpecific = this.overloadingConflictResolver.findMaximallySpecific(noOverrides, checkArgumentsMode, false, isDebuggerContext);
        if (maximallySpecific != null) {
            OverloadResolutionResultsImpl<?> overloadResolutionResultsImpl = OverloadResolutionResultsImpl.success(maximallySpecific);
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "chooseAndReportMaximallySpecific"));
            }
            return overloadResolutionResultsImpl;
        }
        if (discriminateGenerics && (maximallySpecificGenericsDiscriminated = this.overloadingConflictResolver.findMaximallySpecific(noOverrides, checkArgumentsMode, true, isDebuggerContext)) != null) {
            OverloadResolutionResultsImpl overloadResolutionResultsImpl = OverloadResolutionResultsImpl.success(maximallySpecificGenericsDiscriminated);
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "chooseAndReportMaximallySpecific"));
            }
            return overloadResolutionResultsImpl;
        }
        OverloadResolutionResultsImpl overloadResolutionResultsImpl = OverloadResolutionResultsImpl.ambiguity(noOverrides);
        if (overloadResolutionResultsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "chooseAndReportMaximallySpecific"));
        }
        return overloadResolutionResultsImpl;
    }
}

