/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.generate.generators;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Set;
import java.util.TreeSet;
import org.encog.app.generate.generators.ProgramGenerator;

public abstract class AbstractGenerator
implements ProgramGenerator {
    public static final int INDENT_SPACES = 4;
    private final StringBuilder contents = new StringBuilder();
    private int currentIndent = 0;
    private final Set<String> includes = new TreeSet<String>();

    public void addBreak() {
        this.contents.append("\n");
    }

    public void addInclude(String str) {
        this.includes.add(str);
    }

    public void addLine(String line) {
        for (int i = 0; i < this.currentIndent; ++i) {
            this.contents.append(' ');
        }
        this.contents.append(line);
        this.contents.append("\n");
    }

    public void addToBeginning(String str) {
        this.contents.insert(0, str);
    }

    @Override
    public String getContents() {
        return this.contents.toString();
    }

    public Set<String> getIncludes() {
        return this.includes;
    }

    public void indentLine(String line) {
        this.addLine(line);
        this.currentIndent += 4;
    }

    public void unIndentLine(String line) {
        this.currentIndent -= 4;
        this.addLine(line);
    }

    @Override
    public void writeContents(File targetFile) {
        try {
            FileWriter outFile = new FileWriter(targetFile);
            PrintWriter out = new PrintWriter(outFile);
            out.print(this.contents.toString());
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

