/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.matrices.decomposition;

import org.encog.mathutil.matrices.Matrix;
import org.encog.mathutil.matrices.MatrixError;

public class LUDecomposition {
    private double[][] LU;
    private int m;
    private int n;
    private int pivsign;
    private int[] piv;

    public LUDecomposition(Matrix A) {
        this.LU = A.getArrayCopy();
        this.m = A.getRows();
        this.n = A.getCols();
        this.piv = new int[this.m];
        for (int i = 0; i < this.m; ++i) {
            this.piv[i] = i;
        }
        this.pivsign = 1;
        double[] LUcolj = new double[this.m];
        for (int j = 0; j < this.n; ++j) {
            int i;
            int i2;
            for (i2 = 0; i2 < this.m; ++i2) {
                LUcolj[i2] = this.LU[i2][j];
            }
            i2 = 0;
            while (i2 < this.m) {
                double[] LUrowi = this.LU[i2];
                int kmax = Math.min(i2, j);
                double s = 0.0;
                for (int k = 0; k < kmax; ++k) {
                    s += LUrowi[k] * LUcolj[k];
                }
                int n = i2++;
                double d = LUcolj[n] - s;
                LUcolj[n] = d;
                LUrowi[j] = d;
            }
            int p = j;
            for (i = j + 1; i < this.m; ++i) {
                if (!(Math.abs(LUcolj[i]) > Math.abs(LUcolj[p]))) continue;
                p = i;
            }
            if (p != j) {
                int k;
                for (k = 0; k < this.n; ++k) {
                    double t = this.LU[p][k];
                    this.LU[p][k] = this.LU[j][k];
                    this.LU[j][k] = t;
                }
                k = this.piv[p];
                this.piv[p] = this.piv[j];
                this.piv[j] = k;
                this.pivsign = -this.pivsign;
            }
            if (!(j < this.m & this.LU[j][j] != 0.0)) continue;
            for (i = j + 1; i < this.m; ++i) {
                double[] dArray = this.LU[i];
                int n = j;
                dArray[n] = dArray[n] / this.LU[j][j];
            }
        }
    }

    public boolean isNonsingular() {
        for (int j = 0; j < this.n; ++j) {
            if (this.LU[j][j] != 0.0) continue;
            return false;
        }
        return true;
    }

    public Matrix getL() {
        Matrix X = new Matrix(this.m, this.n);
        double[][] L = X.getData();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                L[i][j] = i > j ? this.LU[i][j] : (i == j ? 1.0 : 0.0);
            }
        }
        return X;
    }

    public Matrix getU() {
        Matrix X = new Matrix(this.n, this.n);
        double[][] U = X.getData();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                U[i][j] = i <= j ? this.LU[i][j] : 0.0;
            }
        }
        return X;
    }

    public int[] getPivot() {
        int[] p = new int[this.m];
        for (int i = 0; i < this.m; ++i) {
            p[i] = this.piv[i];
        }
        return p;
    }

    public double[] getDoublePivot() {
        double[] vals = new double[this.m];
        for (int i = 0; i < this.m; ++i) {
            vals[i] = this.piv[i];
        }
        return vals;
    }

    public double det() {
        if (this.m != this.n) {
            throw new IllegalArgumentException("Matrix must be square.");
        }
        double d = this.pivsign;
        for (int j = 0; j < this.n; ++j) {
            d *= this.LU[j][j];
        }
        return d;
    }

    public Matrix solve(Matrix B) {
        int j;
        int i;
        int k;
        if (B.getRows() != this.m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isNonsingular()) {
            throw new RuntimeException("Matrix is singular.");
        }
        int nx = B.getCols();
        Matrix Xmat = B.getMatrix(this.piv, 0, nx - 1);
        double[][] X = Xmat.getData();
        for (k = 0; k < this.n; ++k) {
            for (i = k + 1; i < this.n; ++i) {
                for (j = 0; j < nx; ++j) {
                    double[] dArray = X[i];
                    int n = j;
                    dArray[n] = dArray[n] - X[k][j] * this.LU[i][k];
                }
            }
        }
        for (k = this.n - 1; k >= 0; --k) {
            int j2 = 0;
            while (j2 < nx) {
                double[] dArray = X[k];
                int n = j2++;
                dArray[n] = dArray[n] / this.LU[k][k];
            }
            for (i = 0; i < k; ++i) {
                for (j = 0; j < nx; ++j) {
                    double[] dArray = X[i];
                    int n = j;
                    dArray[n] = dArray[n] - X[k][j] * this.LU[i][k];
                }
            }
        }
        return Xmat;
    }

    public double[] Solve(double[] value) {
        int j;
        int i;
        if (value == null) {
            throw new MatrixError("value");
        }
        if (value.length != this.LU.length) {
            throw new MatrixError("Invalid matrix dimensions.");
        }
        if (!this.isNonsingular()) {
            throw new MatrixError("Matrix is singular");
        }
        int count = value.length;
        double[] b = new double[count];
        for (int i2 = 0; i2 < b.length; ++i2) {
            b[i2] = value[this.piv[i2]];
        }
        int rows = this.LU[0].length;
        int columns = this.LU[0].length;
        double[][] lu = this.LU;
        double[] X = new double[count];
        for (i = 0; i < rows; ++i) {
            X[i] = b[i];
            for (j = 0; j < i; ++j) {
                int n = i;
                X[n] = X[n] - lu[i][j] * X[j];
            }
        }
        for (i = rows - 1; i >= 0; --i) {
            for (j = columns - 1; j > i; --j) {
                int n = i;
                X[n] = X[n] - lu[i][j] * X[j];
            }
            int n = i;
            X[n] = X[n] / lu[i][i];
        }
        return X;
    }

    public double[][] inverse() {
        int j;
        int i;
        int k;
        if (!this.isNonsingular()) {
            throw new MatrixError("Matrix is singular");
        }
        int rows = this.LU.length;
        int columns = this.LU[0].length;
        int count = rows;
        double[][] lu = this.LU;
        double[][] X = new double[rows][columns];
        for (int i2 = 0; i2 < rows; ++i2) {
            int k2 = this.piv[i2];
            X[i2][k2] = 1.0;
        }
        for (k = 0; k < columns; ++k) {
            for (i = k + 1; i < columns; ++i) {
                for (j = 0; j < count; ++j) {
                    double[] dArray = X[i];
                    int n = j;
                    dArray[n] = dArray[n] - X[k][j] * lu[i][k];
                }
            }
        }
        for (k = columns - 1; k >= 0; --k) {
            int j2 = 0;
            while (j2 < count) {
                double[] dArray = X[k];
                int n = j2++;
                dArray[n] = dArray[n] / lu[k][k];
            }
            for (i = 0; i < k; ++i) {
                for (j = 0; j < count; ++j) {
                    double[] dArray = X[i];
                    int n = j;
                    dArray[n] = dArray[n] - X[k][j] * lu[i][k];
                }
            }
        }
        return X;
    }
}

