/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.data.buffer.codec;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.encog.ml.data.MLDataError;
import org.encog.ml.data.buffer.codec.DataSetCODEC;

public class SQLCODEC
implements DataSetCODEC {
    private ResultSet results;
    private final int inputSize;
    private final int idealSize;
    private final boolean closeConnection;
    private Connection connection;
    private PreparedStatement statement;
    private int fetchSize = 0;

    public SQLCODEC(Connection theConnection, String theSQL, int theInputSize, int theIdealSize) {
        this.inputSize = theInputSize;
        this.idealSize = theIdealSize;
        this.connection = theConnection;
        this.closeConnection = false;
        try {
            this.statement = this.connection.prepareStatement(theSQL);
        }
        catch (SQLException e) {
            throw new MLDataError(e);
        }
    }

    public SQLCODEC(String theSQL, int theInputSize, int theIdealSize, String theDriver, String theURL, String theUID, String thePWD) {
        this.inputSize = theInputSize;
        this.idealSize = theIdealSize;
        this.closeConnection = true;
        try {
            Class.forName(theDriver);
            this.connection = theUID == null || thePWD == null ? DriverManager.getConnection(theURL) : DriverManager.getConnection(theURL, theUID, thePWD);
            this.statement = this.connection.prepareStatement(theSQL);
        }
        catch (ClassNotFoundException e) {
            throw new MLDataError(e);
        }
        catch (SQLException e) {
            throw new MLDataError(e);
        }
    }

    @Override
    public void close() {
        try {
            if (this.closeConnection) {
                this.connection.close();
            }
            this.results.close();
        }
        catch (SQLException e) {
            throw new MLDataError(e);
        }
    }

    @Override
    public int getIdealSize() {
        return this.idealSize;
    }

    @Override
    public int getInputSize() {
        return this.inputSize;
    }

    @Override
    public void prepareRead() {
        try {
            if (this.fetchSize != 0) {
                this.statement.setFetchSize(this.fetchSize);
            }
            this.results = this.statement.executeQuery();
        }
        catch (SQLException e) {
            throw new MLDataError(e);
        }
    }

    @Override
    public void prepareWrite(int recordCount, int theInputSize, int theIdealSize) {
        throw new MLDataError("Write not supported.");
    }

    @Override
    public boolean read(double[] input, double[] ideal, double[] significance) {
        try {
            double d;
            int i;
            if (!this.results.next()) {
                return false;
            }
            for (i = 0; i < this.inputSize; ++i) {
                input[i] = d = this.results.getDouble(i + 1);
            }
            if (this.idealSize > 0) {
                for (i = 0; i < this.idealSize; ++i) {
                    ideal[i] = d = this.results.getDouble(this.inputSize + i + 1);
                }
            }
            significance[0] = 1.0;
            return true;
        }
        catch (SQLException e) {
            throw new MLDataError(e);
        }
    }

    @Override
    public void write(double[] input, double[] ideal, double significance) {
        throw new MLDataError("Write not supported.");
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int theFetchSize) {
        this.fetchSize = theFetchSize;
    }
}

