/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.prg.extension;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.encog.ml.ea.exception.EACompileError;
import org.encog.ml.prg.expvalue.ValueType;

public class ParamTemplate
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Set<ValueType> possibleTypes = new HashSet<ValueType>();
    private boolean passThrough;

    public void addAllTypes() {
        for (ValueType t : ValueType.values()) {
            this.addType(t);
        }
    }

    public void addType(String theType) {
        if (theType.equals("b")) {
            this.addType(ValueType.booleanType);
        } else if (theType.equals("e")) {
            this.addType(ValueType.enumType);
        } else if (theType.equals("f")) {
            this.addType(ValueType.floatingType);
        } else if (theType.equals("i")) {
            this.addType(ValueType.intType);
        } else if (theType.equals("s")) {
            this.addType(ValueType.stringType);
        } else if (theType.equals("*")) {
            this.addAllTypes();
        } else {
            throw new EACompileError("Unknown type: " + theType);
        }
    }

    public void addType(ValueType theType) {
        this.possibleTypes.add(theType);
    }

    public List<ValueType> determineArgumentTypes(List<ValueType> parentTypes) {
        if (this.isPassThrough()) {
            return parentTypes;
        }
        ArrayList<ValueType> result = new ArrayList<ValueType>();
        result.addAll(this.getPossibleTypes());
        return result;
    }

    public Set<ValueType> getPossibleTypes() {
        return this.possibleTypes;
    }

    public boolean isPassThrough() {
        return this.passThrough;
    }

    public void setPassThrough(boolean passThrough) {
        this.passThrough = passThrough;
    }
}

