/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.train.strategy;

import org.encog.ml.MLEncodable;
import org.encog.ml.train.MLTrain;
import org.encog.ml.train.strategy.Strategy;
import org.encog.neural.networks.training.TrainingError;
import org.encog.util.logging.EncogLogging;

public class Greedy
implements Strategy {
    private MLTrain train;
    private double lastError;
    private double[] lastNetwork;
    private boolean ready;
    private MLEncodable method;

    @Override
    public void init(MLTrain train) {
        this.train = train;
        this.ready = false;
        if (!(train.getMethod() instanceof MLEncodable)) {
            throw new TrainingError("To make use of the Greedy strategy the machine learning method must support MLEncodable.");
        }
        this.method = (MLEncodable)train.getMethod();
        this.lastNetwork = new double[this.method.encodedArrayLength()];
    }

    @Override
    public void postIteration() {
        if (this.ready) {
            if (this.train.getError() > this.lastError) {
                EncogLogging.log(0, "Greedy strategy dropped last iteration.");
                this.train.setError(this.lastError);
                this.method.decodeFromArray(this.lastNetwork);
            }
        } else {
            this.ready = true;
        }
    }

    @Override
    public void preIteration() {
        if (this.method != null) {
            this.lastError = this.train.getError();
            this.method.encodeToArray(this.lastNetwork);
            this.train.setError(this.lastError);
        }
    }
}

