/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.thermal;

import org.encog.mathutil.BoundMath;
import org.encog.mathutil.randomize.RangeRandomizer;
import org.encog.ml.data.MLData;
import org.encog.ml.data.specific.BiPolarNeuralData;
import org.encog.neural.thermal.ThermalNetwork;
import org.encog.util.EngineArray;

public class BoltzmannMachine
extends ThermalNetwork {
    private static final long serialVersionUID = 1L;
    public static final String RUN_CYCLES = "runCycles";
    public static final String ANNEAL_CYCLES = "annealCycles";
    private double temperature;
    private double[] threshold;
    private transient int[] on;
    private transient int[] off;
    private int annealCycles = 100;
    private int runCycles = 1000;

    public BoltzmannMachine() {
    }

    public BoltzmannMachine(int neuronCount) {
        super(neuronCount);
        this.threshold = new double[neuronCount];
    }

    @Override
    public MLData compute(MLData input) {
        BiPolarNeuralData result = new BiPolarNeuralData(input.size());
        EngineArray.arrayCopy(input.getData(), this.getCurrentState().getData());
        this.run();
        EngineArray.arrayCopy(this.getCurrentState().getData(), result.getData());
        return result;
    }

    public void decreaseTemperature(double d) {
        this.temperature *= d;
    }

    public void establishEquilibrium() {
        int n;
        int i;
        int count = this.getNeuronCount();
        if (this.on == null) {
            this.on = new int[count];
            this.off = new int[count];
        }
        for (i = 0; i < count; ++i) {
            this.on[i] = 0;
            this.off[i] = 0;
        }
        for (n = 0; n < this.runCycles * count; ++n) {
            this.run((int)RangeRandomizer.randomize(0.0, count - 1));
        }
        for (n = 0; n < this.annealCycles * count; ++n) {
            int i2 = (int)RangeRandomizer.randomize(0.0, count - 1);
            this.run(i2);
            if (this.getCurrentState().getBoolean(i2)) {
                int n2 = i2;
                this.on[n2] = this.on[n2] + 1;
                continue;
            }
            int n3 = i2;
            this.off[n3] = this.off[n3] + 1;
        }
        for (i = 0; i < count; ++i) {
            this.getCurrentState().setData(i, this.on[i] > this.off[i]);
        }
    }

    public int getAnnealCycles() {
        return this.annealCycles;
    }

    @Override
    public int getInputCount() {
        return this.getNeuronCount();
    }

    @Override
    public int getOutputCount() {
        return this.getNeuronCount();
    }

    public int getRunCycles() {
        return this.runCycles;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public double[] getThreshold() {
        return this.threshold;
    }

    public void run() {
        int count = this.getNeuronCount();
        for (int i = 0; i < count; ++i) {
            this.run(i);
        }
    }

    public void run(int i) {
        int count = this.getNeuronCount();
        double sum = 0.0;
        for (int j = 0; j < count; ++j) {
            sum += this.getWeight(i, j) * (double)(this.getCurrentState().getBoolean(j) ? 1 : 0);
        }
        double probability = 1.0 / (1.0 + BoundMath.exp(-(sum -= this.threshold[i]) / this.temperature));
        if (RangeRandomizer.randomize(0.0, 1.0) <= probability) {
            this.getCurrentState().setData(i, true);
        } else {
            this.getCurrentState().setData(i, false);
        }
    }

    public void setAnnealCycles(int annealCycles) {
        this.annealCycles = annealCycles;
    }

    public void setRunCycles(int runCycles) {
        this.runCycles = runCycles;
    }

    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    public void setThreshold(double[] t) {
        this.threshold = t;
    }

    @Override
    public void updateProperties() {
    }
}

