/*
 * Decompiled with CFR 0.152.
 */
package org.encog.persist;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import org.encog.EncogError;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.mathutil.matrices.Matrix;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.NumberList;

public class EncogWriteHelper {
    private int largeArrayNumber;
    public static final char QUOTE = '\"';
    public static final char COMMA = ',';
    private final PrintStream out;
    private final StringBuilder line = new StringBuilder();
    private String currentSection;

    public EncogWriteHelper(OutputStream stream) {
        try {
            this.out = new PrintStream(stream, true, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new EncogError(e);
        }
    }

    public final void addColumn(boolean b) {
        if (this.line.length() > 0) {
            this.line.append(',');
        }
        this.line.append(b ? 1 : 0);
    }

    public final void addColumn(double d) {
        if (this.line.length() > 0) {
            this.line.append(',');
        }
        this.line.append(CSVFormat.ENGLISH.format(d, 10));
    }

    public final void addColumn(int i) {
        if (this.line.length() > 0) {
            this.line.append(',');
        }
        this.line.append(i);
    }

    public final void addColumn(String str) {
        if (this.line.length() > 0) {
            this.line.append(',');
        }
        this.line.append('\"');
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == '\"') {
                this.line.append("\"\"");
                continue;
            }
            this.line.append(ch);
        }
        this.line.append('\"');
    }

    public final void addColumns(List<String> cols) {
        for (String str : cols) {
            this.addColumn(str);
        }
    }

    public final void addLine(String l) {
        if (this.line.length() > 0) {
            this.writeLine();
        }
        this.out.println(l);
    }

    public final void addProperties(Map<String, String> properties) {
        for (String key : properties.keySet()) {
            String value = properties.get(key);
            this.writeProperty(key, value);
        }
    }

    public final void addSection(String str) {
        this.currentSection = str;
        this.out.println("[" + str + "]");
    }

    public final void addSubSection(String str) {
        this.out.println("[" + this.currentSection + ":" + str + "]");
        this.largeArrayNumber = 0;
    }

    public final void flush() {
        this.out.flush();
    }

    public final String getCurrentSection() {
        return this.currentSection;
    }

    public final void write(String str) {
        this.out.print(str);
    }

    public final void writeLine() {
        this.out.println(this.line.toString());
        this.line.setLength(0);
    }

    private String makeActivationFunctionString(ActivationFunction act) {
        StringBuilder result = new StringBuilder();
        result.append(act.getClass().getSimpleName());
        for (int i = 0; i < act.getParams().length; ++i) {
            result.append('|');
            result.append(CSVFormat.EG_FORMAT.format(act.getParams()[i], 10));
        }
        return result.toString();
    }

    public final void writeProperty(String name, ActivationFunction act) {
        this.writeProperty(name, this.makeActivationFunctionString(act));
    }

    public final void writeProperty(String name, boolean value) {
        this.out.println(name + "=" + (value ? (char)'t' : 'f'));
    }

    public final void writeProperty(String name, CSVFormat csvFormat) {
        String fmt = csvFormat == CSVFormat.ENGLISH || csvFormat == CSVFormat.DECIMAL_POINT ? "decpnt" : (csvFormat == CSVFormat.DECIMAL_COMMA ? "deccomma" : "decpnt");
        this.out.println(name + "=" + fmt);
    }

    public final void writeProperty(String name, double value) {
        this.out.println(name + "=" + CSVFormat.EG_FORMAT.format(value, 10));
    }

    public final void writeProperty(String name, double[] d) {
        if (d.length < 2048) {
            this.out.print(name);
            this.out.print("=");
            boolean first = true;
            for (int i = 0; i < d.length; ++i) {
                if (!first) {
                    this.out.print(",");
                }
                this.out.print(CSVFormat.EG_FORMAT.format(d[i], 10));
                first = false;
            }
            this.out.println();
        } else {
            this.out.print(name);
            this.out.print("=##");
            this.out.println(this.largeArrayNumber++);
            this.out.print("##double#");
            this.out.println(d.length);
            int index = 0;
            while (index < d.length) {
                boolean first = true;
                for (int i = 0; i < 2048 && index < d.length; ++index, ++i) {
                    if (!first) {
                        this.out.print(",");
                    } else {
                        this.out.print("   ");
                    }
                    this.out.print(CSVFormat.EG_FORMAT.format(d[index], 10));
                    first = false;
                }
                this.out.println();
            }
            this.out.println("##end");
        }
    }

    public final void writeProperty(String name, int value) {
        this.out.println(name + "=" + value);
    }

    public final void writeProperty(String name, int[] array) {
        StringBuilder result = new StringBuilder();
        NumberList.toListInt(CSVFormat.EG_FORMAT, result, array);
        this.writeProperty(name, result.toString());
    }

    public final void writeProperty(String name, Matrix matrix) {
        StringBuilder result = new StringBuilder();
        result.append(matrix.getRows());
        result.append(',');
        result.append(matrix.getCols());
        for (int row = 0; row < matrix.getRows(); ++row) {
            for (int col = 0; col < matrix.getCols(); ++col) {
                result.append(',');
                result.append(CSVFormat.EG_FORMAT.format(matrix.get(row, col), 10));
            }
        }
        this.writeProperty(name, result.toString());
    }

    public final void writeProperty(String name, String value) {
        this.out.println(name + "=" + value);
    }

    public void addColumn(ActivationFunction act) {
        this.addColumn(this.makeActivationFunctionString(act));
    }
}

