/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.databroker;

import java.io.InputStream;
import java.net.URL;
import org.languagetool.databroker.ResourceDataBroker;

public class DefaultResourceDataBroker
implements ResourceDataBroker {
    private final String resourceDir;
    private final String rulesDir;

    public DefaultResourceDataBroker() {
        this("/org/languagetool/resource", "/org/languagetool/rules");
    }

    public DefaultResourceDataBroker(String resourceDir, String rulesDir) {
        this.resourceDir = resourceDir == null ? "" : resourceDir;
        this.rulesDir = rulesDir == null ? "" : rulesDir;
    }

    @Override
    public InputStream getFromResourceDirAsStream(String path) {
        String completePath = this.getCompleteResourceUrl(path);
        InputStream resourceAsStream = ResourceDataBroker.class.getResourceAsStream(completePath);
        this.assertNotNull(resourceAsStream, path, completePath);
        return resourceAsStream;
    }

    @Override
    public URL getFromResourceDirAsUrl(String path) {
        String completePath = this.getCompleteResourceUrl(path);
        URL resource = ResourceDataBroker.class.getResource(completePath);
        this.assertNotNull(resource, path, completePath);
        return resource;
    }

    private String getCompleteResourceUrl(String path) {
        return this.appendPath(this.resourceDir, path);
    }

    @Override
    public InputStream getFromRulesDirAsStream(String path) {
        String completePath = this.getCompleteRulesUrl(path);
        InputStream resourceAsStream = ResourceDataBroker.class.getResourceAsStream(completePath);
        this.assertNotNull(resourceAsStream, path, completePath);
        return resourceAsStream;
    }

    @Override
    public URL getFromRulesDirAsUrl(String path) {
        String completePath = this.getCompleteRulesUrl(path);
        URL resource = ResourceDataBroker.class.getResource(completePath);
        this.assertNotNull(resource, path, completePath);
        return resource;
    }

    private void assertNotNull(Object object, String path, String completePath) {
        if (object == null) {
            throw new RuntimeException("Path " + path + " not found in class path at " + completePath);
        }
    }

    private String getCompleteRulesUrl(String path) {
        return this.appendPath(this.rulesDir, path);
    }

    private String appendPath(String baseDir, String path) {
        StringBuilder completePath = new StringBuilder(baseDir);
        if (!this.rulesDir.endsWith("/") && !path.startsWith("/")) {
            completePath.append('/');
        }
        if (this.rulesDir.endsWith("/") && path.startsWith("/") && path.length() > 1) {
            completePath.append(path.substring(1));
        } else {
            completePath.append(path);
        }
        return completePath.toString();
    }

    @Override
    public boolean resourceExists(String path) {
        String completePath = this.getCompleteResourceUrl(path);
        return ResourceDataBroker.class.getResource(completePath) != null;
    }

    @Override
    public boolean ruleFileExists(String path) {
        String completePath = this.getCompleteRulesUrl(path);
        return ResourceDataBroker.class.getResource(completePath) != null;
    }

    @Override
    public String getResourceDir() {
        return this.resourceDir;
    }

    @Override
    public String getRulesDir() {
        return this.rulesDir;
    }
}

