/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.ResourceBundle;
import java.util.concurrent.ArrayBlockingQueue;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.tools.StringTools;

public abstract class AbstractSimpleReplaceRule2
extends Rule {
    private final Language language;
    private final List<Map<String, String>> wrongWords;

    public abstract String getFileName();

    @Override
    public abstract String getId();

    @Override
    public abstract String getDescription();

    public abstract String getShort();

    public abstract String getSuggestion();

    public abstract String getSuggestionsSeparator();

    public abstract Locale getLocale();

    public AbstractSimpleReplaceRule2(ResourceBundle messages, Language language) throws IOException {
        super(messages);
        this.language = Objects.requireNonNull(language);
        super.setCategory(Categories.MISC.getCategory(messages));
        this.wrongWords = this.loadWords(JLanguageTool.getDataBroker().getFromRulesDirAsStream(this.getFileName()));
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public List<Map<String, String>> getWrongWords() {
        return this.wrongWords;
    }

    private List<Map<String, String>> loadWords(InputStream stream) throws IOException {
        ArrayList list = new ArrayList();
        InputStreamReader isr = new InputStreamReader(stream, "utf-8");
        Object object = null;
        try (BufferedReader bufferedReader = new BufferedReader(isr);){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                String[] wrongForms;
                if ((line = line.trim()).isEmpty() || line.charAt(0) == '#') continue;
                String[] parts = line.split("=");
                if (parts.length != 2) {
                    throw new IOException("Format error in file " + JLanguageTool.getDataBroker().getFromRulesDirAsUrl(this.getFileName()) + ", line: " + line);
                }
                for (String wrongForm : wrongForms = parts[0].split("\\|")) {
                    int wordCount = 0;
                    List<String> tokens = this.language.getWordTokenizer().tokenize(wrongForm);
                    for (String token : tokens) {
                        if (StringTools.isWhitespace(token)) continue;
                        ++wordCount;
                    }
                    for (int i = list.size(); i < wordCount; ++i) {
                        list.add(new HashMap());
                    }
                    ((Map)list.get(wordCount - 1)).put(wrongForm, parts[1]);
                }
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (isr != null) {
                if (object != null) {
                    try {
                        isr.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    isr.close();
                }
            }
        }
        ArrayList result = new ArrayList();
        for (Map map : list) {
            result.add(Collections.unmodifiableMap(map));
        }
        return Collections.unmodifiableList(result);
    }

    private void addToQueue(AnalyzedTokenReadings token, Queue<AnalyzedTokenReadings> prevTokens) {
        boolean inserted = prevTokens.offer(token);
        if (!inserted) {
            prevTokens.poll();
            prevTokens.offer(token);
        }
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        ArrayBlockingQueue<AnalyzedTokenReadings> prevTokens = new ArrayBlockingQueue<AnalyzedTokenReadings>(this.wrongWords.size());
        block0: for (int i = 1; i < tokens.length; ++i) {
            this.addToQueue(tokens[i], prevTokens);
            StringBuilder sb = new StringBuilder();
            ArrayList<String> variants = new ArrayList<String>();
            List<AnalyzedTokenReadings> prevTokensList = Arrays.asList(prevTokens.toArray(new AnalyzedTokenReadings[prevTokens.size()]));
            for (int j = prevTokensList.size() - 1; j >= 0; --j) {
                if (j != prevTokensList.size() - 1 && prevTokensList.get(j + 1).isWhitespaceBefore()) {
                    sb.insert(0, " ");
                }
                sb.insert(0, prevTokensList.get(j).getToken());
                variants.add(0, sb.toString());
            }
            int len = variants.size();
            for (int j = 0; j < len; ++j) {
                String crtMatch;
                String crt = (String)variants.get(j);
                int crtWordCount = len - j;
                String string = crtMatch = this.isCaseSensitive() ? this.wrongWords.get(crtWordCount - 1).get(crt) : this.wrongWords.get(crtWordCount - 1).get(crt.toLowerCase(this.getLocale()));
                if (crtMatch == null) continue;
                List<String> replacements = Arrays.asList(crtMatch.split("\\|"));
                String msg = crt + this.getSuggestion();
                for (int k = 0; k < replacements.size(); ++k) {
                    if (k > 0) {
                        msg = msg + (k == replacements.size() - 1 ? this.getSuggestionsSeparator() : ", ");
                    }
                    msg = msg + "<suggestion>" + replacements.get(k) + "</suggestion>";
                }
                int startPos = prevTokensList.get(len - crtWordCount).getStartPos();
                int endPos = prevTokensList.get(len - 1).getEndPos();
                RuleMatch potentialRuleMatch = new RuleMatch(this, startPos, endPos, msg, this.getShort());
                if (!this.isCaseSensitive() && StringTools.startsWithUppercase(crt)) {
                    for (int k = 0; k < replacements.size(); ++k) {
                        replacements.set(k, StringTools.uppercaseFirstChar(replacements.get(k)));
                    }
                }
                potentialRuleMatch.setSuggestedReplacements(replacements);
                ruleMatches.add(potentialRuleMatch);
                continue block0;
            }
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    @Override
    public void reset() {
    }
}

