/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.lemmatizer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import opennlp.tools.lemmatizer.DictionaryLemmatizer;
import opennlp.tools.util.StringUtil;

public class SimpleLemmatizer
implements DictionaryLemmatizer {
    public final Set<String> constantTags = new HashSet<String>(Arrays.asList("NNP", "NP00000"));
    private HashMap<List<String>, String> dictMap = new HashMap();

    public SimpleLemmatizer(InputStream dictionary) {
        BufferedReader breader = new BufferedReader(new InputStreamReader(dictionary));
        try {
            String line;
            while ((line = breader.readLine()) != null) {
                String[] elems = line.split("\t");
                this.dictMap.put(Arrays.asList(elems[0], elems[1]), elems[2]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private List<String> getDictKeys(String word, String postag) {
        ArrayList<String> keys = new ArrayList<String>();
        if (this.constantTags.contains(postag)) {
            keys.addAll(Arrays.asList(word, postag));
        } else {
            keys.addAll(Arrays.asList(StringUtil.toLowerCase(word), postag));
        }
        return keys;
    }

    @Override
    public String lemmatize(String word, String postag) {
        String lemma = null;
        List<String> keys = this.getDictKeys(word, postag);
        String keyValue = this.dictMap.get(keys);
        lemma = keyValue != null ? keyValue : (keyValue == null && this.constantTags.contains(postag) ? word : (keyValue == null && word.toUpperCase() == word ? word : StringUtil.toLowerCase(word)));
        return lemma;
    }
}

