/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.model;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import opennlp.tools.ml.model.DataReader;

public class PlainTextFileDataReader
implements DataReader {
    private BufferedReader input;

    public PlainTextFileDataReader(File f) throws IOException {
        this.input = f.getName().endsWith(".gz") ? new BufferedReader(new InputStreamReader(new BufferedInputStream(new GZIPInputStream(new BufferedInputStream(new FileInputStream(f)))))) : new BufferedReader(new InputStreamReader(new BufferedInputStream(new FileInputStream(f))));
    }

    public PlainTextFileDataReader(InputStream in) {
        this.input = new BufferedReader(new InputStreamReader(in));
    }

    public PlainTextFileDataReader(BufferedReader in) {
        this.input = in;
    }

    @Override
    public double readDouble() throws IOException {
        return Double.parseDouble(this.input.readLine());
    }

    @Override
    public int readInt() throws IOException {
        return Integer.parseInt(this.input.readLine());
    }

    @Override
    public String readUTF() throws IOException {
        return this.input.readLine();
    }
}

