/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.featuregen;

import java.util.List;
import opennlp.tools.util.featuregen.BrownCluster;
import opennlp.tools.util.featuregen.BrownTokenClasses;
import opennlp.tools.util.featuregen.FeatureGeneratorAdapter;
import opennlp.tools.util.featuregen.FeatureGeneratorUtil;

public class BrownTokenClassFeatureGenerator
extends FeatureGeneratorAdapter {
    private BrownCluster brownLexicon;

    public BrownTokenClassFeatureGenerator(BrownCluster dict) {
        this.brownLexicon = dict;
    }

    @Override
    public void createFeatures(List<String> features, String[] tokens, int index, String[] previousOutcomes) {
        String wordShape = FeatureGeneratorUtil.tokenFeature(tokens[index]);
        List<String> wordClasses = BrownTokenClasses.getWordClasses(tokens[index], this.brownLexicon);
        for (int i = 0; i < wordClasses.size(); ++i) {
            features.add("c,browncluster=" + wordShape + "," + wordClasses.get(i));
        }
    }
}

