/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optimization.fitting;

import org.apache.commons.math3.analysis.function.HarmonicOscillator;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.ZeroException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.optimization.DifferentiableMultivariateVectorOptimizer;
import org.apache.commons.math3.optimization.fitting.CurveFitter;
import org.apache.commons.math3.optimization.fitting.WeightedObservedPoint;
import org.apache.commons.math3.util.FastMath;

public class HarmonicFitter
extends CurveFitter {
    public HarmonicFitter(DifferentiableMultivariateVectorOptimizer optimizer) {
        super(optimizer);
    }

    public double[] fit(double[] initialGuess) {
        return this.fit(new HarmonicOscillator.Parametric(), initialGuess);
    }

    public double[] fit() {
        return this.fit(new ParameterGuesser(this.getObservations()).guess());
    }

    public static class ParameterGuesser {
        private final WeightedObservedPoint[] observations;
        private double a;
        private double omega;
        private double phi;

        public ParameterGuesser(WeightedObservedPoint[] observations) {
            if (observations.length < 4) {
                throw new NumberIsTooSmallException((Localizable)LocalizedFormats.INSUFFICIENT_OBSERVED_POINTS_IN_SAMPLE, (Number)observations.length, 4, true);
            }
            this.observations = (WeightedObservedPoint[])observations.clone();
        }

        public double[] guess() {
            this.sortObservations();
            this.guessAOmega();
            this.guessPhi();
            return new double[]{this.a, this.omega, this.phi};
        }

        private void sortObservations() {
            WeightedObservedPoint curr = this.observations[0];
            for (int j = 1; j < this.observations.length; ++j) {
                WeightedObservedPoint prec = curr;
                curr = this.observations[j];
                if (!(curr.getX() < prec.getX())) continue;
                int i = j - 1;
                WeightedObservedPoint mI = this.observations[i];
                while (i >= 0 && curr.getX() < mI.getX()) {
                    this.observations[i + 1] = mI;
                    if (i-- == 0) continue;
                    mI = this.observations[i];
                }
                this.observations[i + 1] = curr;
                curr = this.observations[j];
            }
        }

        private void guessAOmega() {
            double sx2 = 0.0;
            double sy2 = 0.0;
            double sxy = 0.0;
            double sxz = 0.0;
            double syz = 0.0;
            double currentX = this.observations[0].getX();
            double currentY = this.observations[0].getY();
            double f2Integral = 0.0;
            double fPrime2Integral = 0.0;
            double startX = currentX;
            for (int i = 1; i < this.observations.length; ++i) {
                double previousX = currentX;
                double previousY = currentY;
                currentX = this.observations[i].getX();
                currentY = this.observations[i].getY();
                double dx = currentX - previousX;
                double dy = currentY - previousY;
                double f2StepIntegral = dx * (previousY * previousY + previousY * currentY + currentY * currentY) / 3.0;
                double fPrime2StepIntegral = dy * dy / dx;
                double x = currentX - startX;
                sx2 += x * x;
                sy2 += (f2Integral += f2StepIntegral) * f2Integral;
                sxy += x * f2Integral;
                sxz += x * (fPrime2Integral += fPrime2StepIntegral);
                syz += f2Integral * fPrime2Integral;
            }
            double c1 = sy2 * sxz - sxy * syz;
            double c2 = sxy * sxz - sx2 * syz;
            double c3 = sx2 * sy2 - sxy * sxy;
            if (c1 / c2 < 0.0 || c2 / c3 < 0.0) {
                int last = this.observations.length - 1;
                double xRange = this.observations[last].getX() - this.observations[0].getX();
                if (xRange == 0.0) {
                    throw new ZeroException();
                }
                this.omega = Math.PI * 2 / xRange;
                double yMin = Double.POSITIVE_INFINITY;
                double yMax = Double.NEGATIVE_INFINITY;
                for (int i = 1; i < this.observations.length; ++i) {
                    double y = this.observations[i].getY();
                    if (y < yMin) {
                        yMin = y;
                    }
                    if (!(y > yMax)) continue;
                    yMax = y;
                }
                this.a = 0.5 * (yMax - yMin);
            } else {
                this.a = FastMath.sqrt(c1 / c2);
                this.omega = FastMath.sqrt(c2 / c3);
            }
        }

        private void guessPhi() {
            double fcMean = 0.0;
            double fsMean = 0.0;
            double currentX = this.observations[0].getX();
            double currentY = this.observations[0].getY();
            for (int i = 1; i < this.observations.length; ++i) {
                double previousX = currentX;
                double previousY = currentY;
                currentX = this.observations[i].getX();
                currentY = this.observations[i].getY();
                double currentYPrime = (currentY - previousY) / (currentX - previousX);
                double omegaX = this.omega * currentX;
                double cosine = FastMath.cos(omegaX);
                double sine = FastMath.sin(omegaX);
                fcMean += this.omega * currentY * cosine - currentYPrime * sine;
                fsMean += this.omega * currentY * sine + currentYPrime * cosine;
            }
            this.phi = FastMath.atan2(-fsMean, fcMean);
        }
    }
}

