/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optimization.general;

import org.apache.commons.math3.exception.ConvergenceException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.BlockRealMatrix;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.QRDecomposition;
import org.apache.commons.math3.linear.SingularMatrixException;
import org.apache.commons.math3.optimization.ConvergenceChecker;
import org.apache.commons.math3.optimization.PointVectorValuePair;
import org.apache.commons.math3.optimization.SimpleVectorValueChecker;
import org.apache.commons.math3.optimization.general.AbstractLeastSquaresOptimizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GaussNewtonOptimizer
extends AbstractLeastSquaresOptimizer {
    private final boolean useLU;

    public GaussNewtonOptimizer() {
        this(true);
    }

    public GaussNewtonOptimizer(ConvergenceChecker<PointVectorValuePair> checker) {
        this(true, checker);
    }

    public GaussNewtonOptimizer(boolean useLU) {
        this(useLU, new SimpleVectorValueChecker());
    }

    public GaussNewtonOptimizer(boolean useLU, ConvergenceChecker<PointVectorValuePair> checker) {
        super(checker);
        this.useLU = useLU;
    }

    @Override
    public PointVectorValuePair doOptimize() {
        ConvergenceChecker<PointVectorValuePair> checker = this.getConvergenceChecker();
        PointVectorValuePair current = null;
        int iter = 0;
        boolean converged = false;
        while (!converged) {
            ++iter;
            PointVectorValuePair previous = current;
            this.updateResidualsAndCost();
            this.updateJacobian();
            current = new PointVectorValuePair(this.point, this.objective);
            double[] targetValues = this.getTargetRef();
            double[] residualsWeights = this.getWeightRef();
            double[] b = new double[this.cols];
            double[][] a = new double[this.cols][this.cols];
            for (int i = 0; i < this.rows; ++i) {
                double[] grad = this.weightedResidualJacobian[i];
                double weight = residualsWeights[i];
                double residual = this.objective[i] - targetValues[i];
                double wr = weight * residual;
                for (int j = 0; j < this.cols; ++j) {
                    int n = j;
                    b[n] = b[n] + wr * grad[j];
                }
                for (int k = 0; k < this.cols; ++k) {
                    double[] ak = a[k];
                    double wgk = weight * grad[k];
                    for (int l = 0; l < this.cols; ++l) {
                        int n = l;
                        ak[n] = ak[n] + wgk * grad[l];
                    }
                }
            }
            try {
                BlockRealMatrix mA = new BlockRealMatrix(a);
                DecompositionSolver solver = this.useLU ? new LUDecomposition(mA).getSolver() : new QRDecomposition(mA).getSolver();
                double[] dX = solver.solve(new ArrayRealVector(b, false)).toArray();
                for (int i = 0; i < this.cols; ++i) {
                    int n = i;
                    this.point[n] = this.point[n] + dX[i];
                }
            }
            catch (SingularMatrixException e) {
                throw new ConvergenceException(LocalizedFormats.UNABLE_TO_SOLVE_SINGULAR_PROBLEM, new Object[0]);
            }
            if (checker == null || previous == null) continue;
            converged = checker.converged(iter, previous, current);
        }
        return current;
    }
}

