/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.clustering;

import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.math3.stat.clustering.Clusterable;
import org.apache.commons.math3.util.MathArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EuclideanIntegerPoint
implements Clusterable<EuclideanIntegerPoint>,
Serializable {
    private static final long serialVersionUID = 3946024775784901369L;
    private final int[] point;

    public EuclideanIntegerPoint(int[] point) {
        this.point = point;
    }

    public int[] getPoint() {
        return this.point;
    }

    @Override
    public double distanceFrom(EuclideanIntegerPoint p) {
        return MathArrays.distance(this.point, p.getPoint());
    }

    @Override
    public EuclideanIntegerPoint centroidOf(Collection<EuclideanIntegerPoint> points) {
        int[] centroid = new int[this.getPoint().length];
        for (EuclideanIntegerPoint p : points) {
            for (int i = 0; i < centroid.length; ++i) {
                int n = i;
                centroid[n] = centroid[n] + p.getPoint()[i];
            }
        }
        int i = 0;
        while (i < centroid.length) {
            int n = i++;
            centroid[n] = centroid[n] / points.size();
        }
        return new EuclideanIntegerPoint(centroid);
    }

    public boolean equals(Object other) {
        if (!(other instanceof EuclideanIntegerPoint)) {
            return false;
        }
        int[] otherPoint = ((EuclideanIntegerPoint)other).getPoint();
        if (this.point.length != otherPoint.length) {
            return false;
        }
        for (int i = 0; i < this.point.length; ++i) {
            if (this.point[i] == otherPoint[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 0;
        int[] arr$ = this.point;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer i = arr$[i$];
            hashCode += i.hashCode() * 13 + 7;
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder("(");
        int[] coordinates = this.getPoint();
        for (int i = 0; i < coordinates.length; ++i) {
            buff.append(coordinates[i]);
            if (i >= coordinates.length - 1) continue;
            buff.append(",");
        }
        buff.append(")");
        return buff.toString();
    }
}

