/*
 * Decompiled with CFR 0.152.
 */
package net.java.sen;

import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.java.sen.dictionary.Reading;
import net.java.sen.dictionary.Sentence;
import net.java.sen.dictionary.Token;
import net.java.sen.dictionary.Tokenizer;
import net.java.sen.dictionary.Viterbi;
import net.java.sen.filter.ReadingFilter;
import net.java.sen.filter.ReadingNode;
import net.java.sen.util.TextUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadingProcessor {
    private static Pattern patternSpecialCharsPattern = Pattern.compile("([^a-zA-z0-9])");
    private Map<Integer, ReadingFilter> filters = new TreeMap<Integer, ReadingFilter>();
    private Viterbi viterbi;
    private Sentence sentence;
    private boolean needsAnalysis = true;
    private List<Token> tokens;

    private String escapePatternSpecialChars(String input) {
        return patternSpecialCharsPattern.matcher(input).replaceAll("\\\\$1");
    }

    private List<Reading> splitComplexToken(String text, String reading, int tokenStart) {
        boolean fragmentIsKanji;
        ArrayList<Reading> tokenReadings = new ArrayList<Reading>();
        ArrayList<String> fragments = new ArrayList<String>();
        boolean firstFragmentIsKanji = fragmentIsKanji = Character.UnicodeBlock.of(text.charAt(0)) == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS;
        int fragmentStart = 0;
        for (int i = 1; i < text.length(); ++i) {
            boolean newIsKanji;
            boolean bl = newIsKanji = Character.UnicodeBlock.of(text.charAt(i)) == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS;
            if (fragmentIsKanji == newIsKanji) continue;
            fragments.add(text.substring(fragmentStart, i));
            fragmentStart = i;
            fragmentIsKanji = newIsKanji;
        }
        fragments.add(text.substring(fragmentStart, text.length()));
        String regexp = "^";
        fragmentIsKanji = firstFragmentIsKanji;
        for (String fragment : fragments) {
            regexp = fragmentIsKanji ? regexp + "(.*?)" : regexp + "(" + this.escapePatternSpecialChars(fragment) + ")";
            fragmentIsKanji = !fragmentIsKanji;
        }
        Pattern pattern = Pattern.compile(regexp = regexp + "$");
        Matcher matcher = pattern.matcher(reading);
        if (!matcher.find()) {
            return null;
        }
        fragmentIsKanji = firstFragmentIsKanji;
        fragmentStart = 0;
        for (int i = 0; i < fragments.size(); ++i) {
            String fragment = (String)fragments.get(i);
            if (fragmentIsKanji) {
                String fragmentReading = matcher.group(i + 1);
                tokenReadings.add(new Reading(tokenStart + fragmentStart, fragment.length(), fragmentReading));
            }
            fragmentStart += fragment.length();
            fragmentIsKanji = !fragmentIsKanji;
        }
        return tokenReadings;
    }

    private List<Token> getTokens() {
        try {
            if (this.needsAnalysis) {
                this.tokens = this.viterbi.getBestTokens(this.sentence);
                this.needsAnalysis = false;
            }
            return this.tokens;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private ReadingNode compileReadings() {
        ReadingNode headNode = null;
        ReadingNode prev = null;
        List<Token> tokens = this.getTokens();
        for (int i = 0; i < tokens.size(); ++i) {
            Token token = tokens.get(i);
            boolean hasKanji = false;
            boolean hasNonKanji = false;
            for (char c : token.getSurface().toCharArray()) {
                if (Character.UnicodeBlock.of(c) == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS) {
                    hasKanji = true;
                    continue;
                }
                hasNonKanji = true;
            }
            List<String> readings = token.getMorpheme().getReadings();
            Reading readingConstraint = this.sentence.getReadingConstraint(token.getStart());
            String constraintText = null;
            if (readingConstraint != null) {
                constraintText = TextUtil.invertKanaCase(readingConstraint.text);
            }
            ReadingNode node = new ReadingNode();
            node.firstToken = i;
            node.lastToken = i;
            node.visible = true;
            if (!"".equals(constraintText) && (hasKanji && readings.size() > 0 || readingConstraint != null && !token.getSurface().equals(constraintText) && (readings.size() == 0 || !token.getSurface().equals(readings.get(0))))) {
                String readingText = readingConstraint == null ? TextUtil.invertKanaCase(readings.get(0)) : TextUtil.invertKanaCase(readingConstraint.text);
                node.baseReadings.add(new Reading(token.getStart(), token.getLength(), readingText));
                if (hasKanji != hasNonKanji) {
                    node.displayReadings.add(new Reading(token.getStart(), token.getLength(), readingText));
                } else {
                    String text = token.getSurface();
                    List<Reading> tokenReadings = this.splitComplexToken(text, readingText, token.getStart());
                    if (tokenReadings != null) {
                        node.displayReadings.addAll(tokenReadings);
                    } else {
                        node.displayReadings.add(new Reading(token.getStart(), token.getLength(), readingText));
                    }
                }
            }
            if (headNode == null) {
                headNode = node;
            }
            node.prev = prev;
            if (prev != null) {
                prev.next = node;
            }
            prev = node;
        }
        return headNode;
    }

    public void setText(String text) {
        this.sentence = new Sentence(text);
        this.needsAnalysis = true;
        for (ReadingFilter filter : this.filters.values()) {
            filter.reset();
        }
    }

    public void addFilter(int priority, ReadingFilter filter) {
        this.filters.put(priority, filter);
    }

    public void removeFilter(int priority) {
        this.filters.remove(priority);
    }

    public void setFilters(Map<Integer, ReadingFilter> filters) {
        this.filters.clear();
        this.filters.putAll(filters);
    }

    public void clearFilters() {
        this.filters.clear();
    }

    public Map<Integer, ReadingFilter> getFilters() {
        return new TreeMap<Integer, ReadingFilter>(this.filters);
    }

    public Reading getReadingConstraint(int position) {
        Reading constraint = this.sentence.getReadingConstraint(position);
        if (constraint != null) {
            Reading invertedConstraint = new Reading(constraint.start, constraint.length, TextUtil.invertKanaCase(constraint.text));
            return invertedConstraint;
        }
        return null;
    }

    public void setReadingConstraint(Reading constraint) {
        Reading invertedConstraint = new Reading(constraint.start, constraint.length, TextUtil.invertKanaCase(constraint.text));
        this.sentence.setReadingConstraint(invertedConstraint);
        this.needsAnalysis = true;
    }

    public void removeReadingConstraint(int position) {
        this.sentence.removeReadingConstraint(position);
        this.needsAnalysis = true;
    }

    public List<Reading> getDisplayReadings() {
        ReadingNode node = this.compileReadings();
        for (ReadingFilter filter : this.filters.values()) {
            filter.filterReadings(this.tokens, node);
        }
        ArrayList<Reading> readings = new ArrayList<Reading>();
        while (node != null) {
            if (node.visible) {
                for (Reading reading : node.displayReadings) {
                    readings.add(reading);
                }
            }
            node = node.next;
        }
        return readings;
    }

    public ReadingResult process() {
        ReadingNode node = this.compileReadings();
        for (ReadingFilter filter : this.filters.values()) {
            filter.filterReadings(this.tokens, node);
        }
        TreeMap<Integer, Reading> baseReadings = new TreeMap<Integer, Reading>();
        TreeMap<Integer, Reading> displayReadings = new TreeMap<Integer, Reading>();
        BitSet visibleTokens = new BitSet();
        while (node != null) {
            if (node.visible) {
                if (node.displayReadings.size() > 0) {
                    for (int i = node.firstToken; i <= node.lastToken; ++i) {
                        visibleTokens.set(i);
                    }
                }
                for (Reading reading : node.baseReadings) {
                    baseReadings.put(reading.start, reading);
                }
                for (Reading reading : node.displayReadings) {
                    displayReadings.put(reading.start, reading);
                }
            }
            node = node.next;
        }
        return new ReadingResult(this.viterbi, this.sentence, this.tokens, baseReadings, displayReadings, visibleTokens);
    }

    public ReadingProcessor(Tokenizer tokenizer) {
        this.viterbi = new Viterbi(tokenizer);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ReadingResult {
        private Viterbi viterbi;
        private Sentence sentence;
        private List<Token> tokens;
        private SortedMap<Integer, Reading> baseReadings;
        private SortedMap<Integer, Reading> displayReadings;
        private BitSet visibleTokens;

        public List<Token> getTokens() {
            return this.tokens;
        }

        public SortedMap<Integer, Reading> getBaseReadings() {
            return this.baseReadings;
        }

        public SortedMap<Integer, Reading> getDisplayReadings() {
            return this.displayReadings;
        }

        public BitSet getVisibleTokens() {
            return this.visibleTokens;
        }

        public List<Token> getPossibleTokens(int position) {
            try {
                return this.viterbi.getPossibleTokens(this.sentence, position);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private ReadingResult(Viterbi viterbi, Sentence sentence, List<Token> tokens, SortedMap<Integer, Reading> baseReadings, SortedMap<Integer, Reading> displayReadings, BitSet visibleTokens) {
            this.viterbi = viterbi;
            this.sentence = sentence;
            this.tokens = tokens;
            this.baseReadings = baseReadings;
            this.displayReadings = displayReadings;
            this.visibleTokens = visibleTokens;
        }
    }
}

