/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.blocktree;

import java.io.IOException;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.blocktree.IntersectTermsEnum;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.Transition;
import org.apache.lucene.util.fst.FST;

final class IntersectTermsEnumFrame {
    final int ord;
    long fp;
    long fpOrig;
    long fpEnd;
    long lastSubFP;
    int state;
    int lastState;
    int metaDataUpto;
    byte[] suffixBytes = new byte[128];
    final ByteArrayDataInput suffixesReader = new ByteArrayDataInput();
    byte[] statBytes = new byte[64];
    final ByteArrayDataInput statsReader = new ByteArrayDataInput();
    byte[] floorData = new byte[32];
    final ByteArrayDataInput floorDataReader = new ByteArrayDataInput();
    int prefix;
    int entCount;
    int nextEnt;
    boolean isLastInFloor;
    boolean isLeafBlock;
    int numFollowFloorBlocks;
    int nextFloorLabel;
    Transition transition = new Transition();
    int curTransitionMax;
    int transitionIndex;
    int transitionCount;
    final boolean versionAutoPrefix;
    FST.Arc<BytesRef> arc;
    final BlockTermState termState;
    public long[] longs;
    public byte[] bytes;
    ByteArrayDataInput bytesReader;
    BytesRef outputPrefix;
    int startBytePos;
    int suffix;
    int floorSuffixLeadStart;
    int floorSuffixLeadEnd;
    boolean isAutoPrefixTerm;
    private final IntersectTermsEnum ite;

    public IntersectTermsEnumFrame(IntersectTermsEnum ite, int ord) throws IOException {
        this.ite = ite;
        this.ord = ord;
        this.termState = ite.fr.parent.postingsReader.newTermState();
        this.termState.totalTermFreq = -1L;
        this.longs = new long[ite.fr.longsSize];
        this.versionAutoPrefix = ite.fr.parent.version >= 1;
    }

    void loadNextFloorBlock() throws IOException {
        assert (this.numFollowFloorBlocks > 0) : "nextFloorLabel=" + this.nextFloorLabel;
        do {
            this.fp = this.fpOrig + (this.floorDataReader.readVLong() >>> 1);
            --this.numFollowFloorBlocks;
            this.nextFloorLabel = this.numFollowFloorBlocks != 0 ? this.floorDataReader.readByte() & 0xFF : 256;
        } while (this.numFollowFloorBlocks != 0 && this.nextFloorLabel <= this.transition.min);
        this.load(null);
    }

    public void setState(int state) {
        this.state = state;
        this.transitionIndex = 0;
        this.transitionCount = this.ite.automaton.getNumTransitions(state);
        if (this.transitionCount != 0) {
            this.ite.automaton.initTransition(state, this.transition);
            this.ite.automaton.getNextTransition(this.transition);
            this.curTransitionMax = this.transition.max;
        } else {
            this.curTransitionMax = -1;
        }
    }

    void load(BytesRef frameIndexData) throws IOException {
        if (frameIndexData != null) {
            if (this.floorData.length < frameIndexData.length) {
                this.floorData = new byte[ArrayUtil.oversize(frameIndexData.length, 1)];
            }
            System.arraycopy(frameIndexData.bytes, frameIndexData.offset, this.floorData, 0, frameIndexData.length);
            this.floorDataReader.reset(this.floorData, 0, frameIndexData.length);
            long code = this.floorDataReader.readVLong();
            if ((code & 1L) != 0L) {
                this.numFollowFloorBlocks = this.floorDataReader.readVInt();
                this.nextFloorLabel = this.floorDataReader.readByte() & 0xFF;
                if (!this.ite.runAutomaton.isAccept(this.state) && this.transitionCount != 0) {
                    assert (this.transitionIndex == 0) : "transitionIndex=" + this.transitionIndex;
                    while (this.numFollowFloorBlocks != 0 && this.nextFloorLabel <= this.transition.min) {
                        this.fp = this.fpOrig + (this.floorDataReader.readVLong() >>> 1);
                        --this.numFollowFloorBlocks;
                        if (this.numFollowFloorBlocks != 0) {
                            this.nextFloorLabel = this.floorDataReader.readByte() & 0xFF;
                            continue;
                        }
                        this.nextFloorLabel = 256;
                    }
                }
            }
        }
        this.ite.in.seek(this.fp);
        int code = this.ite.in.readVInt();
        this.entCount = code >>> 1;
        assert (this.entCount > 0);
        this.isLastInFloor = (code & 1) != 0;
        code = this.ite.in.readVInt();
        this.isLeafBlock = (code & 1) != 0;
        int numBytes = code >>> 1;
        if (this.suffixBytes.length < numBytes) {
            this.suffixBytes = new byte[ArrayUtil.oversize(numBytes, 1)];
        }
        this.ite.in.readBytes(this.suffixBytes, 0, numBytes);
        this.suffixesReader.reset(this.suffixBytes, 0, numBytes);
        numBytes = this.ite.in.readVInt();
        if (this.statBytes.length < numBytes) {
            this.statBytes = new byte[ArrayUtil.oversize(numBytes, 1)];
        }
        this.ite.in.readBytes(this.statBytes, 0, numBytes);
        this.statsReader.reset(this.statBytes, 0, numBytes);
        this.metaDataUpto = 0;
        this.termState.termBlockOrd = 0;
        this.nextEnt = 0;
        numBytes = this.ite.in.readVInt();
        if (this.bytes == null) {
            this.bytes = new byte[ArrayUtil.oversize(numBytes, 1)];
            this.bytesReader = new ByteArrayDataInput();
        } else if (this.bytes.length < numBytes) {
            this.bytes = new byte[ArrayUtil.oversize(numBytes, 1)];
        }
        this.ite.in.readBytes(this.bytes, 0, numBytes);
        this.bytesReader.reset(this.bytes, 0, numBytes);
        if (!this.isLastInFloor) {
            this.fpEnd = this.ite.in.getFilePointer();
        }
        this.isAutoPrefixTerm = false;
    }

    public boolean next() {
        if (this.isLeafBlock) {
            this.nextLeaf();
            return false;
        }
        return this.nextNonLeaf();
    }

    public void nextLeaf() {
        assert (this.nextEnt != -1 && this.nextEnt < this.entCount) : "nextEnt=" + this.nextEnt + " entCount=" + this.entCount + " fp=" + this.fp;
        ++this.nextEnt;
        this.suffix = this.suffixesReader.readVInt();
        this.startBytePos = this.suffixesReader.getPosition();
        this.suffixesReader.skipBytes(this.suffix);
    }

    public boolean nextNonLeaf() {
        assert (this.nextEnt != -1 && this.nextEnt < this.entCount) : "nextEnt=" + this.nextEnt + " entCount=" + this.entCount + " fp=" + this.fp;
        ++this.nextEnt;
        int code = this.suffixesReader.readVInt();
        if (!this.versionAutoPrefix) {
            this.suffix = code >>> 1;
            this.startBytePos = this.suffixesReader.getPosition();
            this.suffixesReader.skipBytes(this.suffix);
            if ((code & 1) == 0) {
                ++this.termState.termBlockOrd;
                return false;
            }
            this.lastSubFP = this.fp - this.suffixesReader.readVLong();
            return true;
        }
        this.suffix = code >>> 2;
        this.startBytePos = this.suffixesReader.getPosition();
        this.suffixesReader.skipBytes(this.suffix);
        switch (code & 3) {
            case 0: {
                this.isAutoPrefixTerm = false;
                ++this.termState.termBlockOrd;
                return false;
            }
            case 1: {
                this.isAutoPrefixTerm = false;
                this.lastSubFP = this.fp - this.suffixesReader.readVLong();
                return true;
            }
            case 2: {
                this.floorSuffixLeadStart = -1;
                ++this.termState.termBlockOrd;
                this.floorSuffixLeadEnd = this.suffixesReader.readByte() & 0xFF;
                if (this.floorSuffixLeadEnd == 255) {
                    this.floorSuffixLeadEnd = -1;
                }
                this.isAutoPrefixTerm = true;
                return false;
            }
            case 3: {
                if (this.suffix == 0) {
                    assert (this.ord > 0);
                    IntersectTermsEnumFrame parent = this.ite.stack[this.ord - 1];
                    this.floorSuffixLeadStart = parent.suffixBytes[parent.startBytePos + parent.suffix - 1] & 0xFF;
                } else {
                    this.floorSuffixLeadStart = this.suffixBytes[this.startBytePos + this.suffix - 1] & 0xFF;
                }
                ++this.termState.termBlockOrd;
                this.isAutoPrefixTerm = true;
                this.floorSuffixLeadEnd = this.suffixesReader.readByte() & 0xFF;
                return false;
            }
        }
        assert (false);
        return false;
    }

    public int getTermBlockOrd() {
        return this.isLeafBlock ? this.nextEnt : this.termState.termBlockOrd;
    }

    public void decodeMetaData() throws IOException {
        boolean absolute;
        int limit = this.getTermBlockOrd();
        boolean bl = absolute = this.metaDataUpto == 0;
        assert (limit > 0);
        while (this.metaDataUpto < limit) {
            this.termState.docFreq = this.statsReader.readVInt();
            if (this.ite.fr.fieldInfo.getIndexOptions() != IndexOptions.DOCS) {
                this.termState.totalTermFreq = (long)this.termState.docFreq + this.statsReader.readVLong();
            }
            for (int i = 0; i < this.ite.fr.longsSize; ++i) {
                this.longs[i] = this.bytesReader.readVLong();
            }
            this.ite.fr.parent.postingsReader.decodeTerm(this.longs, this.bytesReader, this.ite.fr.fieldInfo, this.termState, absolute);
            ++this.metaDataUpto;
            absolute = false;
        }
        this.termState.termBlockOrd = this.metaDataUpto;
    }
}

