/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.search.spans.NearSpans;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.Spans;

public class NearSpansOrdered
extends NearSpans {
    protected int matchDoc = -1;
    protected int matchStart = -1;
    protected int matchEnd = -1;

    public NearSpansOrdered(SpanNearQuery query, List<Spans> subSpans) throws IOException {
        super(query, subSpans);
        this.atFirstInCurrentDoc = true;
    }

    @Override
    boolean twoPhaseCurrentDocMatches() throws IOException {
        this.subSpansToFirstStartPosition();
        do {
            if (!this.stretchToOrder()) {
                return false;
            }
            if (!this.shrinkToAfterShortestMatch()) continue;
            this.atFirstInCurrentDoc = true;
            return true;
        } while (!this.oneExhaustedInCurrentDoc);
        return false;
    }

    @Override
    public int nextStartPosition() throws IOException {
        if (this.atFirstInCurrentDoc) {
            this.atFirstInCurrentDoc = false;
            return this.matchStart;
        }
        do {
            if (this.oneExhaustedInCurrentDoc) {
                this.matchStart = Integer.MAX_VALUE;
                this.matchEnd = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            if (this.stretchToOrder()) continue;
            this.matchStart = Integer.MAX_VALUE;
            this.matchEnd = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        } while (!this.shrinkToAfterShortestMatch());
        return this.matchStart;
    }

    private void subSpansToFirstStartPosition() throws IOException {
        for (Spans spans : this.subSpans) {
            assert (spans.startPosition() == -1) : "spans=" + spans;
            spans.nextStartPosition();
            assert (spans.startPosition() != Integer.MAX_VALUE);
        }
        this.oneExhaustedInCurrentDoc = false;
    }

    private boolean stretchToOrder() throws IOException {
        Spans prevSpans = this.subSpans[0];
        assert (prevSpans.startPosition() != Integer.MAX_VALUE) : "prevSpans no start position " + prevSpans;
        assert (prevSpans.endPosition() != Integer.MAX_VALUE);
        for (int i = 1; i < this.subSpans.length; ++i) {
            Spans spans = this.subSpans[i];
            assert (spans.startPosition() != Integer.MAX_VALUE);
            assert (spans.endPosition() != Integer.MAX_VALUE);
            while (prevSpans.endPosition() > spans.startPosition()) {
                if (spans.nextStartPosition() != Integer.MAX_VALUE) continue;
                return false;
            }
            prevSpans = spans;
        }
        return true;
    }

    protected boolean shrinkToAfterShortestMatch() throws IOException {
        Spans lastSubSpans = this.subSpans[this.subSpans.length - 1];
        this.matchStart = lastSubSpans.startPosition();
        this.matchEnd = lastSubSpans.endPosition();
        int matchSlop = 0;
        int lastStart = this.matchStart;
        for (int i = this.subSpans.length - 2; i >= 0; --i) {
            Spans prevSpans = this.subSpans[i];
            int prevStart = prevSpans.startPosition();
            int prevEnd = prevSpans.endPosition();
            while (true) {
                if (prevSpans.nextStartPosition() == Integer.MAX_VALUE) {
                    this.oneExhaustedInCurrentDoc = true;
                    break;
                }
                int ppStart = prevSpans.startPosition();
                int ppEnd = prevSpans.endPosition();
                if (ppEnd > lastStart) break;
                prevStart = ppStart;
                prevEnd = ppEnd;
            }
            assert (prevStart <= this.matchStart);
            if (this.matchStart > prevEnd) {
                matchSlop += this.matchStart - prevEnd;
            }
            this.matchStart = prevStart;
            lastStart = prevStart;
        }
        boolean match = matchSlop <= this.allowedSlop;
        return match;
    }

    @Override
    public int startPosition() {
        return this.atFirstInCurrentDoc ? -1 : this.matchStart;
    }

    @Override
    public int endPosition() {
        return this.atFirstInCurrentDoc ? -1 : this.matchEnd;
    }

    @Override
    public Collection<byte[]> getPayload() throws IOException {
        return null;
    }

    @Override
    public boolean isPayloadAvailable() {
        return false;
    }

    @Override
    public String toString() {
        return "NearSpansOrdered(" + this.query.toString() + ")@" + this.docID() + ": " + this.startPosition() + " - " + this.endPosition();
    }
}

