/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.bits;

public class BitUtils {
    private static final long INT_BITS_MASK = 0xFFFFFFFFL;

    public static int getHighInt(long key) {
        return (int)(key >>> 32);
    }

    public static int abs(int a_) {
        int a = a_;
        int signMask = a >> 31;
        a ^= signMask;
        return a += signMask & 1;
    }

    public static long abs(long a_) {
        long a = a_;
        long signMask = a >> 63;
        a ^= signMask;
        return a += signMask & 1L;
    }

    public static int getLowInt(long key) {
        return (int)BitUtils.getLowLong(key);
    }

    public static long getLowLong(long key) {
        return key & 0xFFFFFFFFL;
    }

    public static long setLowInt(long key, int i) {
        return BitUtils.combineInts(i, BitUtils.getHighInt(key));
    }

    public static long setHighInt(long key, int i) {
        return BitUtils.combineInts(BitUtils.getLowInt(key), i);
    }

    public static long max(long a_, long b) {
        long a = a_;
        a -= b;
        a &= (a ^ 0xFFFFFFFFFFFFFFFFL) >> 63;
        return a += b;
    }

    public static long min(long a_, long b) {
        long a = a_;
        a -= b;
        a &= a >> 63;
        return a += b;
    }

    public static long combineInts(int lowInt, int highInt) {
        return (long)highInt << 32 | (long)lowInt & 0xFFFFFFFFL;
    }

    public static void main(String[] argv) {
        long x = 4095L;
        x <<= 63;
        System.out.println(x >>>= 63);
    }
}

