/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.values;

import edu.berkeley.nlp.lm.array.LongArray;
import edu.berkeley.nlp.lm.collections.LongHashSet;
import edu.berkeley.nlp.lm.map.HashNgramMap;
import edu.berkeley.nlp.lm.map.NgramMap;
import edu.berkeley.nlp.lm.util.Annotations;
import edu.berkeley.nlp.lm.values.ValueContainer;

public final class KneserNeyCountValueContainer
implements ValueContainer<KneserNeyCounts> {
    private static final long serialVersionUID = 964277160049236607L;
    @Annotations.PrintMemoryCount
    private LongArray tokenCounts;
    private LongArray prefixTokenCounts;
    @Annotations.PrintMemoryCount
    private final LongArray[] rightDotTypeCounts;
    @Annotations.PrintMemoryCount
    private final LongArray[] dotdotTypeCounts;
    @Annotations.PrintMemoryCount
    private final LongArray[] leftDotTypeCounts;
    @Annotations.PrintMemoryCount
    private final LongHashSet[] oneCountOffsets;
    @Annotations.PrintMemoryCount
    private final LongHashSet[] twoCountOffsets;
    private long bigramTypeCounts = 0L;
    private HashNgramMap<KneserNeyCounts> map;
    private final int startIndex;

    public KneserNeyCountValueContainer(int maxNgramOrder, int startIndex) {
        this.startIndex = startIndex;
        this.tokenCounts = LongArray.StaticMethods.newLongArray(Long.MAX_VALUE, Integer.MAX_VALUE);
        this.prefixTokenCounts = LongArray.StaticMethods.newLongArray(Long.MAX_VALUE, Integer.MAX_VALUE);
        this.oneCountOffsets = new LongHashSet[maxNgramOrder];
        this.twoCountOffsets = new LongHashSet[maxNgramOrder];
        this.rightDotTypeCounts = new LongArray[maxNgramOrder - 1];
        this.leftDotTypeCounts = new LongArray[maxNgramOrder - 1];
        this.dotdotTypeCounts = new LongArray[maxNgramOrder - 2];
        for (int i = 0; i < maxNgramOrder; ++i) {
            this.oneCountOffsets[i] = new LongHashSet();
            this.twoCountOffsets[i] = new LongHashSet();
            if (i >= maxNgramOrder - 1) continue;
            this.rightDotTypeCounts[i] = LongArray.StaticMethods.newLongArray(Long.MAX_VALUE, Integer.MAX_VALUE);
            this.leftDotTypeCounts[i] = LongArray.StaticMethods.newLongArray(Long.MAX_VALUE, Integer.MAX_VALUE);
            if (i >= maxNgramOrder - 2) continue;
            this.dotdotTypeCounts[i] = LongArray.StaticMethods.newLongArray(Long.MAX_VALUE, Integer.MAX_VALUE);
        }
    }

    public KneserNeyCountValueContainer createFreshValues(long[] numNgramsForEachOrder) {
        KneserNeyCountValueContainer kneseryNeyCountValueContainer = new KneserNeyCountValueContainer(this.rightDotTypeCounts.length + 1, this.startIndex);
        kneseryNeyCountValueContainer.bigramTypeCounts = this.bigramTypeCounts;
        return kneseryNeyCountValueContainer;
    }

    @Override
    public void getFromOffset(long offset, int ngramOrder, @Annotations.OutputParameter KneserNeyCounts outputVal) {
        boolean isHighestOrder = this.isHighestOrder(ngramOrder);
        boolean isSecondHighestOrder = this.isSecondHighestOrder(ngramOrder);
        outputVal.tokenCounts = isHighestOrder ? this.tokenCounts.get(offset) : (isSecondHighestOrder ? KneserNeyCountValueContainer.getSafe(offset, this.prefixTokenCounts) : -1L);
        outputVal.rightDotTypeCounts = (int)(isHighestOrder || offset >= this.rightDotTypeCounts[ngramOrder].size() ? -1L : this.rightDotTypeCounts[ngramOrder].get(offset));
        outputVal.leftDotTypeCounts = (int)(isHighestOrder || offset >= this.leftDotTypeCounts[ngramOrder].size() ? -1L : this.leftDotTypeCounts[ngramOrder].get(offset));
        outputVal.dotdotTypeCounts = (int)(isHighestOrder || isSecondHighestOrder || offset >= this.dotdotTypeCounts[ngramOrder].size() ? -1L : this.dotdotTypeCounts[ngramOrder].get(offset));
        outputVal.isOneCount = this.oneCountOffsets[ngramOrder].containsKey(offset);
        outputVal.isTwoCount = this.twoCountOffsets[ngramOrder].containsKey(offset);
        outputVal.isInternal = true;
    }

    private static long getSafe(long offset, LongArray array) {
        return offset >= array.size() ? 0L : array.get(offset);
    }

    @Override
    public void trimAfterNgram(int ngramOrder, long size) {
    }

    @Override
    public KneserNeyCounts getScratchValue() {
        return new KneserNeyCounts();
    }

    @Override
    public boolean add(int[] ngram, int startPos, int endPos, int ngramOrder, long offset, long contextOffset, int word, KneserNeyCounts val, long suffixOffset, boolean ngramIsNew) {
        boolean startsWithStart;
        if (val == null) {
            return true;
        }
        boolean bl = startsWithStart = ngram[startPos] == this.startIndex;
        if (this.isHighestOrder(ngramOrder) || startsWithStart) {
            long relevantCount = val.tokenCounts;
            if (ngramIsNew) {
                if (relevantCount == 1L) {
                    this.oneCountOffsets[ngramOrder].put(offset);
                } else if (relevantCount == 2L) {
                    this.twoCountOffsets[ngramOrder].put(offset);
                }
            } else if (this.oneCountOffsets[ngramOrder].containsKey(offset)) {
                this.oneCountOffsets[ngramOrder].remove(offset);
                if (relevantCount == 1L) {
                    this.twoCountOffsets[ngramOrder].put(offset);
                }
            } else if (this.twoCountOffsets[ngramOrder].containsKey(offset)) {
                this.twoCountOffsets[ngramOrder].remove(offset);
            }
        }
        if (val.tokenCounts > 0L && !val.isInternal && startsWithStart && ngramOrder < this.leftDotTypeCounts.length) {
            this.leftDotTypeCounts[ngramOrder].incrementCount(offset, val.tokenCounts);
        }
        assert (!this.map.isReversed());
        if (this.isHighestOrder(ngramOrder)) {
            this.tokenCounts.incrementCount(offset, val.tokenCounts);
            this.prefixTokenCounts.incrementCount(contextOffset, val.tokenCounts);
        }
        assert (!val.isInternal || ngramIsNew);
        if (ngramIsNew) {
            if (val.isInternal) {
                if (val.dotdotTypeCounts > 0L) {
                    this.dotdotTypeCounts[ngramOrder].incrementCount(offset, val.dotdotTypeCounts);
                }
                if (val.leftDotTypeCounts > 0L) {
                    this.leftDotTypeCounts[ngramOrder].incrementCount(offset, val.leftDotTypeCounts);
                }
                if (val.rightDotTypeCounts > 0L) {
                    this.rightDotTypeCounts[ngramOrder].incrementCount(offset, val.rightDotTypeCounts);
                }
                if (val.isOneCount) {
                    this.oneCountOffsets[ngramOrder].put(offset);
                }
                if (val.isTwoCount) {
                    this.twoCountOffsets[ngramOrder].put(offset);
                }
            } else if (ngramOrder > 0) {
                long oldCount;
                if (ngramOrder == 1) {
                    ++this.bigramTypeCounts;
                } else {
                    long dotDotOffset = this.map.getPrefixOffset(suffixOffset, endPos - startPos - 2);
                    this.dotdotTypeCounts[ngramOrder - 2].incrementCount(dotDotOffset, 1L);
                }
                long leftDotOffset = suffixOffset;
                assert (suffixOffset >= 0L);
                long l = oldCount = leftDotOffset >= this.leftDotTypeCounts[ngramOrder - 1].size() ? 0L : this.leftDotTypeCounts[ngramOrder - 1].get(leftDotOffset);
                if (oldCount == 0L) {
                    this.oneCountOffsets[ngramOrder - 1].put(leftDotOffset);
                } else if (oldCount == 1L) {
                    this.oneCountOffsets[ngramOrder - 1].remove(leftDotOffset);
                    this.twoCountOffsets[ngramOrder - 1].put(leftDotOffset);
                } else if (oldCount == 2L) {
                    this.twoCountOffsets[ngramOrder - 1].remove(leftDotOffset);
                }
                this.leftDotTypeCounts[ngramOrder - 1].incrementCount(leftDotOffset, 1L);
                long rightDotOffset = contextOffset;
                assert (contextOffset >= 0L);
                this.rightDotTypeCounts[ngramOrder - 1].incrementCount(rightDotOffset, 1L);
            }
        }
        return true;
    }

    @Override
    public void setSizeAtLeast(long size, int ngramOrder) {
        if (this.isHighestOrder(ngramOrder)) {
            this.tokenCounts.setAndGrowIfNeeded(size - 1L, 0L);
        } else {
            if (this.isSecondHighestOrder(ngramOrder)) {
                this.prefixTokenCounts.setAndGrowIfNeeded(size - 1L, 0L);
            }
            this.leftDotTypeCounts[ngramOrder].setAndGrowIfNeeded(size - 1L, 0L);
            this.rightDotTypeCounts[ngramOrder].setAndGrowIfNeeded(size - 1L, 0L);
            if (!this.isSecondHighestOrder(ngramOrder)) {
                this.dotdotTypeCounts[ngramOrder].setAndGrowIfNeeded(size - 1L, 0L);
            }
        }
    }

    private boolean isHighestOrder(int ngramOrder) {
        return ngramOrder == this.rightDotTypeCounts.length;
    }

    private boolean isSecondHighestOrder(int ngramOrder) {
        return ngramOrder == this.rightDotTypeCounts.length - 1;
    }

    @Override
    public void setFromOtherValues(ValueContainer<KneserNeyCounts> other) {
        KneserNeyCountValueContainer other_ = (KneserNeyCountValueContainer)other;
        this.tokenCounts = other_.tokenCounts;
        System.arraycopy(other_.dotdotTypeCounts, 0, this.dotdotTypeCounts, 0, this.dotdotTypeCounts.length);
        System.arraycopy(other_.rightDotTypeCounts, 0, this.rightDotTypeCounts, 0, this.rightDotTypeCounts.length);
        System.arraycopy(other_.leftDotTypeCounts, 0, this.leftDotTypeCounts, 0, this.leftDotTypeCounts.length);
        System.arraycopy(other_.oneCountOffsets, 0, this.oneCountOffsets, 0, this.oneCountOffsets.length);
        System.arraycopy(other_.twoCountOffsets, 0, this.twoCountOffsets, 0, this.twoCountOffsets.length);
        this.prefixTokenCounts = other_.prefixTokenCounts;
        this.bigramTypeCounts = other_.bigramTypeCounts;
    }

    @Override
    public void trim() {
        this.tokenCounts.trim();
        this.prefixTokenCounts.trim();
        for (int i = 0; i < this.rightDotTypeCounts.length; ++i) {
            this.rightDotTypeCounts[i].trim();
            this.leftDotTypeCounts[i].trim();
            if (i >= this.dotdotTypeCounts.length) continue;
            this.dotdotTypeCounts[i].trim();
        }
    }

    @Override
    public void setMap(NgramMap<KneserNeyCounts> map) {
        this.map = (HashNgramMap)map;
    }

    @Override
    public void clearStorageForOrder(int ngramOrder) {
        this.oneCountOffsets[ngramOrder].clear();
        this.twoCountOffsets[ngramOrder].clear();
        if (ngramOrder == this.rightDotTypeCounts.length) {
            this.tokenCounts = null;
        } else if (ngramOrder == this.rightDotTypeCounts.length - 1) {
            this.prefixTokenCounts = null;
        }
        if (ngramOrder < this.rightDotTypeCounts.length) {
            this.rightDotTypeCounts[ngramOrder] = null;
            this.leftDotTypeCounts[ngramOrder] = null;
            if (ngramOrder < this.dotdotTypeCounts.length) {
                this.dotdotTypeCounts[ngramOrder] = null;
            }
        }
    }

    @Override
    public boolean storeSuffixoffsets() {
        return true;
    }

    public long getBigramTypeCounts() {
        return this.bigramTypeCounts;
    }

    public int getNumOneCountNgrams(int ngramOrder) {
        return this.oneCountOffsets[ngramOrder].size();
    }

    public int getNumTwoCountNgrams(int ngramOrder) {
        return this.twoCountOffsets[ngramOrder].size();
    }

    @Override
    public int numValueBits(int ngramOrder) {
        return 0;
    }

    public static class KneserNeyCounts {
        public long tokenCounts = 0L;
        public long leftDotTypeCounts = 0L;
        public long rightDotTypeCounts = 0L;
        public long dotdotTypeCounts = 0L;
        public boolean isOneCount = false;
        public boolean isTwoCount = false;
        boolean isInternal = false;
    }
}

