/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.da.comp.writer4latex;

import com.sun.star.awt.XDialog;
import com.sun.star.lang.XInitialization;
import com.sun.star.uno.Exception;
import com.sun.star.uno.XComponentContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import org.openoffice.da.comp.w2lcommon.helper.DialogBase;

public class LogViewerDialog
extends DialogBase
implements XInitialization {
    public static String __serviceName = "org.openoffice.da.writer4latex.LogViewerDialog";
    public static String __implementationName = "org.openoffice.da.comp.writer4latex.LogViewerDialog";
    private String sBaseUrl = null;
    private String sLaTeXLog = null;
    private String sBibTeXLog = null;
    private String sMakeindexLog = null;

    @Override
    public String getDialogLibraryName() {
        return "W4LDialogs";
    }

    @Override
    public String getDialogName() {
        return "LogViewer";
    }

    @Override
    public void initialize() {
        if (this.sBaseUrl != null) {
            this.sLaTeXLog = this.readTextFile(this.sBaseUrl + ".log");
            this.sBibTeXLog = this.readTextFile(this.sBaseUrl + ".blg");
            this.sMakeindexLog = this.readTextFile(this.sBaseUrl + ".ilg");
            this.setComboBoxText("LogContents", this.sLaTeXLog);
        }
    }

    @Override
    public void endDialog() {
    }

    public LogViewerDialog(XComponentContext xContext) {
        super(xContext);
    }

    public void initialize(Object[] object) throws Exception {
        if (object.length > 0 && object[0] instanceof String) {
            this.sBaseUrl = (String)object[0];
        }
    }

    @Override
    public boolean callHandlerMethod(XDialog xDialog, Object event, String sMethod) {
        if (sMethod.equals("ViewLaTeXLog")) {
            this.setComboBoxText("LogContents", this.sLaTeXLog);
        } else if (sMethod.equals("ViewBibTeXLog")) {
            this.setComboBoxText("LogContents", this.sBibTeXLog);
        } else if (sMethod.equals("ViewMakeindexLog")) {
            this.setComboBoxText("LogContents", this.sMakeindexLog);
        }
        return true;
    }

    @Override
    public String[] getSupportedMethodNames() {
        String[] sNames = new String[]{"ViewLaTeXLog", "ViewBibTeXLog", "ViewMakeindexLog"};
        return sNames;
    }

    private String readTextFile(String sUrl) {
        StringBuilder buf = new StringBuilder();
        try {
            File file = new File(new URI(sUrl));
            if (file.exists() && file.isFile()) {
                int n;
                InputStreamReader isr = new InputStreamReader(new FileInputStream(file));
                do {
                    if ((n = isr.read()) <= -1) continue;
                    buf.append((char)n);
                } while (n > -1);
                isr.close();
            }
        }
        catch (URISyntaxException e) {
            return "";
        }
        catch (IOException e) {
            return "";
        }
        return buf.toString();
    }
}

