/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.util.Collection;
import org.apache.maven.execution.ProjectExecutionEvent;
import org.apache.maven.execution.ProjectExecutionListener;
import org.apache.maven.lifecycle.LifecycleExecutionException;

class CompoundProjectExecutionListener
implements ProjectExecutionListener {
    private final Collection<ProjectExecutionListener> listeners;

    public CompoundProjectExecutionListener(Collection<ProjectExecutionListener> listeners) {
        this.listeners = listeners;
    }

    @Override
    public void beforeProjectExecution(ProjectExecutionEvent event) throws LifecycleExecutionException {
        for (ProjectExecutionListener listener : this.listeners) {
            listener.beforeProjectExecution(event);
        }
    }

    @Override
    public void beforeProjectLifecycleExecution(ProjectExecutionEvent event) throws LifecycleExecutionException {
        for (ProjectExecutionListener listener : this.listeners) {
            listener.beforeProjectLifecycleExecution(event);
        }
    }

    @Override
    public void afterProjectExecutionSuccess(ProjectExecutionEvent event) throws LifecycleExecutionException {
        for (ProjectExecutionListener listener : this.listeners) {
            listener.afterProjectExecutionSuccess(event);
        }
    }

    @Override
    public void afterProjectExecutionFailure(ProjectExecutionEvent event) {
        for (ProjectExecutionListener listener : this.listeners) {
            listener.afterProjectExecutionFailure(event);
        }
    }
}

