'use strict';

var pngSignature = 'PNG\r\n\x1a\n';
function isPNG (buffer) {
  if (pngSignature === buffer.toString('ascii', 1, 8)) {
    if ('IHDR' !== buffer.toString('ascii', 12, 16)) {
      throw new TypeError('invalid png');
    }
    return true;
  }
}

function calculate (buffer) {
  return {
    'width': buffer.readUInt32BE(16),
    'height': buffer.readUInt32BE(20)
  };
}

module.exports = {
  'detect': isPNG,
  'calculate': calculate
};
