/* noise-core.h generated by valac 0.32.0, the Vala compiler, do not modify */


#ifndef __NOISE_CORE_H__
#define __NOISE_CORE_H__

#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <granite.h>
#include <gee.h>
#include <gst/gst.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <time.h>

G_BEGIN_DECLS


#define NOISE_PLUGINS_TYPE_INTERFACE (noise_plugins_interface_get_type ())
#define NOISE_PLUGINS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOISE_PLUGINS_TYPE_INTERFACE, NoisePluginsInterface))
#define NOISE_PLUGINS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NOISE_PLUGINS_TYPE_INTERFACE, NoisePluginsInterfaceClass))
#define NOISE_PLUGINS_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOISE_PLUGINS_TYPE_INTERFACE))
#define NOISE_PLUGINS_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NOISE_PLUGINS_TYPE_INTERFACE))
#define NOISE_PLUGINS_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NOISE_PLUGINS_TYPE_INTERFACE, NoisePluginsInterfaceClass))

typedef struct _NoisePluginsInterface NoisePluginsInterface;
typedef struct _NoisePluginsInterfaceClass NoisePluginsInterfaceClass;
typedef struct _NoisePluginsInterfacePrivate NoisePluginsInterfacePrivate;

#define NOISE_PLUGINS_INTERFACE_TYPE_HOOK (noise_plugins_interface_hook_get_type ())

#define NOISE_PLUGINS_TYPE_MANAGER (noise_plugins_manager_get_type ())
#define NOISE_PLUGINS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOISE_PLUGINS_TYPE_MANAGER, NoisePluginsManager))
#define NOISE_PLUGINS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NOISE_PLUGINS_TYPE_MANAGER, NoisePluginsManagerClass))
#define NOISE_PLUGINS_IS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOISE_PLUGINS_TYPE_MANAGER))
#define NOISE_PLUGINS_IS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NOISE_PLUGINS_TYPE_MANAGER))
#define NOISE_PLUGINS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NOISE_PLUGINS_TYPE_MANAGER, NoisePluginsManagerClass))

typedef struct _NoisePluginsManager NoisePluginsManager;
typedef struct _NoisePluginsManagerClass NoisePluginsManagerClass;
typedef struct _NoisePluginsManagerPrivate NoisePluginsManagerPrivate;

#define NOISE_SETTINGS_TYPE_SAVED_STATE (noise_settings_saved_state_get_type ())
#define NOISE_SETTINGS_SAVED_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOISE_SETTINGS_TYPE_SAVED_STATE, NoiseSettingsSavedState))
#define NOISE_SETTINGS_SAVED_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NOISE_SETTINGS_TYPE_SAVED_STATE, NoiseSettingsSavedStateClass))
#define NOISE_SETTINGS_IS_SAVED_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOISE_SETTINGS_TYPE_SAVED_STATE))
#define NOISE_SETTINGS_IS_SAVED_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NOISE_SETTINGS_TYPE_SAVED_STATE))
#define NOISE_SETTINGS_SAVED_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NOISE_SETTINGS_TYPE_SAVED_STATE, NoiseSettingsSavedStateClass))

typedef struct _NoiseSettingsSavedState NoiseSettingsSavedState;
typedef struct _NoiseSettingsSavedStateClass NoiseSettingsSavedStateClass;
typedef struct _NoiseSettingsSavedStatePrivate NoiseSettingsSavedStatePrivate;

#define NOISE_SETTINGS_TYPE_WINDOW_STATE (noise_settings_window_state_get_type ())

#define NOISE_SETTINGS_TYPE_MAIN (noise_settings_main_get_type ())
#define NOISE_SETTINGS_MAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOISE_SETTINGS_TYPE_MAIN, NoiseSettingsMain))
#define NOISE_SETTINGS_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NOISE_SETTINGS_TYPE_MAIN, NoiseSettingsMainClass))
#define NOISE_SETTINGS_IS_MAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOISE_SETTINGS_TYPE_MAIN))
#define NOISE_SETTINGS_IS_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NOISE_SETTINGS_TYPE_MAIN))
#define NOISE_SETTINGS_MAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NOISE_SETTINGS_TYPE_MAIN, NoiseSettingsMainClass))

typedef struct _NoiseSettingsMain NoiseSettingsMain;
typedef struct _NoiseSettingsMainClass NoiseSettingsMainClass;
typedef struct _NoiseSettingsMainPrivate NoiseSettingsMainPrivate;

#define NOISE_SETTINGS_TYPE_SHUFFLE (noise_settings_shuffle_get_type ())

#define NOISE_SETTINGS_TYPE_REPEAT (noise_settings_repeat_get_type ())

#define NOISE_SETTINGS_TYPE_EQUALIZER (noise_settings_equalizer_get_type ())
#define NOISE_SETTINGS_EQUALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOISE_SETTINGS_TYPE_EQUALIZER, NoiseSettingsEqualizer))
#define NOISE_SETTINGS_EQUALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NOISE_SETTINGS_TYPE_EQUALIZER, NoiseSettingsEqualizerClass))
#define NOISE_SETTINGS_IS_EQUALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOISE_SETTINGS_TYPE_EQUALIZER))
#define NOISE_SETTINGS_IS_EQUALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NOISE_SETTINGS_TYPE_EQUALIZER))
#define NOISE_SETTINGS_EQUALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NOISE_SETTINGS_TYPE_EQUALIZER, NoiseSettingsEqualizerClass))

typedef struct _NoiseSettingsEqualizer NoiseSettingsEqualizer;
typedef struct _NoiseSettingsEqualizerClass NoiseSettingsEqualizerClass;
typedef struct _NoiseSettingsEqualizerPrivate NoiseSettingsEqualizerPrivate;

#define NOISE_TYPE_EQUALIZER_PRESET (noise_equalizer_preset_get_type ())
#define NOISE_EQUALIZER_PRESET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOISE_TYPE_EQUALIZER_PRESET, NoiseEqualizerPreset))
#define NOISE_EQUALIZER_PRESET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NOISE_TYPE_EQUALIZER_PRESET, NoiseEqualizerPresetClass))
#define NOISE_IS_EQUALIZER_PRESET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOISE_TYPE_EQUALIZER_PRESET))
#define NOISE_IS_EQUALIZER_PRESET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NOISE_TYPE_EQUALIZER_PRESET))
#define NOISE_EQUALIZER_PRESET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NOISE_TYPE_EQUALIZER_PRESET, NoiseEqualizerPresetClass))

typedef struct _NoiseEqualizerPreset NoiseEqualizerPreset;
typedef struct _NoiseEqualizerPresetClass NoiseEqualizerPresetClass;
typedef struct _NoiseEqualizerPresetPrivate NoiseEqualizerPresetPrivate;

#define NOISE_TYPE_PLAYER (noise_player_get_type ())
#define NOISE_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOISE_TYPE_PLAYER, NoisePlayer))
#define NOISE_IS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOISE_TYPE_PLAYER))
#define NOISE_PLAYER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), NOISE_TYPE_PLAYER, NoisePlayerIface))

typedef struct _NoisePlayer NoisePlayer;
typedef struct _NoisePlayerIface NoisePlayerIface;

#define NOISE_TYPE_PLAYBACK (noise_playback_get_type ())
#define NOISE_PLAYBACK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOISE_TYPE_PLAYBACK, NoisePlayback))
#define NOISE_IS_PLAYBACK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOISE_TYPE_PLAYBACK))
#define NOISE_PLAYBACK_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), NOISE_TYPE_PLAYBACK, NoisePlaybackIface))

typedef struct _NoisePlayback NoisePlayback;
typedef struct _NoisePlaybackIface NoisePlaybackIface;

#define NOISE_TYPE_MEDIA (noise_media_get_type ())
#define NOISE_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOISE_TYPE_MEDIA, NoiseMedia))
#define NOISE_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NOISE_TYPE_MEDIA, NoiseMediaClass))
#define NOISE_IS_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOISE_TYPE_MEDIA))
#define NOISE_IS_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NOISE_TYPE_MEDIA))
#define NOISE_MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NOISE_TYPE_MEDIA, NoiseMediaClass))

typedef struct _NoiseMedia NoiseMedia;
typedef struct _NoiseMediaClass NoiseMediaClass;

#define NOISE_PLAYER_TYPE_SHUFFLE (noise_player_shuffle_get_type ())

#define NOISE_PLAYER_TYPE_REPEAT (noise_player_repeat_get_type ())

#define NOISE_TYPE_LIBRARY_WINDOW_INTERFACE (noise_library_window_interface_get_type ())
#define NOISE_LIBRARY_WINDOW_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOISE_TYPE_LIBRARY_WINDOW_INTERFACE, NoiseLibraryWindowInterface))
#define NOISE_IS_LIBRARY_WINDOW_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOISE_TYPE_LIBRARY_WINDOW_INTERFACE))
#define NOISE_LIBRARY_WINDOW_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), NOISE_TYPE_LIBRARY_WINDOW_INTERFACE, NoiseLibraryWindowInterfaceIface))

typedef struct _NoiseLibraryWindowInterface NoiseLibraryWindowInterface;
typedef struct _NoiseLibraryWindowInterfaceIface NoiseLibraryWindowInterfaceIface;

#define NOISE_TYPE_LIBRARY (noise_library_get_type ())
#define NOISE_LIBRARY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOISE_TYPE_LIBRARY, NoiseLibrary))
#define NOISE_LIBRARY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NOISE_TYPE_LIBRARY, NoiseLibraryClass))
#define NOISE_IS_LIBRARY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOISE_TYPE_LIBRARY))
#define NOISE_IS_LIBRARY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NOISE_TYPE_LIBRARY))
#define NOISE_LIBRARY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NOISE_TYPE_LIBRARY, NoiseLibraryClass))

typedef struct _NoiseLibrary NoiseLibrary;
typedef struct _NoiseLibraryClass NoiseLibraryClass;
typedef struct _NoiseLibraryPrivate NoiseLibraryPrivate;

#define NOISE_TYPE_PLAYLIST (noise_playlist_get_type ())
#define NOISE_PLAYLIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOISE_TYPE_PLAYLIST, NoisePlaylist))
#define NOISE_PLAYLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NOISE_TYPE_PLAYLIST, NoisePlaylistClass))
#define NOISE_IS_PLAYLIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOISE_TYPE_PLAYLIST))
#define NOISE_IS_PLAYLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NOISE_TYPE_PLAYLIST))
#define NOISE_PLAYLIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NOISE_TYPE_PLAYLIST, NoisePlaylistClass))

typedef struct _NoisePlaylist NoisePlaylist;
typedef struct _NoisePlaylistClass NoisePlaylistClass;

#define NOISE_TYPE_STATIC_PLAYLIST (noise_static_playlist_get_type ())
#define NOISE_STATIC_PLAYLIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOISE_TYPE_STATIC_PLAYLIST, NoiseStaticPlaylist))
#define NOISE_STATIC_PLAYLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NOISE_TYPE_STATIC_PLAYLIST, NoiseStaticPlaylistClass))
#define NOISE_IS_STATIC_PLAYLIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOISE_TYPE_STATIC_PLAYLIST))
#define NOISE_IS_STATIC_PLAYLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NOISE_TYPE_STATIC_PLAYLIST))
#define NOISE_STATIC_PLAYLIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NOISE_TYPE_STATIC_PLAYLIST, NoiseStaticPlaylistClass))

typedef struct _NoiseStaticPlaylist NoiseStaticPlaylist;
typedef struct _NoiseStaticPlaylistClass NoiseStaticPlaylistClass;

#define NOISE_TYPE_SMART_PLAYLIST (noise_smart_playlist_get_type ())
#define NOISE_SMART_PLAYLIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOISE_TYPE_SMART_PLAYLIST, NoiseSmartPlaylist))
#define NOISE_SMART_PLAYLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NOISE_TYPE_SMART_PLAYLIST, NoiseSmartPlaylistClass))
#define NOISE_IS_SMART_PLAYLIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOISE_TYPE_SMART_PLAYLIST))
#define NOISE_IS_SMART_PLAYLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NOISE_TYPE_SMART_PLAYLIST))
#define NOISE_SMART_PLAYLIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NOISE_TYPE_SMART_PLAYLIST, NoiseSmartPlaylistClass))

typedef struct _NoiseSmartPlaylist NoiseSmartPlaylist;
typedef struct _NoiseSmartPlaylistClass NoiseSmartPlaylistClass;

#define NOISE_TYPE_LIBRARIES_MANAGER (noise_libraries_manager_get_type ())
#define NOISE_LIBRARIES_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOISE_TYPE_LIBRARIES_MANAGER, NoiseLibrariesManager))
#define NOISE_LIBRARIES_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NOISE_TYPE_LIBRARIES_MANAGER, NoiseLibrariesManagerClass))
#define NOISE_IS_LIBRARIES_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOISE_TYPE_LIBRARIES_MANAGER))
#define NOISE_IS_LIBRARIES_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NOISE_TYPE_LIBRARIES_MANAGER))
#define NOISE_LIBRARIES_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NOISE_TYPE_LIBRARIES_MANAGER, NoiseLibrariesManagerClass))

typedef struct _NoiseLibrariesManager NoiseLibrariesManager;
typedef struct _NoiseLibrariesManagerClass NoiseLibrariesManagerClass;
typedef struct _NoiseLibrariesManagerPrivate NoiseLibrariesManagerPrivate;

#define NOISE_TYPE_NOTIFICATION_MANAGER (noise_notification_manager_get_type ())
#define NOISE_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOISE_TYPE_NOTIFICATION_MANAGER, NoiseNotificationManager))
#define NOISE_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NOISE_TYPE_NOTIFICATION_MANAGER, NoiseNotificationManagerClass))
#define NOISE_IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOISE_TYPE_NOTIFICATION_MANAGER))
#define NOISE_IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NOISE_TYPE_NOTIFICATION_MANAGER))
#define NOISE_NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NOISE_TYPE_NOTIFICATION_MANAGER, NoiseNotificationManagerClass))

typedef struct _NoiseNotificationManager NoiseNotificationManager;
typedef struct _NoiseNotificationManagerClass NoiseNotificationManagerClass;
typedef struct _NoiseNotificationManagerPrivate NoiseNotificationManagerPrivate;
typedef struct _NoiseMediaPrivate NoiseMediaPrivate;

#define NOISE_TYPE_ALBUM (noise_album_get_type ())
#define NOISE_ALBUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOISE_TYPE_ALBUM, NoiseAlbum))
#define NOISE_ALBUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NOISE_TYPE_ALBUM, NoiseAlbumClass))
#define NOISE_IS_ALBUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOISE_TYPE_ALBUM))
#define NOISE_IS_ALBUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NOISE_TYPE_ALBUM))
#define NOISE_ALBUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NOISE_TYPE_ALBUM, NoiseAlbumClass))

typedef struct _NoiseAlbum NoiseAlbum;
typedef struct _NoiseAlbumClass NoiseAlbumClass;
typedef struct _NoiseAlbumPrivate NoiseAlbumPrivate;

#define NOISE_TYPE_DEVICE (noise_device_get_type ())
#define NOISE_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOISE_TYPE_DEVICE, NoiseDevice))
#define NOISE_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOISE_TYPE_DEVICE))
#define NOISE_DEVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), NOISE_TYPE_DEVICE, NoiseDeviceIface))

typedef struct _NoiseDevice NoiseDevice;
typedef struct _NoiseDeviceIface NoiseDeviceIface;

#define NOISE_TYPE_DEVICE_PREFERENCES (noise_device_preferences_get_type ())
#define NOISE_DEVICE_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOISE_TYPE_DEVICE_PREFERENCES, NoiseDevicePreferences))
#define NOISE_DEVICE_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NOISE_TYPE_DEVICE_PREFERENCES, NoiseDevicePreferencesClass))
#define NOISE_IS_DEVICE_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOISE_TYPE_DEVICE_PREFERENCES))
#define NOISE_IS_DEVICE_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NOISE_TYPE_DEVICE_PREFERENCES))
#define NOISE_DEVICE_PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NOISE_TYPE_DEVICE_PREFERENCES, NoiseDevicePreferencesClass))

typedef struct _NoiseDevicePreferences NoiseDevicePreferences;
typedef struct _NoiseDevicePreferencesClass NoiseDevicePreferencesClass;

#define NOISE_TYPE_NETWORK_DEVICE (noise_network_device_get_type ())
#define NOISE_NETWORK_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOISE_TYPE_NETWORK_DEVICE, NoiseNetworkDevice))
#define NOISE_IS_NETWORK_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOISE_TYPE_NETWORK_DEVICE))
#define NOISE_NETWORK_DEVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), NOISE_TYPE_NETWORK_DEVICE, NoiseNetworkDeviceIface))

typedef struct _NoiseNetworkDevice NoiseNetworkDevice;
typedef struct _NoiseNetworkDeviceIface NoiseNetworkDeviceIface;

#define NOISE_TYPE_DEVICE_MANAGER (noise_device_manager_get_type ())
#define NOISE_DEVICE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOISE_TYPE_DEVICE_MANAGER, NoiseDeviceManager))
#define NOISE_DEVICE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NOISE_TYPE_DEVICE_MANAGER, NoiseDeviceManagerClass))
#define NOISE_IS_DEVICE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOISE_TYPE_DEVICE_MANAGER))
#define NOISE_IS_DEVICE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NOISE_TYPE_DEVICE_MANAGER))
#define NOISE_DEVICE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NOISE_TYPE_DEVICE_MANAGER, NoiseDeviceManagerClass))

typedef struct _NoiseDeviceManager NoiseDeviceManager;
typedef struct _NoiseDeviceManagerClass NoiseDeviceManagerClass;
typedef struct _NoiseDeviceManagerPrivate NoiseDeviceManagerPrivate;
typedef struct _NoiseDevicePreferencesPrivate NoiseDevicePreferencesPrivate;
typedef struct _NoisePlaylistPrivate NoisePlaylistPrivate;
typedef struct _NoiseStaticPlaylistPrivate NoiseStaticPlaylistPrivate;
typedef struct _NoiseSmartPlaylistPrivate NoiseSmartPlaylistPrivate;

#define NOISE_TYPE_SMART_QUERY (noise_smart_query_get_type ())
#define NOISE_SMART_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOISE_TYPE_SMART_QUERY, NoiseSmartQuery))
#define NOISE_SMART_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NOISE_TYPE_SMART_QUERY, NoiseSmartQueryClass))
#define NOISE_IS_SMART_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOISE_TYPE_SMART_QUERY))
#define NOISE_IS_SMART_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NOISE_TYPE_SMART_QUERY))
#define NOISE_SMART_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NOISE_TYPE_SMART_QUERY, NoiseSmartQueryClass))

typedef struct _NoiseSmartQuery NoiseSmartQuery;
typedef struct _NoiseSmartQueryClass NoiseSmartQueryClass;

#define NOISE_SMART_PLAYLIST_TYPE_CONDITIONAL_TYPE (noise_smart_playlist_conditional_type_get_type ())
typedef struct _NoiseSmartQueryPrivate NoiseSmartQueryPrivate;

#define NOISE_SMART_QUERY_TYPE_COMPARATOR_TYPE (noise_smart_query_comparator_type_get_type ())

#define NOISE_SMART_QUERY_TYPE_FIELD_TYPE (noise_smart_query_field_type_get_type ())

#define NOISE_TYPE_COMPARE_FUNC_HOLDER (noise_compare_func_holder_get_type ())
#define NOISE_COMPARE_FUNC_HOLDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOISE_TYPE_COMPARE_FUNC_HOLDER, NoiseCompareFuncHolder))
#define NOISE_COMPARE_FUNC_HOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NOISE_TYPE_COMPARE_FUNC_HOLDER, NoiseCompareFuncHolderClass))
#define NOISE_IS_COMPARE_FUNC_HOLDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOISE_TYPE_COMPARE_FUNC_HOLDER))
#define NOISE_IS_COMPARE_FUNC_HOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NOISE_TYPE_COMPARE_FUNC_HOLDER))
#define NOISE_COMPARE_FUNC_HOLDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NOISE_TYPE_COMPARE_FUNC_HOLDER, NoiseCompareFuncHolderClass))

typedef struct _NoiseCompareFuncHolder NoiseCompareFuncHolder;
typedef struct _NoiseCompareFuncHolderClass NoiseCompareFuncHolderClass;
typedef struct _NoiseCompareFuncHolderPrivate NoiseCompareFuncHolderPrivate;

#define NOISE_TYPE_ICON (noise_icon_get_type ())
#define NOISE_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOISE_TYPE_ICON, NoiseIcon))
#define NOISE_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NOISE_TYPE_ICON, NoiseIconClass))
#define NOISE_IS_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOISE_TYPE_ICON))
#define NOISE_IS_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NOISE_TYPE_ICON))
#define NOISE_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NOISE_TYPE_ICON, NoiseIconClass))

typedef struct _NoiseIcon NoiseIcon;
typedef struct _NoiseIconClass NoiseIconClass;
typedef struct _NoiseIconPrivate NoiseIconPrivate;

#define NOISE_TYPE_ICONS (noise_icons_get_type ())
#define NOISE_ICONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOISE_TYPE_ICONS, NoiseIcons))
#define NOISE_ICONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NOISE_TYPE_ICONS, NoiseIconsClass))
#define NOISE_IS_ICONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOISE_TYPE_ICONS))
#define NOISE_IS_ICONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NOISE_TYPE_ICONS))
#define NOISE_ICONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NOISE_TYPE_ICONS, NoiseIconsClass))

typedef struct _NoiseIcons NoiseIcons;
typedef struct _NoiseIconsClass NoiseIconsClass;
typedef struct _NoiseIconsPrivate NoiseIconsPrivate;

#define NOISE_TYPE_PIXBUF_CACHE (noise_pixbuf_cache_get_type ())
#define NOISE_PIXBUF_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOISE_TYPE_PIXBUF_CACHE, NoisePixbufCache))
#define NOISE_PIXBUF_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NOISE_TYPE_PIXBUF_CACHE, NoisePixbufCacheClass))
#define NOISE_IS_PIXBUF_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOISE_TYPE_PIXBUF_CACHE))
#define NOISE_IS_PIXBUF_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NOISE_TYPE_PIXBUF_CACHE))
#define NOISE_PIXBUF_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NOISE_TYPE_PIXBUF_CACHE, NoisePixbufCacheClass))

typedef struct _NoisePixbufCache NoisePixbufCache;
typedef struct _NoisePixbufCacheClass NoisePixbufCacheClass;
typedef struct _NoisePixbufCachePrivate NoisePixbufCachePrivate;

#define NOISE_TYPE_PIPELINE (noise_pipeline_get_type ())
#define NOISE_PIPELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOISE_TYPE_PIPELINE, NoisePipeline))
#define NOISE_PIPELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NOISE_TYPE_PIPELINE, NoisePipelineClass))
#define NOISE_IS_PIPELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOISE_TYPE_PIPELINE))
#define NOISE_IS_PIPELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NOISE_TYPE_PIPELINE))
#define NOISE_PIPELINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NOISE_TYPE_PIPELINE, NoisePipelineClass))

typedef struct _NoisePipeline NoisePipeline;
typedef struct _NoisePipelineClass NoisePipelineClass;
typedef struct _NoisePipelinePrivate NoisePipelinePrivate;

#define NOISE_TYPE_EQUALIZER (noise_equalizer_get_type ())
#define NOISE_EQUALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOISE_TYPE_EQUALIZER, NoiseEqualizer))
#define NOISE_EQUALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NOISE_TYPE_EQUALIZER, NoiseEqualizerClass))
#define NOISE_IS_EQUALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOISE_TYPE_EQUALIZER))
#define NOISE_IS_EQUALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NOISE_TYPE_EQUALIZER))
#define NOISE_EQUALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NOISE_TYPE_EQUALIZER, NoiseEqualizerClass))

typedef struct _NoiseEqualizer NoiseEqualizer;
typedef struct _NoiseEqualizerClass NoiseEqualizerClass;
typedef struct _NoiseEqualizerPrivate NoiseEqualizerPrivate;

#define NOISE_SETTINGS_WINDOW_TYPE_NOTEBOOK_PAGE (noise_settings_window_notebook_page_get_type ())
#define NOISE_SETTINGS_WINDOW_NOTEBOOK_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOISE_SETTINGS_WINDOW_TYPE_NOTEBOOK_PAGE, NoiseSettingsWindowNoteBook_Page))
#define NOISE_SETTINGS_WINDOW_NOTEBOOK_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NOISE_SETTINGS_WINDOW_TYPE_NOTEBOOK_PAGE, NoiseSettingsWindowNoteBook_PageClass))
#define NOISE_SETTINGS_WINDOW_IS_NOTEBOOK_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOISE_SETTINGS_WINDOW_TYPE_NOTEBOOK_PAGE))
#define NOISE_SETTINGS_WINDOW_IS_NOTEBOOK_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NOISE_SETTINGS_WINDOW_TYPE_NOTEBOOK_PAGE))
#define NOISE_SETTINGS_WINDOW_NOTEBOOK_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NOISE_SETTINGS_WINDOW_TYPE_NOTEBOOK_PAGE, NoiseSettingsWindowNoteBook_PageClass))

typedef struct _NoiseSettingsWindowNoteBook_Page NoiseSettingsWindowNoteBook_Page;
typedef struct _NoiseSettingsWindowNoteBook_PageClass NoiseSettingsWindowNoteBook_PageClass;
typedef struct _NoiseSettingsWindowNoteBook_PagePrivate NoiseSettingsWindowNoteBook_PagePrivate;

struct _NoisePluginsInterface {
	GObject parent_instance;
	NoisePluginsInterfacePrivate * priv;
};

struct _NoisePluginsInterfaceClass {
	GObjectClass parent_class;
};

typedef enum  {
	NOISE_PLUGINS_INTERFACE_HOOK_CONTEXT,
	NOISE_PLUGINS_INTERFACE_HOOK_SIDEBAR,
	NOISE_PLUGINS_INTERFACE_HOOK_MAIN_MENU,
	NOISE_PLUGINS_INTERFACE_HOOK_ADDONS_MENU,
	NOISE_PLUGINS_INTERFACE_HOOK_BOTTOMBAR,
	NOISE_PLUGINS_INTERFACE_HOOK_TOOLBAR,
	NOISE_PLUGINS_INTERFACE_HOOK_SOURCE_VIEW,
	NOISE_PLUGINS_INTERFACE_HOOK_SETTINGS_WINDOW,
	NOISE_PLUGINS_INTERFACE_HOOK_WINDOW
} NoisePluginsInterfaceHook;

typedef void (*NoisePluginsInterfaceHookFunctionArg) (GObject* object, void* user_data);
typedef void (*NoisePluginsInterfaceHookFunction) (void* user_data);
struct _NoisePluginsManager {
	GObject parent_instance;
	NoisePluginsManagerPrivate * priv;
};

struct _NoisePluginsManagerClass {
	GObjectClass parent_class;
};

struct _NoiseSettingsSavedState {
	GraniteServicesSettings parent_instance;
	NoiseSettingsSavedStatePrivate * priv;
};

struct _NoiseSettingsSavedStateClass {
	GraniteServicesSettingsClass parent_class;
};

typedef enum  {
	NOISE_SETTINGS_WINDOW_STATE_NORMAL,
	NOISE_SETTINGS_WINDOW_STATE_MAXIMIZED,
	NOISE_SETTINGS_WINDOW_STATE_FULLSCREEN
} NoiseSettingsWindowState;

struct _NoiseSettingsMain {
	GraniteServicesSettings parent_instance;
	NoiseSettingsMainPrivate * priv;
};

struct _NoiseSettingsMainClass {
	GraniteServicesSettingsClass parent_class;
};

typedef enum  {
	NOISE_SETTINGS_SHUFFLE_OFF,
	NOISE_SETTINGS_SHUFFLE_ALL
} NoiseSettingsShuffle;

typedef enum  {
	NOISE_SETTINGS_REPEAT_OFF,
	NOISE_SETTINGS_REPEAT_MEDIA,
	NOISE_SETTINGS_REPEAT_ALBUM,
	NOISE_SETTINGS_REPEAT_ARTIST,
	NOISE_SETTINGS_REPEAT_ALL
} NoiseSettingsRepeat;

struct _NoiseSettingsEqualizer {
	GraniteServicesSettings parent_instance;
	NoiseSettingsEqualizerPrivate * priv;
};

struct _NoiseSettingsEqualizerClass {
	GraniteServicesSettingsClass parent_class;
};

struct _NoiseEqualizerPreset {
	GObject parent_instance;
	NoiseEqualizerPresetPrivate * priv;
	gchar* name;
	GeeArrayList* gains;
};

struct _NoiseEqualizerPresetClass {
	GObjectClass parent_class;
};

struct _NoisePlaybackIface {
	GTypeInterface parent_iface;
	GeeCollection* (*get_supported_uri) (NoisePlayback* self);
	void (*play) (NoisePlayback* self);
	void (*pause) (NoisePlayback* self);
	void (*set_state) (NoisePlayback* self, GstState s);
	void (*set_media) (NoisePlayback* self, NoiseMedia* media);
	void (*set_position) (NoisePlayback* self, gint64 pos);
	gint64 (*get_position) (NoisePlayback* self);
	gint64 (*get_duration) (NoisePlayback* self);
	void (*set_volume) (NoisePlayback* self, gdouble val);
	gdouble (*get_volume) (NoisePlayback* self);
	gboolean (*update_position) (NoisePlayback* self);
	void (*enable_equalizer) (NoisePlayback* self);
	void (*disable_equalizer) (NoisePlayback* self);
	void (*set_equalizer_gain) (NoisePlayback* self, gint index, gint val);
};

struct _NoisePlayerIface {
	GTypeInterface parent_iface;
	void (*add_playback) (NoisePlayer* self, NoisePlayback* p);
};

typedef enum  {
	NOISE_PLAYER_SHUFFLE_OFF,
	NOISE_PLAYER_SHUFFLE_ALL
} NoisePlayerShuffle;

typedef enum  {
	NOISE_PLAYER_REPEAT_OFF,
	NOISE_PLAYER_REPEAT_MEDIA,
	NOISE_PLAYER_REPEAT_ALBUM,
	NOISE_PLAYER_REPEAT_ARTIST,
	NOISE_PLAYER_REPEAT_ALL
} NoisePlayerRepeat;

struct _NoiseLibraryWindowInterfaceIface {
	GTypeInterface parent_iface;
	void (*update_sensitivities) (NoiseLibraryWindowInterface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*update_sensitivities_finish) (NoiseLibraryWindowInterface* self, GAsyncResult* _res_);
};

struct _NoiseLibrary {
	GObject parent_instance;
	NoiseLibraryPrivate * priv;
};

struct _NoiseLibraryClass {
	GObjectClass parent_class;
	void (*initialize_library) (NoiseLibrary* self);
	void (*add_files_to_library) (NoiseLibrary* self, GeeCollection* files);
	GeeCollection* (*get_medias) (NoiseLibrary* self);
	GeeCollection* (*get_playlists) (NoiseLibrary* self);
	GeeCollection* (*get_smart_playlists) (NoiseLibrary* self);
	void (*search_medias) (NoiseLibrary* self, const gchar* search);
	GeeCollection* (*get_search_result) (NoiseLibrary* self);
	void (*add_media) (NoiseLibrary* self, NoiseMedia* s);
	void (*add_medias) (NoiseLibrary* self, GeeCollection* new_media);
	NoiseMedia* (*find_media) (NoiseLibrary* self, NoiseMedia* to_find);
	NoiseMedia* (*media_from_file) (NoiseLibrary* self, GFile* file);
	NoiseMedia* (*media_from_uri) (NoiseLibrary* self, const gchar* uri);
	NoiseMedia* (*media_from_id) (NoiseLibrary* self, gint id);
	GeeCollection* (*medias_from_uris) (NoiseLibrary* self, GeeCollection* uris);
	GeeCollection* (*medias_from_ids) (NoiseLibrary* self, GeeCollection* ids);
	void (*update_media) (NoiseLibrary* self, NoiseMedia* s, gboolean updateMeta, gboolean record_time);
	void (*update_medias) (NoiseLibrary* self, GeeCollection* updates, gboolean updateMeta, gboolean record_time);
	void (*remove_media) (NoiseLibrary* self, NoiseMedia* s, gboolean trash);
	void (*remove_medias) (NoiseLibrary* self, GeeCollection* toRemove, gboolean trash);
	gboolean (*support_smart_playlists) (NoiseLibrary* self);
	void (*add_smart_playlist) (NoiseLibrary* self, NoiseSmartPlaylist* p);
	void (*remove_smart_playlist) (NoiseLibrary* self, gint id);
	NoiseSmartPlaylist* (*smart_playlist_from_id) (NoiseLibrary* self, gint id);
	NoiseSmartPlaylist* (*smart_playlist_from_name) (NoiseLibrary* self, const gchar* name);
	gboolean (*support_playlists) (NoiseLibrary* self);
	void (*add_playlist) (NoiseLibrary* self, NoiseStaticPlaylist* p);
	void (*remove_playlist) (NoiseLibrary* self, gint id);
	NoiseStaticPlaylist* (*playlist_from_id) (NoiseLibrary* self, gint id);
	NoiseStaticPlaylist* (*playlist_from_name) (NoiseLibrary* self, const gchar* name);
	gboolean (*start_file_operations) (NoiseLibrary* self, const gchar* message);
	gboolean (*doing_file_operations) (NoiseLibrary* self);
	void (*finish_file_operations) (NoiseLibrary* self);
};

struct _NoiseLibrariesManager {
	GObject parent_instance;
	NoiseLibrariesManagerPrivate * priv;
	gdouble progress;
	gchar* current_operation;
	NoiseLibrary* local_library;
};

struct _NoiseLibrariesManagerClass {
	GObjectClass parent_class;
};

struct _NoiseNotificationManager {
	GObject parent_instance;
	NoiseNotificationManagerPrivate * priv;
};

struct _NoiseNotificationManagerClass {
	GObjectClass parent_class;
};

struct _NoiseMedia {
	GObject parent_instance;
	NoiseMediaPrivate * priv;
	guint _rating;
};

struct _NoiseMediaClass {
	GObjectClass parent_class;
	gchar* (*get_uri) (NoiseMedia* self);
	void (*set_uri) (NoiseMedia* self, const gchar* value);
	guint64 (*get_file_size) (NoiseMedia* self);
	void (*set_file_size) (NoiseMedia* self, guint64 value);
	gboolean (*get_file_exists) (NoiseMedia* self);
	GFile* (*get_file) (NoiseMedia* self);
	void (*set_file) (NoiseMedia* self, GFile* value);
	gboolean (*get_isPreview) (NoiseMedia* self);
	void (*set_isPreview) (NoiseMedia* self, gboolean value);
	gboolean (*get_isTemporary) (NoiseMedia* self);
	void (*set_isTemporary) (NoiseMedia* self, gboolean value);
	gboolean (*get_location_unknown) (NoiseMedia* self);
	void (*set_location_unknown) (NoiseMedia* self, gboolean value);
	gboolean (*get_has_embedded) (NoiseMedia* self);
	void (*set_has_embedded) (NoiseMedia* self, gboolean value);
	GIcon* (*get_unique_status_image) (NoiseMedia* self);
	void (*set_unique_status_image) (NoiseMedia* self, GIcon* value);
	gboolean (*get_showIndicator) (NoiseMedia* self);
	void (*set_showIndicator) (NoiseMedia* self, gboolean value);
	const gchar* (*get_title) (NoiseMedia* self);
	void (*set_title) (NoiseMedia* self, const gchar* value);
	guint (*get_track) (NoiseMedia* self);
	void (*set_track) (NoiseMedia* self, guint value);
	guint (*get_track_count) (NoiseMedia* self);
	void (*set_track_count) (NoiseMedia* self, guint value);
	const gchar* (*get_composer) (NoiseMedia* self);
	void (*set_composer) (NoiseMedia* self, const gchar* value);
	const gchar* (*get_artist) (NoiseMedia* self);
	void (*set_artist) (NoiseMedia* self, const gchar* value);
	const gchar* (*get_album_artist) (NoiseMedia* self);
	void (*set_album_artist) (NoiseMedia* self, const gchar* value);
	const gchar* (*get_album) (NoiseMedia* self);
	void (*set_album) (NoiseMedia* self, const gchar* value);
	guint (*get_album_number) (NoiseMedia* self);
	void (*set_album_number) (NoiseMedia* self, guint value);
	guint (*get_album_count) (NoiseMedia* self);
	void (*set_album_count) (NoiseMedia* self, guint value);
	NoiseAlbum* (*get_album_info) (NoiseMedia* self);
	void (*set_album_info) (NoiseMedia* self, NoiseAlbum* value);
	const gchar* (*get_grouping) (NoiseMedia* self);
	void (*set_grouping) (NoiseMedia* self, const gchar* value);
	const gchar* (*get_genre) (NoiseMedia* self);
	void (*set_genre) (NoiseMedia* self, const gchar* value);
	const gchar* (*get_comment) (NoiseMedia* self);
	void (*set_comment) (NoiseMedia* self, const gchar* value);
	const gchar* (*get_lyrics) (NoiseMedia* self);
	void (*set_lyrics) (NoiseMedia* self, const gchar* value);
	guint (*get_year) (NoiseMedia* self);
	void (*set_year) (NoiseMedia* self, guint value);
	guint (*get_bitrate) (NoiseMedia* self);
	void (*set_bitrate) (NoiseMedia* self, guint value);
	guint (*get_bpm) (NoiseMedia* self);
	void (*set_bpm) (NoiseMedia* self, guint value);
	guint (*get_samplerate) (NoiseMedia* self);
	void (*set_samplerate) (NoiseMedia* self, guint value);
	guint (*get_length) (NoiseMedia* self);
	void (*set_length) (NoiseMedia* self, guint value);
	guint (*get_rating) (NoiseMedia* self);
	void (*set_rating) (NoiseMedia* self, guint value);
	guint (*get_play_count) (NoiseMedia* self);
	void (*set_play_count) (NoiseMedia* self, guint value);
	guint (*get_skip_count) (NoiseMedia* self);
	void (*set_skip_count) (NoiseMedia* self, guint value);
	guint (*get_date_added) (NoiseMedia* self);
	void (*set_date_added) (NoiseMedia* self, guint value);
	guint (*get_last_played) (NoiseMedia* self);
	void (*set_last_played) (NoiseMedia* self, guint value);
	guint (*get_last_modified) (NoiseMedia* self);
	void (*set_last_modified) (NoiseMedia* self, guint value);
	gint (*get_resume_pos) (NoiseMedia* self);
	void (*set_resume_pos) (NoiseMedia* self, gint value);
};

struct _NoiseAlbum {
	GObject parent_instance;
	NoiseAlbumPrivate * priv;
};

struct _NoiseAlbumClass {
	GObjectClass parent_class;
};

struct _NoiseDeviceIface {
	GTypeInterface parent_iface;
	NoiseDevicePreferences* (*get_preferences) (NoiseDevice* self);
	gboolean (*start_initialization) (NoiseDevice* self);
	void (*finish_initialization) (NoiseDevice* self);
	gchar* (*getContentType) (NoiseDevice* self);
	gchar* (*getDisplayName) (NoiseDevice* self);
	gchar* (*getEmptyDeviceTitle) (NoiseDevice* self);
	gchar* (*getEmptyDeviceDescription) (NoiseDevice* self);
	void (*setDisplayName) (NoiseDevice* self, const gchar* name);
	gchar* (*get_fancy_description) (NoiseDevice* self);
	void (*set_mount) (NoiseDevice* self, GMount* mount);
	GMount* (*get_mount) (NoiseDevice* self);
	gchar* (*get_uri) (NoiseDevice* self);
	void (*set_icon) (NoiseDevice* self, GIcon* icon);
	GIcon* (*get_icon) (NoiseDevice* self);
	guint64 (*get_capacity) (NoiseDevice* self);
	gchar* (*get_fancy_capacity) (NoiseDevice* self);
	guint64 (*get_used_space) (NoiseDevice* self);
	guint64 (*get_free_space) (NoiseDevice* self);
	void (*unmount) (NoiseDevice* self);
	void (*eject) (NoiseDevice* self);
	void (*synchronize) (NoiseDevice* self);
	gboolean (*only_use_custom_view) (NoiseDevice* self);
	GtkWidget* (*get_custom_view) (NoiseDevice* self);
	gboolean (*read_only) (NoiseDevice* self);
	NoiseLibrary* (*get_library) (NoiseDevice* self);
};

struct _NoiseNetworkDeviceIface {
	GTypeInterface parent_iface;
	gboolean (*start_initialization) (NoiseNetworkDevice* self);
	void (*finish_initialization) (NoiseNetworkDevice* self);
	gchar* (*getContentType) (NoiseNetworkDevice* self);
	gchar* (*getDisplayName) (NoiseNetworkDevice* self);
	void (*setDisplayName) (NoiseNetworkDevice* self, const gchar* name);
	gchar* (*get_fancy_description) (NoiseNetworkDevice* self);
	gchar* (*get_path) (NoiseNetworkDevice* self);
	void (*set_icon) (NoiseNetworkDevice* self, GdkPixbuf* icon);
	GdkPixbuf* (*get_icon) (NoiseNetworkDevice* self);
	void (*unmount) (NoiseNetworkDevice* self);
	void (*get_device_type) (NoiseNetworkDevice* self);
	gboolean (*supports_podcasts) (NoiseNetworkDevice* self);
	gboolean (*supports_audiobooks) (NoiseNetworkDevice* self);
	GeeCollection* (*get_medias) (NoiseNetworkDevice* self);
	GeeCollection* (*get_songs) (NoiseNetworkDevice* self);
	GeeCollection* (*get_podcasts) (NoiseNetworkDevice* self);
	GeeCollection* (*get_audiobooks) (NoiseNetworkDevice* self);
	GeeCollection* (*get_playlists) (NoiseNetworkDevice* self);
	GeeCollection* (*get_smart_playlists) (NoiseNetworkDevice* self);
};

struct _NoiseDeviceManager {
	GObject parent_instance;
	NoiseDeviceManagerPrivate * priv;
};

struct _NoiseDeviceManagerClass {
	GObjectClass parent_class;
	void (*mount_changed) (NoiseDeviceManager* self, GMount* mount);
	void (*mount_pre_unmount) (NoiseDeviceManager* self, GMount* mount);
};

struct _NoiseDevicePreferences {
	GObject parent_instance;
	NoiseDevicePreferencesPrivate * priv;
};

struct _NoiseDevicePreferencesClass {
	GObjectClass parent_class;
};

struct _NoisePlaylist {
	GObject parent_instance;
	NoisePlaylistPrivate * priv;
	GIcon* icon;
};

struct _NoisePlaylistClass {
	GObjectClass parent_class;
	void (*add_media) (NoisePlaylist* self, NoiseMedia* to_remove);
	void (*add_medias) (NoisePlaylist* self, GeeCollection* to_add);
	void (*remove_media) (NoisePlaylist* self, NoiseMedia* to_remove);
	void (*remove_medias) (NoisePlaylist* self, GeeCollection* to_remove);
	void (*clear) (NoisePlaylist* self);
	GeeArrayQueue* (*get_medias) (NoisePlaylist* self);
	void (*set_medias) (NoisePlaylist* self, GeeArrayQueue* value);
};

struct _NoiseStaticPlaylist {
	NoisePlaylist parent_instance;
	NoiseStaticPlaylistPrivate * priv;
};

struct _NoiseStaticPlaylistClass {
	NoisePlaylistClass parent_class;
};

struct _NoiseSmartPlaylist {
	NoisePlaylist parent_instance;
	NoiseSmartPlaylistPrivate * priv;
	GeeTreeSet* queries;
};

struct _NoiseSmartPlaylistClass {
	NoisePlaylistClass parent_class;
	void (*analyse_all) (NoiseSmartPlaylist* self);
	void (*clear_queries) (NoiseSmartPlaylist* self);
	GeeCollection* (*get_queries) (NoiseSmartPlaylist* self);
	void (*add_query) (NoiseSmartPlaylist* self, NoiseSmartQuery* s);
	void (*add_queries) (NoiseSmartPlaylist* self, GeeCollection* queries);
};

typedef enum  {
	NOISE_SMART_PLAYLIST_CONDITIONAL_TYPE_ALL = TRUE,
	NOISE_SMART_PLAYLIST_CONDITIONAL_TYPE_ANY = FALSE
} NoiseSmartPlaylistConditionalType;

struct _NoiseSmartQuery {
	GObject parent_instance;
	NoiseSmartQueryPrivate * priv;
};

struct _NoiseSmartQueryClass {
	GObjectClass parent_class;
};

typedef enum  {
	NOISE_SMART_QUERY_COMPARATOR_TYPE_IS,
	NOISE_SMART_QUERY_COMPARATOR_TYPE_IS_NOT,
	NOISE_SMART_QUERY_COMPARATOR_TYPE_CONTAINS,
	NOISE_SMART_QUERY_COMPARATOR_TYPE_NOT_CONTAINS,
	NOISE_SMART_QUERY_COMPARATOR_TYPE_IS_EXACTLY,
	NOISE_SMART_QUERY_COMPARATOR_TYPE_IS_AT_MOST,
	NOISE_SMART_QUERY_COMPARATOR_TYPE_IS_AT_LEAST,
	NOISE_SMART_QUERY_COMPARATOR_TYPE_IS_WITHIN,
	NOISE_SMART_QUERY_COMPARATOR_TYPE_IS_BEFORE
} NoiseSmartQueryComparatorType;

typedef enum  {
	NOISE_SMART_QUERY_FIELD_TYPE_ALBUM,
	NOISE_SMART_QUERY_FIELD_TYPE_ARTIST,
	NOISE_SMART_QUERY_FIELD_TYPE_BITRATE,
	NOISE_SMART_QUERY_FIELD_TYPE_COMMENT,
	NOISE_SMART_QUERY_FIELD_TYPE_COMPOSER,
	NOISE_SMART_QUERY_FIELD_TYPE_DATE_ADDED,
	NOISE_SMART_QUERY_FIELD_TYPE_DATE_RELEASED,
	NOISE_SMART_QUERY_FIELD_TYPE_GENRE,
	NOISE_SMART_QUERY_FIELD_TYPE_GROUPING,
	NOISE_SMART_QUERY_FIELD_TYPE_LAST_PLAYED,
	NOISE_SMART_QUERY_FIELD_TYPE_LENGTH,
	NOISE_SMART_QUERY_FIELD_TYPE_PLAYCOUNT,
	NOISE_SMART_QUERY_FIELD_TYPE_RATING,
	NOISE_SMART_QUERY_FIELD_TYPE_SKIPCOUNT,
	NOISE_SMART_QUERY_FIELD_TYPE_TITLE,
	NOISE_SMART_QUERY_FIELD_TYPE_YEAR
} NoiseSmartQueryFieldType;

struct _NoiseCompareFuncHolder {
	GTypeInstance parent_instance;
	volatile int ref_count;
	NoiseCompareFuncHolderPrivate * priv;
	GtkTreeIterCompareFunc sort_func;
	gpointer sort_func_target;
};

struct _NoiseCompareFuncHolderClass {
	GTypeClass parent_class;
	void (*finalize) (NoiseCompareFuncHolder *self);
};

struct _NoiseIcon {
	GObject parent_instance;
	NoiseIconPrivate * priv;
};

struct _NoiseIconClass {
	GObjectClass parent_class;
};

struct _NoiseIcons {
	GTypeInstance parent_instance;
	volatile int ref_count;
	NoiseIconsPrivate * priv;
};

struct _NoiseIconsClass {
	GTypeClass parent_class;
	void (*finalize) (NoiseIcons *self);
};

typedef GdkPixbuf* (*NoisePixbufCacheFilterFunction) (const gchar* key, GdkPixbuf* orig_pixbuf, void* user_data);
struct _NoisePixbufCache {
	GTypeInstance parent_instance;
	volatile int ref_count;
	NoisePixbufCachePrivate * priv;
	NoisePixbufCacheFilterFunction filter_func;
	gpointer filter_func_target;
};

struct _NoisePixbufCacheClass {
	GTypeClass parent_class;
	void (*finalize) (NoisePixbufCache *self);
};

struct _NoisePipeline {
	GObject parent_instance;
	NoisePipelinePrivate * priv;
	GstPipeline* pipe;
	NoiseEqualizer* eq;
	GstBus* bus;
	GstPad* pad;
	GstElement* audiosink;
	GstElement* audiosinkqueue;
	GstElement* eq_audioconvert;
	GstElement* eq_audioconvert2;
	GstElement* playbin;
	GstElement* audiotee;
	GstElement* audiobin;
	GstElement* preamp;
};

struct _NoisePipelineClass {
	GObjectClass parent_class;
};

struct _NoiseEqualizer {
	GObject parent_instance;
	NoiseEqualizerPrivate * priv;
	GstElement* element;
};

struct _NoiseEqualizerClass {
	GObjectClass parent_class;
};

struct _NoiseSettingsWindowNoteBook_Page {
	GtkGrid parent_instance;
	NoiseSettingsWindowNoteBook_PagePrivate * priv;
};

struct _NoiseSettingsWindowNoteBook_PageClass {
	GtkGridClass parent_class;
};


#define BUILD_DATADIR "/usr/share"
#define BUILD_PKG_DATADIR "/usr/share/noise"
#define BUILD_PLUGIN_DIR "/usr/lib/noise/plugins"
#define BUILD_GETTEXT_PACKAGE "noise"
#define BUILD_RELEASE_NAME "Luna"
#define BUILD_VERSION "0.3.1"
#define BUILD_VERSION_INFO "Stable Release"
#define BUILD_CMAKE_INSTALL_PREFIX "/usr"
#define BUILD_ICON_DIR "/usr/share/noise/icons"
GType noise_plugins_interface_get_type (void) G_GNUC_CONST;
GType noise_plugins_interface_hook_get_type (void) G_GNUC_CONST;
GType noise_plugins_manager_get_type (void) G_GNUC_CONST;
NoisePluginsInterface* noise_plugins_interface_new (NoisePluginsManager* manager);
NoisePluginsInterface* noise_plugins_interface_construct (GType object_type, NoisePluginsManager* manager);
void noise_plugins_interface_register_function_arg (NoisePluginsInterface* self, NoisePluginsInterfaceHook hook, NoisePluginsInterfaceHookFunctionArg hook_function, void* hook_function_target);
void noise_plugins_interface_register_function_signal (NoisePluginsInterface* self, NoisePluginsInterfaceHook hook, const gchar* signal_name, GObject* obj);
void noise_plugins_interface_register_function (NoisePluginsInterface* self, NoisePluginsInterfaceHook hook, NoisePluginsInterfaceHookFunction hook_function, void* hook_function_target);
GtkNotebook* noise_plugins_interface_get_context (NoisePluginsInterface* self);
GtkNotebook* noise_plugins_interface_get_sidebar (NoisePluginsInterface* self);
GtkNotebook* noise_plugins_interface_get_bottombar (NoisePluginsInterface* self);
GtkApplication* noise_plugins_interface_get_noise_app (NoisePluginsInterface* self);
GtkMenu* noise_plugins_interface_get_main_menu (NoisePluginsInterface* self);
GtkMenu* noise_plugins_interface_get_addons_menu (NoisePluginsInterface* self);
GtkToolbar* noise_plugins_interface_get_toolbar (NoisePluginsInterface* self);
GtkWindow* noise_plugins_interface_get_window (NoisePluginsInterface* self);
const gchar* noise_plugins_interface_get_set_name (NoisePluginsInterface* self);
const gchar* noise_plugins_interface_get_argument (NoisePluginsInterface* self);
GList* noise_plugins_interface_get_all_source_view (NoisePluginsInterface* self);
NoisePluginsManager* noise_plugins_manager_get_default (void);
GtkWidget* noise_plugins_manager_get_view (NoisePluginsManager* self);
void noise_plugins_manager_hook_app (NoisePluginsManager* self, GtkApplication* app);
void noise_plugins_manager_hook_example (NoisePluginsManager* self, const gchar* arg);
void noise_plugins_manager_set_toolbar (NoisePluginsManager* self, GtkToolbar* value);
void noise_plugins_manager_set_noise_app (NoisePluginsManager* self, GtkApplication* value);
NoisePluginsInterface* noise_plugins_manager_get_plugin_iface (NoisePluginsManager* self);
void noise_plugins_manager_set_context (NoisePluginsManager* self, GtkNotebook* value);
void noise_plugins_manager_set_sidebar (NoisePluginsManager* self, GtkNotebook* value);
GType noise_settings_saved_state_get_type (void) G_GNUC_CONST;
NoiseSettingsSavedState* noise_settings_saved_state_get_default (void);
gint noise_settings_saved_state_get_window_width (NoiseSettingsSavedState* self);
void noise_settings_saved_state_set_window_width (NoiseSettingsSavedState* self, gint value);
gint noise_settings_saved_state_get_window_height (NoiseSettingsSavedState* self);
void noise_settings_saved_state_set_window_height (NoiseSettingsSavedState* self, gint value);
GType noise_settings_window_state_get_type (void) G_GNUC_CONST;
NoiseSettingsWindowState noise_settings_saved_state_get_window_state (NoiseSettingsSavedState* self);
void noise_settings_saved_state_set_window_state (NoiseSettingsSavedState* self, NoiseSettingsWindowState value);
gint noise_settings_saved_state_get_sidebar_width (NoiseSettingsSavedState* self);
void noise_settings_saved_state_set_sidebar_width (NoiseSettingsSavedState* self, gint value);
gint noise_settings_saved_state_get_more_width (NoiseSettingsSavedState* self);
void noise_settings_saved_state_set_more_width (NoiseSettingsSavedState* self, gint value);
gboolean noise_settings_saved_state_get_more_visible (NoiseSettingsSavedState* self);
void noise_settings_saved_state_set_more_visible (NoiseSettingsSavedState* self, gboolean value);
gint noise_settings_saved_state_get_view_mode (NoiseSettingsSavedState* self);
void noise_settings_saved_state_set_view_mode (NoiseSettingsSavedState* self, gint value);
gint noise_settings_saved_state_get_column_browser_width (NoiseSettingsSavedState* self);
void noise_settings_saved_state_set_column_browser_width (NoiseSettingsSavedState* self, gint value);
gint noise_settings_saved_state_get_column_browser_height (NoiseSettingsSavedState* self);
void noise_settings_saved_state_set_column_browser_height (NoiseSettingsSavedState* self, gint value);
gboolean noise_settings_saved_state_get_column_browser_enabled (NoiseSettingsSavedState* self);
void noise_settings_saved_state_set_column_browser_enabled (NoiseSettingsSavedState* self, gboolean value);
gboolean noise_settings_saved_state_get_show_album_art_in_list_view (NoiseSettingsSavedState* self);
void noise_settings_saved_state_set_show_album_art_in_list_view (NoiseSettingsSavedState* self, gboolean value);
gchar** noise_settings_saved_state_get_column_browser_visible_columns (NoiseSettingsSavedState* self, int* result_length1);
void noise_settings_saved_state_set_column_browser_visible_columns (NoiseSettingsSavedState* self, gchar** value, int value_length1);
gint noise_settings_saved_state_get_column_browser_position (NoiseSettingsSavedState* self);
void noise_settings_saved_state_set_column_browser_position (NoiseSettingsSavedState* self, gint value);
GType noise_settings_main_get_type (void) G_GNUC_CONST;
NoiseSettingsMain* noise_settings_main_get_default (void);
const gchar* noise_settings_main_get_music_mount_name (NoiseSettingsMain* self);
void noise_settings_main_set_music_mount_name (NoiseSettingsMain* self, const gchar* value);
const gchar* noise_settings_main_get_music_folder (NoiseSettingsMain* self);
void noise_settings_main_set_music_folder (NoiseSettingsMain* self, const gchar* value);
gboolean noise_settings_main_get_update_folder_hierarchy (NoiseSettingsMain* self);
void noise_settings_main_set_update_folder_hierarchy (NoiseSettingsMain* self, gboolean value);
gboolean noise_settings_main_get_write_metadata_to_file (NoiseSettingsMain* self);
void noise_settings_main_set_write_metadata_to_file (NoiseSettingsMain* self, gboolean value);
gboolean noise_settings_main_get_copy_imported_music (NoiseSettingsMain* self);
void noise_settings_main_set_copy_imported_music (NoiseSettingsMain* self, gboolean value);
gboolean noise_settings_main_get_close_while_playing (NoiseSettingsMain* self);
void noise_settings_main_set_close_while_playing (NoiseSettingsMain* self, gboolean value);
gint noise_settings_main_get_last_media_playing (NoiseSettingsMain* self);
void noise_settings_main_set_last_media_playing (NoiseSettingsMain* self, gint value);
gint noise_settings_main_get_last_playlist_playing (NoiseSettingsMain* self);
void noise_settings_main_set_last_playlist_playing (NoiseSettingsMain* self, gint value);
gint noise_settings_main_get_last_media_position (NoiseSettingsMain* self);
void noise_settings_main_set_last_media_position (NoiseSettingsMain* self, gint value);
GType noise_settings_shuffle_get_type (void) G_GNUC_CONST;
NoiseSettingsShuffle noise_settings_main_get_shuffle_mode (NoiseSettingsMain* self);
void noise_settings_main_set_shuffle_mode (NoiseSettingsMain* self, NoiseSettingsShuffle value);
GType noise_settings_repeat_get_type (void) G_GNUC_CONST;
NoiseSettingsRepeat noise_settings_main_get_repeat_mode (NoiseSettingsMain* self);
void noise_settings_main_set_repeat_mode (NoiseSettingsMain* self, NoiseSettingsRepeat value);
const gchar* noise_settings_main_get_search_string (NoiseSettingsMain* self);
void noise_settings_main_set_search_string (NoiseSettingsMain* self, const gchar* value);
const gchar* noise_settings_main_get_path_string (NoiseSettingsMain* self);
void noise_settings_main_set_path_string (NoiseSettingsMain* self, const gchar* value);
gchar** noise_settings_main_get_plugins_disabled (NoiseSettingsMain* self, int* result_length1);
void noise_settings_main_set_plugins_disabled (NoiseSettingsMain* self, gchar** value, int value_length1);
gchar** noise_settings_main_get_minimize_while_playing_shells (NoiseSettingsMain* self, int* result_length1);
void noise_settings_main_set_minimize_while_playing_shells (NoiseSettingsMain* self, gchar** value, int value_length1);
GType noise_settings_equalizer_get_type (void) G_GNUC_CONST;
NoiseSettingsEqualizer* noise_settings_equalizer_get_default (void);
GType noise_equalizer_preset_get_type (void) G_GNUC_CONST;
GeeCollection* noise_settings_equalizer_getPresets (NoiseSettingsEqualizer* self);
gboolean noise_settings_equalizer_get_equalizer_enabled (NoiseSettingsEqualizer* self);
void noise_settings_equalizer_set_equalizer_enabled (NoiseSettingsEqualizer* self, gboolean value);
gboolean noise_settings_equalizer_get_auto_switch_preset (NoiseSettingsEqualizer* self);
void noise_settings_equalizer_set_auto_switch_preset (NoiseSettingsEqualizer* self, gboolean value);
const gchar* noise_settings_equalizer_get_selected_preset (NoiseSettingsEqualizer* self);
void noise_settings_equalizer_set_selected_preset (NoiseSettingsEqualizer* self, const gchar* value);
gchar** noise_settings_equalizer_get_custom_presets (NoiseSettingsEqualizer* self, int* result_length1);
void noise_settings_equalizer_set_custom_presets (NoiseSettingsEqualizer* self, gchar** value, int value_length1);
NoiseEqualizerPreset* noise_equalizer_preset_new_basic (const gchar* name);
NoiseEqualizerPreset* noise_equalizer_preset_construct_basic (GType object_type, const gchar* name);
NoiseEqualizerPreset* noise_equalizer_preset_new_with_gains (const gchar* name, gint* items, int items_length1);
NoiseEqualizerPreset* noise_equalizer_preset_construct_with_gains (GType object_type, const gchar* name, gint* items, int items_length1);
NoiseEqualizerPreset* noise_equalizer_preset_new_from_string (const gchar* data);
NoiseEqualizerPreset* noise_equalizer_preset_construct_from_string (GType object_type, const gchar* data);
gchar* noise_equalizer_preset_to_string (NoiseEqualizerPreset* self);
void noise_equalizer_preset_setGain (NoiseEqualizerPreset* self, gint index, gint val);
gint noise_equalizer_preset_getGain (NoiseEqualizerPreset* self, gint index);
NoiseEqualizerPreset* noise_equalizer_preset_new (void);
NoiseEqualizerPreset* noise_equalizer_preset_construct (GType object_type);
gboolean noise_equalizer_preset_get_is_default (NoiseEqualizerPreset* self);
void noise_equalizer_preset_set_is_default (NoiseEqualizerPreset* self, gboolean value);
GType noise_media_get_type (void) G_GNUC_CONST;
GType noise_playback_get_type (void) G_GNUC_CONST;
GType noise_player_get_type (void) G_GNUC_CONST;
GType noise_player_shuffle_get_type (void) G_GNUC_CONST;
GType noise_player_repeat_get_type (void) G_GNUC_CONST;
void noise_player_add_playback (NoisePlayer* self, NoisePlayback* p);
GType noise_library_window_interface_get_type (void) G_GNUC_CONST;
void noise_library_window_interface_update_sensitivities (NoiseLibraryWindowInterface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void noise_library_window_interface_update_sensitivities_finish (NoiseLibraryWindowInterface* self, GAsyncResult* _res_);
GType noise_library_get_type (void) G_GNUC_CONST;
GType noise_playlist_get_type (void) G_GNUC_CONST;
GType noise_static_playlist_get_type (void) G_GNUC_CONST;
GType noise_smart_playlist_get_type (void) G_GNUC_CONST;
void noise_library_initialize_library (NoiseLibrary* self);
void noise_library_add_files_to_library (NoiseLibrary* self, GeeCollection* files);
GeeCollection* noise_library_get_medias (NoiseLibrary* self);
GeeCollection* noise_library_get_playlists (NoiseLibrary* self);
GeeCollection* noise_library_get_smart_playlists (NoiseLibrary* self);
void noise_library_search_medias (NoiseLibrary* self, const gchar* search);
GeeCollection* noise_library_get_search_result (NoiseLibrary* self);
void noise_library_add_media (NoiseLibrary* self, NoiseMedia* s);
void noise_library_add_medias (NoiseLibrary* self, GeeCollection* new_media);
NoiseMedia* noise_library_find_media (NoiseLibrary* self, NoiseMedia* to_find);
NoiseMedia* noise_library_media_from_file (NoiseLibrary* self, GFile* file);
NoiseMedia* noise_library_media_from_uri (NoiseLibrary* self, const gchar* uri);
NoiseMedia* noise_library_media_from_id (NoiseLibrary* self, gint id);
GeeCollection* noise_library_medias_from_uris (NoiseLibrary* self, GeeCollection* uris);
GeeCollection* noise_library_medias_from_ids (NoiseLibrary* self, GeeCollection* ids);
void noise_library_update_media (NoiseLibrary* self, NoiseMedia* s, gboolean updateMeta, gboolean record_time);
void noise_library_update_medias (NoiseLibrary* self, GeeCollection* updates, gboolean updateMeta, gboolean record_time);
void noise_library_remove_media (NoiseLibrary* self, NoiseMedia* s, gboolean trash);
void noise_library_remove_medias (NoiseLibrary* self, GeeCollection* toRemove, gboolean trash);
gboolean noise_library_support_smart_playlists (NoiseLibrary* self);
void noise_library_add_smart_playlist (NoiseLibrary* self, NoiseSmartPlaylist* p);
void noise_library_remove_smart_playlist (NoiseLibrary* self, gint id);
NoiseSmartPlaylist* noise_library_smart_playlist_from_id (NoiseLibrary* self, gint id);
NoiseSmartPlaylist* noise_library_smart_playlist_from_name (NoiseLibrary* self, const gchar* name);
gboolean noise_library_support_playlists (NoiseLibrary* self);
void noise_library_add_playlist (NoiseLibrary* self, NoiseStaticPlaylist* p);
void noise_library_remove_playlist (NoiseLibrary* self, gint id);
NoiseStaticPlaylist* noise_library_playlist_from_id (NoiseLibrary* self, gint id);
NoiseStaticPlaylist* noise_library_playlist_from_name (NoiseLibrary* self, const gchar* name);
gboolean noise_library_start_file_operations (NoiseLibrary* self, const gchar* message);
gboolean noise_library_doing_file_operations (NoiseLibrary* self);
void noise_library_finish_file_operations (NoiseLibrary* self);
gint noise_library_playlist_count_without_read_only (NoiseLibrary* self);
void noise_library_media_from_name (NoiseLibrary* self, GeeCollection* tests, GeeCollection* found, GeeCollection* not_found);
NoiseLibrary* noise_library_construct (GType object_type);
GType noise_libraries_manager_get_type (void) G_GNUC_CONST;
NoiseLibrariesManager* noise_libraries_manager_new (void);
NoiseLibrariesManager* noise_libraries_manager_construct (GType object_type);
void noise_libraries_manager_add_library (NoiseLibrariesManager* self, NoiseLibrary* library);
void noise_libraries_manager_remove_library (NoiseLibrariesManager* self, NoiseLibrary* library);
NoiseLibrary* noise_libraries_manager_get_library_from_index (NoiseLibrariesManager* self, gint index);
void noise_libraries_manager_search_for_string (NoiseLibrariesManager* self, const gchar* search);
void noise_libraries_manager_transfer_to_local_library (NoiseLibrariesManager* self, GeeCollection* to_transfer);
void noise_libraries_manager_transfer_medias_async (NoiseLibrariesManager* self, GeeCollection* list, GAsyncReadyCallback _callback_, gpointer _user_data_);
void noise_libraries_manager_transfer_medias_finish (NoiseLibrariesManager* self, GAsyncResult* _res_);
gboolean noise_libraries_manager_do_progress_notification_with_timeout (NoiseLibrariesManager* self);
GType noise_notification_manager_get_type (void) G_GNUC_CONST;
NoiseNotificationManager* noise_notification_manager_get_default (void);
GType noise_album_get_type (void) G_GNUC_CONST;
extern gchar* noise_media_UNKNOWN;
gchar* noise_media_get_display_filename (NoiseMedia* self);
gchar* noise_media_get_display_location (NoiseMedia* self);
gchar* noise_media_get_display_title (NoiseMedia* self);
gchar* noise_media_get_display_composer (NoiseMedia* self);
gchar* noise_media_get_display_artist (NoiseMedia* self);
gchar* noise_media_get_display_album_artist (NoiseMedia* self, gboolean use_artist_fallback);
gchar* noise_media_get_display_album (NoiseMedia* self);
gchar* noise_media_get_display_genre (NoiseMedia* self);
gboolean noise_media_is_valid_string_field (const gchar* text);
gchar* noise_media_get_album_hashkey (NoiseMedia* self);
gchar* noise_media_get_title_markup (NoiseMedia* self);
NoiseMedia* noise_media_new (const gchar* uri);
NoiseMedia* noise_media_construct (GType object_type, const gchar* uri);
NoiseMedia* noise_media_new_from_file (GFile* file);
NoiseMedia* noise_media_construct_from_file (GType object_type, GFile* file);
NoiseMedia* noise_media_copy (NoiseMedia* self);
gint noise_media_get_rowid (NoiseMedia* self);
void noise_media_set_rowid (NoiseMedia* self, gint value);
gchar* noise_media_get_uri (NoiseMedia* self);
void noise_media_set_uri (NoiseMedia* self, const gchar* value);
guint64 noise_media_get_file_size (NoiseMedia* self);
void noise_media_set_file_size (NoiseMedia* self, guint64 value);
gboolean noise_media_get_file_exists (NoiseMedia* self);
GFile* noise_media_get_file (NoiseMedia* self);
void noise_media_set_file (NoiseMedia* self, GFile* value);
gboolean noise_media_get_isPreview (NoiseMedia* self);
void noise_media_set_isPreview (NoiseMedia* self, gboolean value);
gboolean noise_media_get_isTemporary (NoiseMedia* self);
void noise_media_set_isTemporary (NoiseMedia* self, gboolean value);
gboolean noise_media_get_location_unknown (NoiseMedia* self);
void noise_media_set_location_unknown (NoiseMedia* self, gboolean value);
gboolean noise_media_get_has_embedded (NoiseMedia* self);
void noise_media_set_has_embedded (NoiseMedia* self, gboolean value);
GIcon* noise_media_get_unique_status_image (NoiseMedia* self);
void noise_media_set_unique_status_image (NoiseMedia* self, GIcon* value);
gboolean noise_media_get_showIndicator (NoiseMedia* self);
void noise_media_set_showIndicator (NoiseMedia* self, gboolean value);
const gchar* noise_media_get_title (NoiseMedia* self);
void noise_media_set_title (NoiseMedia* self, const gchar* value);
guint noise_media_get_track (NoiseMedia* self);
void noise_media_set_track (NoiseMedia* self, guint value);
guint noise_media_get_track_count (NoiseMedia* self);
void noise_media_set_track_count (NoiseMedia* self, guint value);
const gchar* noise_media_get_composer (NoiseMedia* self);
void noise_media_set_composer (NoiseMedia* self, const gchar* value);
const gchar* noise_media_get_artist (NoiseMedia* self);
void noise_media_set_artist (NoiseMedia* self, const gchar* value);
const gchar* noise_media_get_album_artist (NoiseMedia* self);
void noise_media_set_album_artist (NoiseMedia* self, const gchar* value);
const gchar* noise_media_get_album (NoiseMedia* self);
void noise_media_set_album (NoiseMedia* self, const gchar* value);
guint noise_media_get_album_number (NoiseMedia* self);
void noise_media_set_album_number (NoiseMedia* self, guint value);
guint noise_media_get_album_count (NoiseMedia* self);
void noise_media_set_album_count (NoiseMedia* self, guint value);
NoiseAlbum* noise_media_get_album_info (NoiseMedia* self);
void noise_media_set_album_info (NoiseMedia* self, NoiseAlbum* value);
const gchar* noise_media_get_grouping (NoiseMedia* self);
void noise_media_set_grouping (NoiseMedia* self, const gchar* value);
const gchar* noise_media_get_genre (NoiseMedia* self);
void noise_media_set_genre (NoiseMedia* self, const gchar* value);
const gchar* noise_media_get_comment (NoiseMedia* self);
void noise_media_set_comment (NoiseMedia* self, const gchar* value);
const gchar* noise_media_get_lyrics (NoiseMedia* self);
void noise_media_set_lyrics (NoiseMedia* self, const gchar* value);
guint noise_media_get_year (NoiseMedia* self);
void noise_media_set_year (NoiseMedia* self, guint value);
guint noise_media_get_bitrate (NoiseMedia* self);
void noise_media_set_bitrate (NoiseMedia* self, guint value);
guint noise_media_get_bpm (NoiseMedia* self);
void noise_media_set_bpm (NoiseMedia* self, guint value);
guint noise_media_get_samplerate (NoiseMedia* self);
void noise_media_set_samplerate (NoiseMedia* self, guint value);
guint noise_media_get_length (NoiseMedia* self);
void noise_media_set_length (NoiseMedia* self, guint value);
guint noise_media_get_rating (NoiseMedia* self);
void noise_media_set_rating (NoiseMedia* self, guint value);
guint noise_media_get_play_count (NoiseMedia* self);
void noise_media_set_play_count (NoiseMedia* self, guint value);
guint noise_media_get_skip_count (NoiseMedia* self);
void noise_media_set_skip_count (NoiseMedia* self, guint value);
guint noise_media_get_date_added (NoiseMedia* self);
void noise_media_set_date_added (NoiseMedia* self, guint value);
guint noise_media_get_last_played (NoiseMedia* self);
void noise_media_set_last_played (NoiseMedia* self, guint value);
guint noise_media_get_last_modified (NoiseMedia* self);
void noise_media_set_last_modified (NoiseMedia* self, guint value);
gint noise_media_get_resume_pos (NoiseMedia* self);
void noise_media_set_resume_pos (NoiseMedia* self, gint value);
NoiseAlbum* noise_album_new_from_media (NoiseMedia* m);
NoiseAlbum* noise_album_construct_from_media (GType object_type, NoiseMedia* m);
gchar* noise_album_to_string (NoiseAlbum* self);
gchar* noise_album_get_display_name (NoiseAlbum* self);
gchar* noise_album_get_display_artist (NoiseAlbum* self);
gboolean noise_album_contains (NoiseAlbum* self, NoiseMedia* m);
gboolean noise_album_is_compatible (NoiseAlbum* self, NoiseMedia* m);
void noise_album_remove_media (NoiseAlbum* self, NoiseMedia* m);
void noise_album_add_media (NoiseAlbum* self, NoiseMedia* m);
gchar* noise_album_get_hashkey (NoiseAlbum* self);
GeeCollection* noise_album_get_media (NoiseAlbum* self, guint n_disc);
NoiseAlbum* noise_album_new (void);
NoiseAlbum* noise_album_construct (GType object_type);
const gchar* noise_album_get_name (NoiseAlbum* self);
void noise_album_set_name (NoiseAlbum* self, const gchar* value);
const gchar* noise_album_get_artist (NoiseAlbum* self);
void noise_album_set_artist (NoiseAlbum* self, const gchar* value);
guint noise_album_get_n_discs (NoiseAlbum* self);
void noise_album_set_n_discs (NoiseAlbum* self, guint value);
guint noise_album_get_year (NoiseAlbum* self);
void noise_album_set_year (NoiseAlbum* self, guint value);
guint noise_album_get_n_media (NoiseAlbum* self);
gboolean noise_album_get_is_empty (NoiseAlbum* self);
#define NOISE_MUSIC_PLAYLIST "autosaved_music"
#define NOISE_STRING_CANCEL _ ("Cancel")
#define NOISE_STRING_OPEN _ ("Open")
#define NOISE_STRING_SAVE _ ("Save")
extern NoiseLibrariesManager* noise_libraries_manager;
GType noise_device_preferences_get_type (void) G_GNUC_CONST;
GType noise_device_get_type (void) G_GNUC_CONST;
NoiseDevicePreferences* noise_device_get_preferences (NoiseDevice* self);
gboolean noise_device_start_initialization (NoiseDevice* self);
void noise_device_finish_initialization (NoiseDevice* self);
gchar* noise_device_getContentType (NoiseDevice* self);
gchar* noise_device_getDisplayName (NoiseDevice* self);
gchar* noise_device_getEmptyDeviceTitle (NoiseDevice* self);
gchar* noise_device_getEmptyDeviceDescription (NoiseDevice* self);
void noise_device_setDisplayName (NoiseDevice* self, const gchar* name);
gchar* noise_device_get_fancy_description (NoiseDevice* self);
void noise_device_set_mount (NoiseDevice* self, GMount* mount);
GMount* noise_device_get_mount (NoiseDevice* self);
gchar* noise_device_get_uri (NoiseDevice* self);
void noise_device_set_icon (NoiseDevice* self, GIcon* icon);
GIcon* noise_device_get_icon (NoiseDevice* self);
guint64 noise_device_get_capacity (NoiseDevice* self);
gchar* noise_device_get_fancy_capacity (NoiseDevice* self);
guint64 noise_device_get_used_space (NoiseDevice* self);
guint64 noise_device_get_free_space (NoiseDevice* self);
void noise_device_unmount (NoiseDevice* self);
void noise_device_eject (NoiseDevice* self);
void noise_device_synchronize (NoiseDevice* self);
gboolean noise_device_only_use_custom_view (NoiseDevice* self);
GtkWidget* noise_device_get_custom_view (NoiseDevice* self);
gboolean noise_device_read_only (NoiseDevice* self);
NoiseLibrary* noise_device_get_library (NoiseDevice* self);
GeeCollection* noise_device_delete_doubles (NoiseDevice* self, GeeCollection* source_list, GeeCollection* to_remove);
gboolean noise_device_will_fit (NoiseDevice* self, GeeCollection* list);
gboolean noise_device_will_fit_without (NoiseDevice* self, GeeCollection* list, GeeCollection* without);
gchar* noise_device_get_unique_identifier (NoiseDevice* self);
GType noise_network_device_get_type (void) G_GNUC_CONST;
gboolean noise_network_device_start_initialization (NoiseNetworkDevice* self);
void noise_network_device_finish_initialization (NoiseNetworkDevice* self);
gchar* noise_network_device_getContentType (NoiseNetworkDevice* self);
gchar* noise_network_device_getDisplayName (NoiseNetworkDevice* self);
void noise_network_device_setDisplayName (NoiseNetworkDevice* self, const gchar* name);
gchar* noise_network_device_get_fancy_description (NoiseNetworkDevice* self);
gchar* noise_network_device_get_path (NoiseNetworkDevice* self);
void noise_network_device_set_icon (NoiseNetworkDevice* self, GdkPixbuf* icon);
GdkPixbuf* noise_network_device_get_icon (NoiseNetworkDevice* self);
void noise_network_device_unmount (NoiseNetworkDevice* self);
void noise_network_device_get_device_type (NoiseNetworkDevice* self);
gboolean noise_network_device_supports_podcasts (NoiseNetworkDevice* self);
gboolean noise_network_device_supports_audiobooks (NoiseNetworkDevice* self);
GeeCollection* noise_network_device_get_medias (NoiseNetworkDevice* self);
GeeCollection* noise_network_device_get_songs (NoiseNetworkDevice* self);
GeeCollection* noise_network_device_get_podcasts (NoiseNetworkDevice* self);
GeeCollection* noise_network_device_get_audiobooks (NoiseNetworkDevice* self);
GeeCollection* noise_network_device_get_playlists (NoiseNetworkDevice* self);
GeeCollection* noise_network_device_get_smart_playlists (NoiseNetworkDevice* self);
GType noise_device_manager_get_type (void) G_GNUC_CONST;
NoiseDeviceManager* noise_device_manager_get_default (void);
void noise_device_manager_set_device_preferences (NoiseDeviceManager* self, GeeCollection* device_preferences);
void noise_device_manager_get_pre_existing_mounts (NoiseDeviceManager* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void noise_device_manager_get_pre_existing_mounts_finish (NoiseDeviceManager* self, GAsyncResult* _res_);
void noise_device_manager_device_initialized (NoiseDeviceManager* self, NoiseDevice* d);
void noise_device_manager_mount_changed (NoiseDeviceManager* self, GMount* mount);
void noise_device_manager_mount_pre_unmount (NoiseDeviceManager* self, GMount* mount);
NoiseDevicePreferences* noise_device_manager_get_device_preferences (NoiseDeviceManager* self, const gchar* id);
GeeCollection* noise_device_manager_get_initialized_devices (NoiseDeviceManager* self);
GeeCollection* noise_device_manager_get_available_mounts (NoiseDeviceManager* self);
void noise_device_manager_add_device_preferences (NoiseDeviceManager* self, NoiseDevicePreferences* dp);
NoiseDevicePreferences* noise_device_preferences_new (const gchar* id);
NoiseDevicePreferences* noise_device_preferences_construct (GType object_type, const gchar* id);
const gchar* noise_device_preferences_get_id (NoiseDevicePreferences* self);
void noise_device_preferences_set_id (NoiseDevicePreferences* self, const gchar* value);
gboolean noise_device_preferences_get_sync_when_mounted (NoiseDevicePreferences* self);
void noise_device_preferences_set_sync_when_mounted (NoiseDevicePreferences* self, gboolean value);
gint noise_device_preferences_get_last_sync_time (NoiseDevicePreferences* self);
void noise_device_preferences_set_last_sync_time (NoiseDevicePreferences* self, gint value);
gboolean noise_device_preferences_get_sync_music (NoiseDevicePreferences* self);
void noise_device_preferences_set_sync_music (NoiseDevicePreferences* self, gboolean value);
gboolean noise_device_preferences_get_sync_podcasts (NoiseDevicePreferences* self);
void noise_device_preferences_set_sync_podcasts (NoiseDevicePreferences* self, gboolean value);
gboolean noise_device_preferences_get_sync_audiobooks (NoiseDevicePreferences* self);
void noise_device_preferences_set_sync_audiobooks (NoiseDevicePreferences* self, gboolean value);
gboolean noise_device_preferences_get_sync_all_music (NoiseDevicePreferences* self);
void noise_device_preferences_set_sync_all_music (NoiseDevicePreferences* self, gboolean value);
gboolean noise_device_preferences_get_sync_all_podcasts (NoiseDevicePreferences* self);
void noise_device_preferences_set_sync_all_podcasts (NoiseDevicePreferences* self, gboolean value);
gboolean noise_device_preferences_get_sync_all_audiobooks (NoiseDevicePreferences* self);
void noise_device_preferences_set_sync_all_audiobooks (NoiseDevicePreferences* self, gboolean value);
NoisePlaylist* noise_device_preferences_get_music_playlist (NoiseDevicePreferences* self);
void noise_device_preferences_set_music_playlist (NoiseDevicePreferences* self, NoisePlaylist* value);
NoisePlaylist* noise_device_preferences_get_podcast_playlist (NoiseDevicePreferences* self);
void noise_device_preferences_set_podcast_playlist (NoiseDevicePreferences* self, NoisePlaylist* value);
NoisePlaylist* noise_device_preferences_get_audiobook_playlist (NoiseDevicePreferences* self);
void noise_device_preferences_set_audiobook_playlist (NoiseDevicePreferences* self, NoisePlaylist* value);
void noise_playlist_add_media (NoisePlaylist* self, NoiseMedia* to_remove);
void noise_playlist_add_medias (NoisePlaylist* self, GeeCollection* to_add);
void noise_playlist_remove_media (NoisePlaylist* self, NoiseMedia* to_remove);
void noise_playlist_remove_medias (NoisePlaylist* self, GeeCollection* to_remove);
void noise_playlist_clear (NoisePlaylist* self);
gboolean noise_playlist_is_empty (NoisePlaylist* self);
NoisePlaylist* noise_playlist_construct (GType object_type);
GeeArrayQueue* noise_playlist_get_medias (NoisePlaylist* self);
void noise_playlist_set_medias (NoisePlaylist* self, GeeArrayQueue* value);
gint noise_playlist_get_rowid (NoisePlaylist* self);
void noise_playlist_set_rowid (NoisePlaylist* self, gint value);
const gchar* noise_playlist_get_name (NoisePlaylist* self);
void noise_playlist_set_name (NoisePlaylist* self, const gchar* value);
NoiseStaticPlaylist* noise_static_playlist_new (void);
NoiseStaticPlaylist* noise_static_playlist_construct (GType object_type);
NoiseStaticPlaylist* noise_static_playlist_new_with_info (gint rowid, const gchar* name);
NoiseStaticPlaylist* noise_static_playlist_construct_with_info (GType object_type, gint rowid, const gchar* name);
gboolean noise_static_playlist_get_read_only (NoiseStaticPlaylist* self);
void noise_static_playlist_set_read_only (NoiseStaticPlaylist* self, gboolean value);
gboolean noise_static_playlist_get_show_badge (NoiseStaticPlaylist* self);
void noise_static_playlist_set_show_badge (NoiseStaticPlaylist* self, gboolean value);
gboolean noise_static_playlist_get_allow_duplicate (NoiseStaticPlaylist* self);
void noise_static_playlist_set_allow_duplicate (NoiseStaticPlaylist* self, gboolean value);
GType noise_smart_query_get_type (void) G_GNUC_CONST;
GType noise_smart_playlist_conditional_type_get_type (void) G_GNUC_CONST;
NoiseSmartPlaylist* noise_smart_playlist_new (NoiseLibrary* library);
NoiseSmartPlaylist* noise_smart_playlist_construct (GType object_type, NoiseLibrary* library);
void noise_smart_playlist_analyse_all (NoiseSmartPlaylist* self);
void noise_smart_playlist_clear_queries (NoiseSmartPlaylist* self);
GeeCollection* noise_smart_playlist_get_queries (NoiseSmartPlaylist* self);
void noise_smart_playlist_add_query (NoiseSmartPlaylist* self, NoiseSmartQuery* s);
void noise_smart_playlist_add_queries (NoiseSmartPlaylist* self, GeeCollection* queries);
gboolean noise_smart_playlist_media_matches_query (NoiseSmartQuery* q, NoiseMedia* s);
NoiseSmartPlaylistConditionalType noise_smart_playlist_get_conditional (NoiseSmartPlaylist* self);
void noise_smart_playlist_set_conditional (NoiseSmartPlaylist* self, NoiseSmartPlaylistConditionalType value);
gint noise_smart_playlist_get_query_count (NoiseSmartPlaylist* self);
void noise_smart_playlist_set_query_count (NoiseSmartPlaylist* self, gint value);
gboolean noise_smart_playlist_get_limit (NoiseSmartPlaylist* self);
void noise_smart_playlist_set_limit (NoiseSmartPlaylist* self, gboolean value);
gint noise_smart_playlist_get_limit_amount (NoiseSmartPlaylist* self);
void noise_smart_playlist_set_limit_amount (NoiseSmartPlaylist* self, gint value);
GType noise_smart_query_comparator_type_get_type (void) G_GNUC_CONST;
GType noise_smart_query_field_type_get_type (void) G_GNUC_CONST;
NoiseSmartQuery* noise_smart_query_new (void);
NoiseSmartQuery* noise_smart_query_construct (GType object_type);
NoiseSmartQuery* noise_smart_query_new_with_info (NoiseSmartQueryFieldType field, NoiseSmartQueryComparatorType comparator, const gchar* value);
NoiseSmartQuery* noise_smart_query_construct_with_info (GType object_type, NoiseSmartQueryFieldType field, NoiseSmartQueryComparatorType comparator, const gchar* value);
gint noise_smart_query_get_rowid (NoiseSmartQuery* self);
void noise_smart_query_set_rowid (NoiseSmartQuery* self, gint value);
NoiseSmartQueryFieldType noise_smart_query_get_field (NoiseSmartQuery* self);
void noise_smart_query_set_field (NoiseSmartQuery* self, NoiseSmartQueryFieldType value);
NoiseSmartQueryComparatorType noise_smart_query_get_comparator (NoiseSmartQuery* self);
void noise_smart_query_set_comparator (NoiseSmartQuery* self, NoiseSmartQueryComparatorType value);
const gchar* noise_smart_query_get_value (NoiseSmartQuery* self);
void noise_smart_query_set_value (NoiseSmartQuery* self, const gchar* value);
#define NOISE_FILE_UTILS_APP_NAME "noise"
GFile* noise_file_utils_get_data_directory (void);
GFile* noise_file_utils_get_cache_directory (void);
gchar* noise_file_utils_get_extension (const gchar* filename);
gboolean noise_file_utils_equal_func (GFile* a, GFile* b);
void noise_file_utils_query_exists_async (GFile* file_or_dir, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean noise_file_utils_query_exists_finish (GAsyncResult* _res_);
void noise_file_utils_query_name_async (GFile* file_or_dir, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar* noise_file_utils_query_name_finish (GAsyncResult* _res_);
void noise_file_utils_get_size_async (GFile* file_or_dir, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
guint64 noise_file_utils_get_size_finish (GAsyncResult* _res_);
guint64 noise_file_utils_get_size (GFile* file, GCancellable* cancellable);
void noise_file_utils_is_directory_async (GFile* dir, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean noise_file_utils_is_directory_finish (GAsyncResult* _res_);
void noise_file_utils_enumerate_files_async (GFile* folder, gchar** types, int types_length1, gboolean recursive, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
guint noise_file_utils_enumerate_files_finish (GAsyncResult* _res_, GeeCollection** files);
gboolean noise_file_utils_is_valid_content_type (const gchar* file_content_type, gchar** content_types, int content_types_length1);
gboolean noise_file_utils_is_valid_playlist_type (const gchar* file_content_type, gchar** content_types, int content_types_length1);
gint noise_file_utils_count_music_files (GFile* music_folder, GeeCollection* files);
gint noise_file_utils_count_playlists_files (GFile* playlist_folder, GeeLinkedList** files);
GFile* noise_file_utils_get_new_destination (NoiseMedia* s);
#define NOISE_TIME_UTILS_SECONDS_PER_MINUTE ((guint) 60)
#define NOISE_TIME_UTILS_SECONDS_PER_HOUR (60 * NOISE_TIME_UTILS_SECONDS_PER_MINUTE)
#define NOISE_TIME_UTILS_SECONDS_PER_DAY (24 * NOISE_TIME_UTILS_SECONDS_PER_HOUR)
gchar* noise_time_utils_time_string_from_seconds (guint seconds);
gchar* noise_time_utils_time_string_from_miliseconds (guint64 miliseconds);
gchar* noise_time_utils_time_string_from_nanoseconds (guint64 nanoseconds);
gchar* noise_time_utils_pretty_length (guint seconds);
gchar* noise_time_utils_pretty_length_from_ms (guint64 mseconds);
gchar* noise_time_utils_pretty_length_from_ns (guint64 nseconds);
gchar* noise_time_utils_pretty_timestamp_from_time (struct tm* dt);
gchar* noise_time_utils_pretty_timestamp_from_uint (guint time);
guint noise_time_utils_nanoseconds_to_miliseconds (guint64 nanoseconds);
guint64 noise_time_utils_miliseconds_to_nanoseconds (guint miliseconds);
gboolean noise_string_is_empty (const gchar* text, gboolean check_white_space);
gint noise_string_compare (const gchar* a, const gchar* b);
gchar* noise_string_escape (const gchar* text);
gboolean noise_string_is_white_space (const gchar* text);
gchar* noise_string_canonicalize_for_search (const gchar* str);
gchar* noise_string_to_title_case (const gchar* text);
gchar* noise_string_locale_to_utf8 (const gchar* string_locale);
void noise_string_base_search_method (const gchar* search, gint* parsed_rating, gchar** parsed_search_string);
#define NOISE_NUMERIC_NANO_INV ((guint64) 1000000000)
#define NOISE_NUMERIC_MILI_INV ((guint64) 1000)
gint noise_numeric_compare (gint64 a, gint64 b);
guint64 noise_numeric_uint_from_string (const gchar* str);
guint noise_numeric_lowest_uint_from_double (gdouble number) G_GNUC_DEPRECATED;
gint noise_numeric_lowest_int_from_float (gfloat number) G_GNUC_DEPRECATED;
guint noise_numeric_uint_from_double (gdouble number) G_GNUC_DEPRECATED;
gint noise_numeric_int_from_float (gfloat number) G_GNUC_DEPRECATED;
GtkWidget* noise_ui_wrap_alignment (GtkWidget* widget, gint top, gint right, gint bottom, gint left);
void noise_ui_make_window_draggable (GtkWindow* window);
void noise_ui_set_tree_view_column_fixed_width (GtkWidget* treeview, GtkTreeViewColumn* column, GtkCellRendererText* renderer, gchar** strings, int strings_length1, gint padding);
gpointer noise_compare_func_holder_ref (gpointer instance);
void noise_compare_func_holder_unref (gpointer instance);
GParamSpec* noise_param_spec_compare_func_holder (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void noise_value_set_compare_func_holder (GValue* value, gpointer v_object);
void noise_value_take_compare_func_holder (GValue* value, gpointer v_object);
gpointer noise_value_get_compare_func_holder (const GValue* value);
GType noise_compare_func_holder_get_type (void) G_GNUC_CONST;
NoiseCompareFuncHolder* noise_compare_func_holder_new (GtkTreeIterCompareFunc func, void* func_target);
NoiseCompareFuncHolder* noise_compare_func_holder_construct (GType object_type, GtkTreeIterCompareFunc func, void* func_target);
gint noise_compare_titles (NoiseMedia* a, NoiseMedia* b);
gint noise_compare_genres (NoiseMedia* a, NoiseMedia* b);
gint noise_compare_artists (NoiseMedia* a, NoiseMedia* b);
gint noise_compare_album_artists (NoiseMedia* a, NoiseMedia* b);
gint noise_compare_albums (NoiseMedia* a, NoiseMedia* b);
gint noise_compare_track_numbers (NoiseMedia* a, NoiseMedia* b);
gboolean noise_utils_is_cancelled (GCancellable* cancellable);
gboolean noise_utils_flags_set (gint flags, gint to_check);
gchar* noise_utils_get_desktop_shell (void);
gboolean noise_playlists_utils_save_playlist_m3u (NoisePlaylist* p, const gchar* folder_uri, const gchar* without_path);
gchar* noise_playlists_utils_get_playlist_m3u_file (NoisePlaylist* p, const gchar* without_path);
gboolean noise_playlists_utils_save_playlist_pls (NoisePlaylist* p, const gchar* folder_uri);
gboolean noise_playlists_utils_parse_paths_from_m3u (const gchar* uri, GeeLinkedList** locals);
gboolean noise_playlists_utils_parse_paths_from_pls (const gchar* uri, GeeLinkedList** locals, gchar** title);
void noise_playlists_utils_parse_index_and_value (const gchar* prefix, const gchar* line, GeeHashMap** map);
void noise_playlists_utils_import_from_playlist_file_info (GeeHashMap* playlists, NoiseLibrary* library);
gchar* noise_playlists_utils_get_new_playlist_name (GeeCollection* playlists, const gchar* name);
NoiseStaticPlaylist* noise_playlists_utils_static_playlist_from_smartplaylist (NoiseSmartPlaylist* sp);
void noise_playlists_utils_export_playlist (NoisePlaylist* p);
GeeHashMap* noise_playlists_utils_get_playlists_to_import (const gchar* set_title, GError** error);
GType noise_icon_get_type (void) G_GNUC_CONST;
NoiseIcon* noise_icon_new (const gchar* file_name);
NoiseIcon* noise_icon_construct (GType object_type, const gchar* file_name);
GtkIconInfo* noise_icon_get_icon_info (NoiseIcon* self, gint size);
GFile* noise_icon_get_file (NoiseIcon* self, gint size);
GdkPixbuf* noise_icon_render (NoiseIcon* self, GtkIconSize size, GtkStyleContext* style_context);
GdkPixbuf* noise_icon_render_at_size (NoiseIcon* self, gint pixel_size, GtkStyleContext* style_context);
GtkImage* noise_icon_render_image (NoiseIcon* self, GtkIconSize size);
GtkImage* noise_icon_render_image_at_size (NoiseIcon* self, gint pixel_size);
GtkIconTheme* noise_icon_get_theme (void);
const gchar* noise_icon_get_name (NoiseIcon* self);
const gchar* noise_icon_get_file_name (NoiseIcon* self);
GIcon* noise_icon_get_gicon (NoiseIcon* self);
gpointer noise_icons_ref (gpointer instance);
void noise_icons_unref (gpointer instance);
GParamSpec* noise_param_spec_icons (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void noise_value_set_icons (GValue* value, gpointer v_object);
void noise_value_take_icons (GValue* value, gpointer v_object);
gpointer noise_value_get_icons (const GValue* value);
GType noise_icons_get_type (void) G_GNUC_CONST;
#define NOISE_ICONS_DEFAULT_ALBUM_ART_SIZE 138
void noise_icons_init (void);
GdkPixbuf* noise_icons_render_icon (const gchar* icon_name, GtkIconSize size, GtkStyleContext* context);
GtkImage* noise_icons_render_image (const gchar* icon_name, GtkIconSize size);
NoiseIcons* noise_icons_new (void);
NoiseIcons* noise_icons_construct (GType object_type);
NoiseIcon* noise_icons_get_DEFAULT_ALBUM_ART (void);
NoiseIcon* noise_icons_get_DEFAULT_ALBUM_ART_2 (void);
NoiseIcon* noise_icons_get_MUSIC_FOLDER (void);
NoiseIcon* noise_icons_get_IMPORT (void);
NoiseIcon* noise_icons_get_HISTORY (void);
NoiseIcon* noise_icons_get_QUEUE (void);
NoiseIcon* noise_icons_get_NOISE (void);
NoiseIcon* noise_icons_get_MUSIC (void);
NoiseIcon* noise_icons_get_AUDIO_CD (void);
NoiseIcon* noise_icons_get_AUDIO_DEVICE (void);
NoiseIcon* noise_icons_get_GENERIC_AUDIO (void);
NoiseIcon* noise_icons_get_NETWORK_DEVICE (void);
NoiseIcon* noise_icons_get_PLAYLIST (void);
NoiseIcon* noise_icons_get_SMART_PLAYLIST (void);
NoiseIcon* noise_icons_get_STARRED (void);
NoiseIcon* noise_icons_get_NOT_STARRED (void);
NoiseIcon* noise_icons_get_LOVE (void);
NoiseIcon* noise_icons_get_BAN (void);
NoiseIcon* noise_icons_get_PANE_SHOW_SYMBOLIC (void);
NoiseIcon* noise_icons_get_PANE_HIDE_SYMBOLIC (void);
NoiseIcon* noise_icons_get_EQ_SYMBOLIC (void);
NoiseIcon* noise_icons_get_EJECT_SYMBOLIC (void);
NoiseIcon* noise_icons_get_NOW_PLAYING_SYMBOLIC (void);
NoiseIcon* noise_icons_get_STARRED_SYMBOLIC (void);
NoiseIcon* noise_icons_get_NOT_STARRED_SYMBOLIC (void);
NoiseIcon* noise_icons_get_PROCESS_COMPLETED (void);
NoiseIcon* noise_icons_get_PROCESS_ERROR (void);
NoiseIcon* noise_icons_get_PROCESS_STOP (void);
NoiseIcon* noise_icons_get_REPEAT_ON (void);
NoiseIcon* noise_icons_get_REPEAT_ONE (void);
NoiseIcon* noise_icons_get_REPEAT_OFF (void);
NoiseIcon* noise_icons_get_SHUFFLE_ON (void);
NoiseIcon* noise_icons_get_SHUFFLE_OFF (void);
NoiseIcon* noise_icons_get_VIEW_COLUMN (void);
NoiseIcon* noise_icons_get_VIEW_DETAILS (void);
NoiseIcon* noise_icons_get_VIEW_ICONS (void);
NoiseIcon* noise_icons_get_VIEW_VIDEO (void);
NoiseIcon* noise_icons_get_LIST_ADD_SYMBOLIC (void);
NoiseIcon* noise_icons_get_REFRESH_SYMBOLIC (void);
void noise_search_search_in_media_list (GeeCollection* to_search, GeeCollection** results, const gchar* album_artist, const gchar* album, const gchar* genre, const gchar* grouping, const gchar* composer, gint year, gint rating, GCancellable* cancellable);
gboolean noise_search_match_fields_to_media (NoiseMedia* media, const gchar* album_artist, const gchar* album, const gchar* genre, const gchar* grouping, const gchar* composer, gint year, gint rating);
gchar* noise_search_get_valid_search_string (const gchar* s);
gint noise_search_get_rating_from_string (const gchar* rating_string);
gboolean noise_search_match_string_to_media (NoiseMedia* m, const gchar* search);
GdkPixbuf* noise_pixbuf_utils_render_pixbuf_shadow (GdkPixbuf* pixbuf, gint shadow_size, gdouble alpha);
void noise_pixbuf_utils_get_pixbuf_from_file_async (GFile* file, GCancellable* c, GAsyncReadyCallback _callback_, gpointer _user_data_);
GdkPixbuf* noise_pixbuf_utils_get_pixbuf_from_file_finish (GAsyncResult* _res_, GError** error);
void noise_pixbuf_utils_get_pixbuf_from_file_at_scale_async (GFile* file, gint width, gint height, gboolean preserve_aspect_ratio, GCancellable* c, GAsyncReadyCallback _callback_, gpointer _user_data_);
GdkPixbuf* noise_pixbuf_utils_get_pixbuf_from_file_at_scale_finish (GAsyncResult* _res_, GError** error);
void noise_pixbuf_utils_save_pixbuf_async (GdkPixbuf* pixbuf, GFile* dest_file, const gchar* image_format, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void noise_pixbuf_utils_save_pixbuf_finish (GAsyncResult* _res_, GError** error);
gpointer noise_pixbuf_cache_ref (gpointer instance);
void noise_pixbuf_cache_unref (gpointer instance);
GParamSpec* noise_param_spec_pixbuf_cache (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void noise_value_set_pixbuf_cache (GValue* value, gpointer v_object);
void noise_value_take_pixbuf_cache (GValue* value, gpointer v_object);
gpointer noise_value_get_pixbuf_cache (const GValue* value);
GType noise_pixbuf_cache_get_type (void) G_GNUC_CONST;
NoisePixbufCache* noise_pixbuf_cache_new (GFile* image_dir, GdkPixbufFormat* image_format);
NoisePixbufCache* noise_pixbuf_cache_construct (GType object_type, GFile* image_dir, GdkPixbufFormat* image_format);
gboolean noise_pixbuf_cache_has_image (NoisePixbufCache* self, const gchar* key);
GFile* noise_pixbuf_cache_get_cached_image_file (NoisePixbufCache* self, const gchar* key);
GdkPixbuf* noise_pixbuf_cache_decache_image (NoisePixbufCache* self, const gchar* key);
void noise_pixbuf_cache_cache_image_async (NoisePixbufCache* self, const gchar* key, GdkPixbuf* image, GAsyncReadyCallback _callback_, gpointer _user_data_);
void noise_pixbuf_cache_cache_image_finish (NoisePixbufCache* self, GAsyncResult* _res_);
void noise_pixbuf_cache_cache_image_from_file_async (NoisePixbufCache* self, const gchar* key, GFile* image_file, GCancellable* c, GAsyncReadyCallback _callback_, gpointer _user_data_);
void noise_pixbuf_cache_cache_image_from_file_finish (NoisePixbufCache* self, GAsyncResult* _res_);
GdkPixbuf* noise_pixbuf_cache_get_image (NoisePixbufCache* self, const gchar* key);
void noise_pixbuf_cache_get_image_async (NoisePixbufCache* self, const gchar* key, gboolean lookup_file, GAsyncReadyCallback _callback_, gpointer _user_data_);
GdkPixbuf* noise_pixbuf_cache_get_image_finish (NoisePixbufCache* self, GAsyncResult* _res_);
GeeMap* noise_pixbuf_cache_get_images (NoisePixbufCache* self);
GdkPixbufFormat* noise_pixbuf_cache_get_image_format (NoisePixbufCache* self);
GType noise_pipeline_get_type (void) G_GNUC_CONST;
GType noise_equalizer_get_type (void) G_GNUC_CONST;
NoisePipeline* noise_pipeline_new (void);
NoisePipeline* noise_pipeline_construct (GType object_type);
void noise_pipeline_enableEqualizer (NoisePipeline* self);
void noise_pipeline_disableEqualizer (NoisePipeline* self);
NoiseEqualizer* noise_equalizer_new (void);
NoiseEqualizer* noise_equalizer_construct (GType object_type);
void noise_equalizer_setGain (NoiseEqualizer* self, gint index, gdouble gain);
GeeCollection* noise_equalizer_get_default_presets (void);
GeeCollection* noise_playback_get_supported_uri (NoisePlayback* self);
void noise_playback_play (NoisePlayback* self);
void noise_playback_pause (NoisePlayback* self);
void noise_playback_set_state (NoisePlayback* self, GstState s);
void noise_playback_set_media (NoisePlayback* self, NoiseMedia* media);
void noise_playback_set_position (NoisePlayback* self, gint64 pos);
gint64 noise_playback_get_position (NoisePlayback* self);
gint64 noise_playback_get_duration (NoisePlayback* self);
void noise_playback_set_volume (NoisePlayback* self, gdouble val);
gdouble noise_playback_get_volume (NoisePlayback* self);
gboolean noise_playback_update_position (NoisePlayback* self);
void noise_playback_enable_equalizer (NoisePlayback* self);
void noise_playback_disable_equalizer (NoisePlayback* self);
void noise_playback_set_equalizer_gain (NoisePlayback* self, gint index, gint val);
GType noise_settings_window_notebook_page_get_type (void) G_GNUC_CONST;
NoiseSettingsWindowNoteBook_Page* noise_settings_window_notebook_page_new (const gchar* name);
NoiseSettingsWindowNoteBook_Page* noise_settings_window_notebook_page_construct (GType object_type, const gchar* name);
void noise_settings_window_notebook_page_add_section (NoiseSettingsWindowNoteBook_Page* self, GtkLabel* name, gint* row);
void noise_settings_window_notebook_page_add_option (NoiseSettingsWindowNoteBook_Page* self, GtkWidget* label, GtkWidget* switcher, gint* row);
void noise_settings_window_notebook_page_add_full_option (NoiseSettingsWindowNoteBook_Page* self, GtkWidget* big_widget, gint* row);
const gchar* noise_settings_window_notebook_page_get_name (NoiseSettingsWindowNoteBook_Page* self);

extern const gchar* NOISE_MEDIA_CONTENT_TYPES[48];
extern const gchar* NOISE_PLAYLISTS_CONTENT_TYPES[2];
extern const gchar* NOISE_PIXBUF_CACHE_IMAGE_TYPES[3];

G_END_DECLS

#endif
