// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _GCPnts_UniformAbscissa_HeaderFile
#define _GCPnts_UniformAbscissa_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <Standard_Boolean.hxx>
#include <Standard_Integer.hxx>
#include <Standard_Real.hxx>
#include <Handle_TColStd_HArray1OfReal.hxx>
class TColStd_HArray1OfReal;
class Standard_DomainError;
class Standard_ConstructionError;
class Standard_OutOfRange;
class StdFail_NotDone;
class Adaptor3d_Curve;
class Adaptor2d_Curve2d;


//! This class allows to compute a uniform distribution of points
//! on a curve (ie the points will all be equally distant).
class GCPnts_UniformAbscissa 
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! creation of a indefinite UniformAbscissa
  Standard_EXPORT GCPnts_UniformAbscissa();
  
  //! Computes a uniform abscissa distribution of points on
  //! the Curve <C>. Parameter Toler is equal Precision::Confusion by default.
  //! It Is used for more precise calculation of curve length
  Standard_EXPORT GCPnts_UniformAbscissa(Adaptor3d_Curve& C, const Standard_Real Abscissa, const Standard_Real Toler = -1);
  
  //! Computes a Uniform abscissa distribution of points
  //! on a part of the Curve <C>. Parameter Toler is equal Precision::Confusion by default.
  //! It Is used for more precise calculation of curve length
  Standard_EXPORT GCPnts_UniformAbscissa(Adaptor3d_Curve& C, const Standard_Real Abscissa, const Standard_Real U1, const Standard_Real U2, const Standard_Real Toler = -1);
  
  //! Computes a uniform abscissa distribution of points on
  //! the Curve <C>.
  //! <NbPoints> defines the nomber of desired points.
  //! Parameter Toler is equal Precision::Confusion by default.
  //! It Is used for more precise calculation of curve length
  Standard_EXPORT GCPnts_UniformAbscissa(Adaptor3d_Curve& C, const Standard_Integer NbPoints, const Standard_Real Toler = -1);
  
  //! Computes a Uniform abscissa distribution of points
  //! on a part of the Curve <C>.
  //! Parameter Toler is equal Precision::Confusion by default.
  //! It Is used for more precise calculation of curve length
  Standard_EXPORT GCPnts_UniformAbscissa(Adaptor3d_Curve& C, const Standard_Integer NbPoints, const Standard_Real U1, const Standard_Real U2, const Standard_Real Toler = -1);
  
  //! Initialize the algoritms with <C>, <Abscissa>, <Toler>
  Standard_EXPORT   void Initialize (Adaptor3d_Curve& C, const Standard_Real Abscissa, const Standard_Real Toler = -1) ;
  
  //! Initialize the algoritms with <C>, <Abscissa>, <U1>,
  //! <U2>, <Toler>
  Standard_EXPORT   void Initialize (Adaptor3d_Curve& C, const Standard_Real Abscissa, const Standard_Real U1, const Standard_Real U2, const Standard_Real Toler = -1) ;
  
  //! Initialize the algoritms with <C>, <NbPoints>, <Toler> and
  Standard_EXPORT   void Initialize (Adaptor3d_Curve& C, const Standard_Integer NbPoints, const Standard_Real Toler = -1) ;
  
  //! Initialize the algoritms with <C>, <Abscissa>, <U1>,
  //! <U2>, <Toler>.
  Standard_EXPORT   void Initialize (Adaptor3d_Curve& C, const Standard_Integer NbPoints, const Standard_Real U1, const Standard_Real U2, const Standard_Real Toler = -1) ;
  
  //! Computes a uniform abscissa distribution of points on
  //! the Curve2d <C>.
  //! Parameter Toler is equal Precision::Confusion by default.
  //! It Is used for more precise calculation of curve length
  Standard_EXPORT GCPnts_UniformAbscissa(Adaptor2d_Curve2d& C, const Standard_Real Abscissa, const Standard_Real Toler = -1);
  
  //! Computes a Uniform abscissa distribution of points
  //! on a part of the Curve2d <C>.
  //! Parameter Toler is equal Precision::Confusion by default.
  //! It Is used for more precise calculation of curve length
  Standard_EXPORT GCPnts_UniformAbscissa(Adaptor2d_Curve2d& C, const Standard_Real Abscissa, const Standard_Real U1, const Standard_Real U2, const Standard_Real Toler = -1);
  
  //! Computes a uniform abscissa distribution of points on
  //! the Curve2d <C>.
  //! <NbPoints> defines the nomber of desired points.
  //! Parameter Toler is equal Precision::Confusion by default.
  //! It Is used for more precise calculation of curve length
  Standard_EXPORT GCPnts_UniformAbscissa(Adaptor2d_Curve2d& C, const Standard_Integer NbPoints, const Standard_Real Toler = -1);
  
  //! Computes a Uniform abscissa distribution of points
  //! on a part of the Curve2d <C>.
  //! Parameter Toler is equal Precision::Confusion by default.
  //! It Is used for more precise calculation of curve length
  Standard_EXPORT GCPnts_UniformAbscissa(Adaptor2d_Curve2d& C, const Standard_Integer NbPoints, const Standard_Real U1, const Standard_Real U2, const Standard_Real Toler = -1);
  
  //! Initialize the algoritms with <C>, <Abscissa>, <Toler>
  Standard_EXPORT   void Initialize (Adaptor2d_Curve2d& C, const Standard_Real Abscissa, const Standard_Real Toler = -1) ;
  
  //! Initialize the algoritms with <C>, <Abscissa>, <U1>,
  //! <U2>, <Toler>
  Standard_EXPORT   void Initialize (Adaptor2d_Curve2d& C, const Standard_Real Abscissa, const Standard_Real U1, const Standard_Real U2, const Standard_Real Toler = -1) ;
  
  //! Initialize the algoritms with <C>, <NbPoints>, <Toler> and
  Standard_EXPORT   void Initialize (Adaptor2d_Curve2d& C, const Standard_Integer NbPoints, const Standard_Real Toler = -1) ;
  
  //! Initialize the algoritms with <C>, <Abscissa>, <U1>,
  //! <U2>, <Toler>.
  Standard_EXPORT   void Initialize (Adaptor2d_Curve2d& C, const Standard_Integer NbPoints, const Standard_Real U1, const Standard_Real U2, const Standard_Real Toler = -1) ;
  
      Standard_Boolean IsDone()  const;
  
      Standard_Integer NbPoints()  const;
  
  //! returns the computed Parameter of index <Index>.
      Standard_Real Parameter (const Standard_Integer Index)  const;
  
  //! returne the current abscissa
  //! ie the distance between two consecutive points
      Standard_Real Abscissa()  const;




protected:





private:



  Standard_Boolean myDone;
  Standard_Integer myNbPoints;
  Standard_Real myAbscissa;
  Handle(TColStd_HArray1OfReal) myParams;


};


#include <GCPnts_UniformAbscissa.lxx>





#endif // _GCPnts_UniformAbscissa_HeaderFile
