// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Law_HeaderFile
#define _Law_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <Handle_Law_BSpFunc.hxx>
#include <Handle_Law_Linear.hxx>
#include <Handle_TColStd_HArray1OfReal.hxx>
#include <Standard_Integer.hxx>
#include <Standard_Boolean.hxx>
#include <Handle_Law_BSpline.hxx>
#include <Standard_Real.hxx>
class Law_BSpFunc;
class Law_Linear;
class TColStd_HArray1OfReal;
class TColStd_Array1OfReal;
class TColStd_Array1OfInteger;
class Law_BSpline;
class Adaptor3d_Curve;
class Law_BSpline;
class Law_Interpolate;
class Law_Function;
class Law_Constant;
class Law_Linear;
class Law_BSpFunc;
class Law_S;
class Law_Interpol;
class Law_Laws;
class Law_Composite;
class Law_BSplineKnotSplitting;
class Law_ListNodeOfLaws;
class Law_ListIteratorOfLaws;


//! Multiple services concerning 1d functions.
class Law 
{
public:

  DEFINE_STANDARD_ALLOC

  

  //! This algorithm searches the knot values corresponding to the
  //! splitting of a given B-spline law into  several arcs with
  //! the same continuity. The continuity order is given at the
  //! construction time.
  //! Builds a 1d bspline that   is near from Lin with  null
  //! derivatives at the extremities.
  Standard_EXPORT static   Handle(Law_BSpFunc) MixBnd (const Handle(Law_Linear)& Lin) ;
  
  //! Builds  the poles of the 1d  bspline that is near from
  //! Lin with null derivatives at the extremities.
  Standard_EXPORT static   Handle(TColStd_HArray1OfReal) MixBnd (const Standard_Integer Degree, const TColStd_Array1OfReal& Knots, const TColStd_Array1OfInteger& Mults, const Handle(Law_Linear)& Lin) ;
  
  //! Builds the poles of the 1d bspline that is null on the
  //! rigth    side   of   Knots(Index)  (on  the    left if
  //! NulOnTheRight  is  false)    and   that is     like  a
  //! t*(1-t)(1-t) curve  on the  left side of  Knots(Index)
  //! (on the rigth  if NulOnTheRight is false).  The result
  //! curve is  C1 with  a derivative  equal  to 1. at first
  //! parameter (-1 at last  parameter  if  NulOnTheRight is
  //! false).
  //! Warning: Mults(Index) must greater or equal to degree-1.
  Standard_EXPORT static   Handle(TColStd_HArray1OfReal) MixTgt (const Standard_Integer Degree, const TColStd_Array1OfReal& Knots, const TColStd_Array1OfInteger& Mults, const Standard_Boolean NulOnTheRight, const Standard_Integer Index) ;
  
  //! Computes a 1 d curve to  reparametrize a curve. Its an
  //! interpolation of NbPoints  points calculated  at quasi
  //! constant abscissa.
  Standard_EXPORT static   Handle(Law_BSpline) Reparametrize (const Adaptor3d_Curve& Curve, const Standard_Real First, const Standard_Real Last, const Standard_Boolean HasDF, const Standard_Boolean HasDL, const Standard_Real DFirst, const Standard_Real DLast, const Standard_Boolean Rev, const Standard_Integer NbPoints) ;
  
  //! Computes a 1  d curve to  scale  a field of  tangency.
  //! Value is 1. for t = (First+Last)/2 .
  //! If HasFirst value for t = First is VFirst (null derivative).
  //! If HasLast value for t = Last is VLast (null derivative).
  //!
  //! 1.                   _
  //! _/ \_
  //! __/     \__
  //! /           
  //! VFirst    ____/             
  //! VLast                        \____
  //! First                    Last
  Standard_EXPORT static   Handle(Law_BSpline) Scale (const Standard_Real First, const Standard_Real Last, const Standard_Boolean HasF, const Standard_Boolean HasL, const Standard_Real VFirst, const Standard_Real VLast) ;
  
  Standard_EXPORT static   Handle(Law_BSpline) ScaleCub (const Standard_Real First, const Standard_Real Last, const Standard_Boolean HasF, const Standard_Boolean HasL, const Standard_Real VFirst, const Standard_Real VLast) ;




protected:





private:




friend class Law_BSpline;
friend class Law_Interpolate;
friend class Law_Function;
friend class Law_Constant;
friend class Law_Linear;
friend class Law_BSpFunc;
friend class Law_S;
friend class Law_Interpol;
friend class Law_Laws;
friend class Law_Composite;
friend class Law_BSplineKnotSplitting;
friend class Law_ListNodeOfLaws;
friend class Law_ListIteratorOfLaws;

};







#endif // _Law_HeaderFile
