type token =
  | TUnknown of (Parse_info.info)
  | EOF of (Parse_info.info)
  | TCommentSpace of (Parse_info.info)
  | TCommentNewline of (Parse_info.info)
  | TComment of (Parse_info.info)
  | TComment_Pp of ((Token_cpp.cppcommentkind * Parse_info.info))
  | TComment_Cpp of ((Token_cpp.cpluspluscommentkind * Parse_info.info))
  | TInt of (string * Parse_info.info)
  | TFloat of ((string * Ast_cpp.floatType) * Parse_info.info)
  | TChar of ((string * Ast_cpp.isWchar) * Parse_info.info)
  | TString of ((string * Ast_cpp.isWchar) * Parse_info.info)
  | TIdent of (string * Parse_info.info)
  | TIdent_Typedef of (string * Parse_info.info)
  | TOPar of (Parse_info.info)
  | TCPar of (Parse_info.info)
  | TOBrace of (Parse_info.info)
  | TCBrace of (Parse_info.info)
  | TOCro of (Parse_info.info)
  | TCCro of (Parse_info.info)
  | TDot of (Parse_info.info)
  | TComma of (Parse_info.info)
  | TPtrOp of (Parse_info.info)
  | TInc of (Parse_info.info)
  | TDec of (Parse_info.info)
  | TAssign of (Ast_cpp.assignOp * Parse_info.info)
  | TEq of (Parse_info.info)
  | TWhy of (Parse_info.info)
  | TTilde of (Parse_info.info)
  | TBang of (Parse_info.info)
  | TEllipsis of (Parse_info.info)
  | TCol of (Parse_info.info)
  | TPtVirg of (Parse_info.info)
  | TOrLog of (Parse_info.info)
  | TAndLog of (Parse_info.info)
  | TOr of (Parse_info.info)
  | TXor of (Parse_info.info)
  | TAnd of (Parse_info.info)
  | TEqEq of (Parse_info.info)
  | TNotEq of (Parse_info.info)
  | TInfEq of (Parse_info.info)
  | TSupEq of (Parse_info.info)
  | TShl of (Parse_info.info)
  | TShr of (Parse_info.info)
  | TPlus of (Parse_info.info)
  | TMinus of (Parse_info.info)
  | TMul of (Parse_info.info)
  | TDiv of (Parse_info.info)
  | TMod of (Parse_info.info)
  | TInf of (Parse_info.info)
  | TSup of (Parse_info.info)
  | Tchar of (Parse_info.info)
  | Tshort of (Parse_info.info)
  | Tint of (Parse_info.info)
  | Tdouble of (Parse_info.info)
  | Tfloat of (Parse_info.info)
  | Tlong of (Parse_info.info)
  | Tunsigned of (Parse_info.info)
  | Tsigned of (Parse_info.info)
  | Tvoid of (Parse_info.info)
  | Tauto of (Parse_info.info)
  | Tregister of (Parse_info.info)
  | Textern of (Parse_info.info)
  | Tstatic of (Parse_info.info)
  | Ttypedef of (Parse_info.info)
  | Tconst of (Parse_info.info)
  | Tvolatile of (Parse_info.info)
  | Tstruct of (Parse_info.info)
  | Tunion of (Parse_info.info)
  | Tenum of (Parse_info.info)
  | Tbreak of (Parse_info.info)
  | Telse of (Parse_info.info)
  | Tswitch of (Parse_info.info)
  | Tcase of (Parse_info.info)
  | Tcontinue of (Parse_info.info)
  | Tfor of (Parse_info.info)
  | Tdo of (Parse_info.info)
  | Tif of (Parse_info.info)
  | Twhile of (Parse_info.info)
  | Treturn of (Parse_info.info)
  | Tgoto of (Parse_info.info)
  | Tdefault of (Parse_info.info)
  | Tsizeof of (Parse_info.info)
  | Trestrict of (Parse_info.info)
  | Tasm of (Parse_info.info)
  | Ttypeof of (Parse_info.info)
  | Tattribute of (Parse_info.info)
  | Tinline of (Parse_info.info)
  | TDefine of (Parse_info.info)
  | TDefParamVariadic of ((string * Parse_info.info))
  | TCppEscapedNewline of (Parse_info.info)
  | TIdent_Define of ((string * Parse_info.info))
  | TOPar_Define of (Parse_info.info)
  | TCommentNewline_DefineEndOfMacro of (Parse_info.info)
  | TOBrace_DefineInit of (Parse_info.info)
  | TInclude of ((string * string * Parse_info.info))
  | TIfdef of (Parse_info.info)
  | TIfdefelse of (Parse_info.info)
  | TIfdefelif of (Parse_info.info)
  | TEndif of (Parse_info.info)
  | TIfdefBool of ((bool * Parse_info.info))
  | TIfdefMisc of ((bool * Parse_info.info))
  | TIfdefVersion of ((bool * Parse_info.info))
  | TUndef of (string * Parse_info.info)
  | TCppDirectiveOther of (Parse_info.info)
  | TIdent_MacroStmt of (Parse_info.info)
  | TIdent_MacroString of (Parse_info.info)
  | TIdent_MacroIterator of ((string * Parse_info.info))
  | TIdent_MacroDecl of ((string * Parse_info.info))
  | Tconst_MacroDeclConst of (Parse_info.info)
  | TCPar_EOL of (Parse_info.info)
  | TAny_Action of (Parse_info.info)
  | Tclass of (Parse_info.info)
  | Tthis of (Parse_info.info)
  | Tnew of (Parse_info.info)
  | Tdelete of (Parse_info.info)
  | Ttemplate of (Parse_info.info)
  | Ttypeid of (Parse_info.info)
  | Ttypename of (Parse_info.info)
  | Tcatch of (Parse_info.info)
  | Ttry of (Parse_info.info)
  | Tthrow of (Parse_info.info)
  | Toperator of (Parse_info.info)
  | Tpublic of (Parse_info.info)
  | Tprivate of (Parse_info.info)
  | Tprotected of (Parse_info.info)
  | Tfriend of (Parse_info.info)
  | Tvirtual of (Parse_info.info)
  | Tnamespace of (Parse_info.info)
  | Tusing of (Parse_info.info)
  | Tbool of (Parse_info.info)
  | Tfalse of (Parse_info.info)
  | Ttrue of (Parse_info.info)
  | Twchar_t of (Parse_info.info)
  | Tconst_cast of (Parse_info.info)
  | Tdynamic_cast of (Parse_info.info)
  | Tstatic_cast of (Parse_info.info)
  | Treinterpret_cast of (Parse_info.info)
  | Texplicit of (Parse_info.info)
  | Tmutable of (Parse_info.info)
  | Texport of (Parse_info.info)
  | TPtrOpStar of (Parse_info.info)
  | TDotStar of (Parse_info.info)
  | TColCol of (Parse_info.info)
  | TOPar_CplusplusInit of (Parse_info.info)
  | TInf_Template of (Parse_info.info)
  | TSup_Template of (Parse_info.info)
  | TOCro_new of (Parse_info.info)
  | TCCro_new of (Parse_info.info)
  | TInt_ZeroVirtual of (Parse_info.info)
  | TIdent_ClassnameInQualifier of (string * Parse_info.info)
  | TIdent_ClassnameInQualifier_BeforeTypedef of (string * Parse_info.info)
  | TIdent_Templatename of (string * Parse_info.info)
  | TIdent_TemplatenameInQualifier of (string * Parse_info.info)
  | TIdent_TemplatenameInQualifier_BeforeTypedef of (string * Parse_info.info)
  | TIdent_Constructor of (string * Parse_info.info)
  | TIdent_TypedefConstr of (string * Parse_info.info)
  | Tchar_Constr of (Parse_info.info)
  | Tint_Constr of (Parse_info.info)
  | Tfloat_Constr of (Parse_info.info)
  | Tdouble_Constr of (Parse_info.info)
  | Twchar_t_Constr of (Parse_info.info)
  | Tshort_Constr of (Parse_info.info)
  | Tlong_Constr of (Parse_info.info)
  | Tbool_Constr of (Parse_info.info)
  | Tsigned_Constr of (Parse_info.info)
  | Tunsigned_Constr of (Parse_info.info)
  | TColCol_BeforeTypedef of (Parse_info.info)

val main :
  (Lexing.lexbuf  -> token) -> Lexing.lexbuf -> Ast_cpp.program
val toplevel :
  (Lexing.lexbuf  -> token) -> Lexing.lexbuf -> Ast_cpp.toplevel option
val statement :
  (Lexing.lexbuf  -> token) -> Lexing.lexbuf -> Ast_cpp.statement
val expr :
  (Lexing.lexbuf  -> token) -> Lexing.lexbuf -> Ast_cpp.expression
val type_id :
  (Lexing.lexbuf  -> token) -> Lexing.lexbuf -> Ast_cpp.fullType
