/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

public class InternalTypeEnumeration {
    private String descriptor;
    private int formalTypeParametersIndex;
    private int openIndex;
    private int closeIndex;
    private int index;

    public InternalTypeEnumeration(String string) {
        this.descriptor = string;
        if (string.charAt(0) == '<') {
            this.formalTypeParametersIndex = 1;
            int n = 1;
            do {
                char c = string.charAt(this.formalTypeParametersIndex++);
                switch (c) {
                    case '<': {
                        ++n;
                        break;
                    }
                    case '>': {
                        --n;
                    }
                }
            } while (n > 0);
        }
        this.openIndex = string.indexOf(40, this.formalTypeParametersIndex);
        this.closeIndex = this.openIndex >= 0 ? string.indexOf(41, this.openIndex) : string.length();
        this.index = this.openIndex >= 0 ? this.openIndex + 1 : this.formalTypeParametersIndex;
    }

    public boolean hasFormalTypeParameters() {
        return this.formalTypeParametersIndex > 0;
    }

    public String formalTypeParameters() {
        return this.descriptor.substring(0, this.formalTypeParametersIndex);
    }

    public boolean isMethodSignature() {
        return this.openIndex >= 0;
    }

    public boolean hasMoreTypes() {
        return this.index < this.closeIndex;
    }

    public String nextType() {
        int n = this.index;
        this.skipArray();
        char c = this.descriptor.charAt(this.index++);
        switch (c) {
            case 'L': 
            case 'T': {
                this.skipClass();
                break;
            }
            case '<': {
                this.skipGeneric();
            }
        }
        return this.descriptor.substring(n, this.index);
    }

    public String returnType() {
        return this.descriptor.substring(this.closeIndex + 1);
    }

    private void skipArray() {
        while (this.descriptor.charAt(this.index) == '[') {
            ++this.index;
        }
    }

    private void skipClass() {
        while (true) {
            char c = this.descriptor.charAt(this.index++);
            switch (c) {
                case '<': {
                    this.skipGeneric();
                    break;
                }
                case ';': {
                    return;
                }
            }
        }
    }

    private void skipGeneric() {
        int n = 1;
        do {
            char c = this.descriptor.charAt(this.index++);
            switch (c) {
                case '<': {
                    ++n;
                    break;
                }
                case '>': {
                    --n;
                }
            }
        } while (n > 0);
    }

    public static void main(String[] stringArray) {
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                System.out.println("Descriptor [" + string + "]");
                InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(string);
                if (internalTypeEnumeration.hasFormalTypeParameters()) {
                    System.out.println("  Formal type parameters [" + internalTypeEnumeration.formalTypeParameters() + "]");
                }
                while (internalTypeEnumeration.hasMoreTypes()) {
                    System.out.println("  Type [" + internalTypeEnumeration.nextType() + "]");
                }
                if (!internalTypeEnumeration.isMethodSignature()) continue;
                System.out.println("  Return type [" + internalTypeEnumeration.returnType() + "]");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

