/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.ClassVisitor;

public class MultiClassVisitor
implements ClassVisitor {
    private static final int ARRAY_SIZE_INCREMENT = 5;
    private ClassVisitor[] classVisitors;
    private int classVisitorCount;

    public MultiClassVisitor() {
    }

    public MultiClassVisitor(ClassVisitor[] classVisitorArray) {
        this.classVisitors = classVisitorArray;
        this.classVisitorCount = classVisitorArray.length;
    }

    public void addClassVisitor(ClassVisitor classVisitor) {
        this.ensureArraySize();
        this.classVisitors[this.classVisitorCount++] = classVisitor;
    }

    private void ensureArraySize() {
        if (this.classVisitors == null) {
            this.classVisitors = new ClassVisitor[5];
        } else if (this.classVisitors.length == this.classVisitorCount) {
            ClassVisitor[] classVisitorArray = new ClassVisitor[this.classVisitorCount + 5];
            System.arraycopy(this.classVisitors, 0, classVisitorArray, 0, this.classVisitorCount);
            this.classVisitors = classVisitorArray;
        }
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        for (int i = 0; i < this.classVisitorCount; ++i) {
            this.classVisitors[i].visitProgramClass(programClass);
        }
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        for (int i = 0; i < this.classVisitorCount; ++i) {
            this.classVisitors[i].visitLibraryClass(libraryClass);
        }
    }
}

