/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.LocalVariableInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableTypeInfoVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.shrink.UsageMarker;

public class LocalVariableTypeUsageMarker
extends SimplifiedVisitor
implements AttributeVisitor,
LocalVariableInfoVisitor,
LocalVariableTypeInfoVisitor,
ClassVisitor,
ConstantVisitor {
    private final UsageMarker usageMarker;
    private boolean tableUsed;
    private boolean variableInfoUsed;

    public LocalVariableTypeUsageMarker(UsageMarker usageMarker) {
        this.usageMarker = usageMarker;
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        this.tableUsed = false;
        localVariableTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
        if (this.tableUsed) {
            this.usageMarker.markAsUsed(localVariableTableAttribute);
            this.markConstant(clazz, localVariableTableAttribute.u2attributeNameIndex);
        }
    }

    @Override
    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        this.tableUsed = false;
        localVariableTypeTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
        if (this.tableUsed) {
            this.usageMarker.markAsUsed(localVariableTypeTableAttribute);
            this.markConstant(clazz, localVariableTypeTableAttribute.u2attributeNameIndex);
        }
    }

    @Override
    public void visitLocalVariableInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableInfo localVariableInfo) {
        this.variableInfoUsed = true;
        localVariableInfo.referencedClassAccept(this);
        if (this.variableInfoUsed) {
            this.usageMarker.markAsUsed(localVariableInfo);
            this.markConstant(clazz, localVariableInfo.u2nameIndex);
            this.markConstant(clazz, localVariableInfo.u2descriptorIndex);
            this.tableUsed = true;
        }
    }

    @Override
    public void visitLocalVariableTypeInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeInfo localVariableTypeInfo) {
        this.variableInfoUsed = true;
        localVariableTypeInfo.referencedClassesAccept(this);
        if (this.variableInfoUsed) {
            this.usageMarker.markAsUsed(localVariableTypeInfo);
            this.markConstant(clazz, localVariableTypeInfo.u2nameIndex);
            this.markConstant(clazz, localVariableTypeInfo.u2signatureIndex);
            this.tableUsed = true;
        }
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        if (!this.usageMarker.isUsed(programClass)) {
            this.variableInfoUsed = false;
        }
    }

    @Override
    public void visitAnyConstant(Clazz clazz, Constant constant) {
        this.usageMarker.markAsUsed(constant);
    }

    private void markConstant(Clazz clazz, int n) {
        clazz.constantPoolEntryAccept(n, this);
    }
}

