from __future__ import print_function, division, absolute_import
from fontTools.misc.py23 import *
from fontTools.pens.basePen import BasePen


__all__ = ["QtPen"]


class QtPen(BasePen):

	def __init__(self, glyphSet, path=None):
		BasePen.__init__(self, glyphSet)
		if path is None:
			from PyQt5.QtGui import QPainterPath
			path = QPainterPath()
		self.path = path

	def _moveTo(self, p):
		self.path.moveTo(*p)

	def _lineTo(self, p):
		self.path.lineTo(*p)

	def _curveToOne(self, p1, p2, p3):
		self.path.cubicTo(*p1+p2+p3)

	def _closePath(self):
		self.path.closeSubpath()
