#   Copyright 2016 NEC Corporation
#
#   Licensed under the Apache License, Version 2.0 (the "License"); you may
#   not use this file except in compliance with the License. You may obtain
#   a copy of the License at
#
#        http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#   WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#   License for the specific language governing permissions and limitations
#   under the License.

import abc
import logging

from cliff import command
from cliff import lister
from cliff import show
import six

from openstackclient.common import exceptions
from openstackclient.i18n import _


class CommandMeta(abc.ABCMeta):

    def __new__(mcs, name, bases, cls_dict):
        if 'log' not in cls_dict:
            cls_dict['log'] = logging.getLogger(
                cls_dict['__module__'] + '.' + name)
        return super(CommandMeta, mcs).__new__(mcs, name, bases, cls_dict)


@six.add_metaclass(CommandMeta)
class Command(command.Command):

    def run(self, parsed_args):
        self.log.debug('run(%s)', parsed_args)
        return super(Command, self).run(parsed_args)

    def validate_os_beta_command_enabled(self):
        if not self.app.options.os_beta_command:
            msg = _('Caution: This is a beta command and subject to '
                    'change. Use global option --os-beta-command '
                    'to enable this command.')
            raise exceptions.CommandError(msg)


class Lister(Command, lister.Lister):
    pass


class ShowOne(Command, show.ShowOne):
    pass
