/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.cache.RepositoryCacheManager;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.DownloadReport;
import org.apache.ivy.core.report.DownloadStatus;
import org.apache.ivy.core.report.MetadataArtifactDownloadReport;
import org.apache.ivy.core.resolve.DownloadOptions;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.plugins.namespace.Namespace;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.apache.ivy.plugins.parser.ModuleDescriptorParserRegistry;
import org.apache.ivy.plugins.repository.ArtifactResourceResolver;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.ResourceDownloader;
import org.apache.ivy.plugins.repository.file.FileRepository;
import org.apache.ivy.plugins.repository.file.FileResource;
import org.apache.ivy.plugins.repository.url.URLRepository;
import org.apache.ivy.plugins.repository.url.URLResource;
import org.apache.ivy.plugins.resolver.AbstractResolver;
import org.apache.ivy.plugins.resolver.BasicResolver$1;
import org.apache.ivy.plugins.resolver.BasicResolver$2;
import org.apache.ivy.plugins.resolver.BasicResolver$3;
import org.apache.ivy.plugins.resolver.BasicResolver$5;
import org.apache.ivy.plugins.resolver.BasicResolver$6;
import org.apache.ivy.plugins.resolver.BasicResolver$UnresolvedDependencyException;
import org.apache.ivy.plugins.resolver.util.MDResolvedResource;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.plugins.resolver.util.ResourceMDParser;
import org.apache.ivy.plugins.version.VersionMatcher;
import org.apache.ivy.util.ChecksumHelper;
import org.apache.ivy.util.HostUtil;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.extendable.ExtendableItem;

public abstract class BasicResolver
extends AbstractResolver {
    private String workspaceName;
    private List ivyattempts = new ArrayList();
    private Map artattempts = new HashMap();
    private boolean checkconsistency = true;
    private boolean allownomd = true;
    private URLRepository extartifactrep = new URLRepository();
    private final ArtifactResourceResolver artifactResourceResolver = new BasicResolver$5(this);
    private final ResourceDownloader downloader = new BasicResolver$6(this);

    public BasicResolver() {
        this.workspaceName = HostUtil.getLocalHostName();
    }

    @Override
    public ResolvedModuleRevision getDependency(DependencyDescriptor dependencyDescriptor, ResolveData resolveData) {
        Object object;
        Object object2;
        IvyContext ivyContext = IvyContext.pushNewCopyContext();
        try {
            Object object3;
            ModuleDescriptor moduleDescriptor;
            Object object4;
            Object object5;
            BasicResolver basicResolver;
            Object object6;
            object2 = resolveData.getCurrentResolvedModuleRevision();
            if (object2 != null) {
                Object object7 = object2;
                object6 = dependencyDescriptor;
                basicResolver = this;
                object5 = object6.getDependencyRevisionId();
                boolean bl = basicResolver.getSettings().getVersionMatcher().isDynamic((ModuleRevisionId)object5);
                if ((((ResolvedModuleRevision)object7).isForce() | (!bl && !((ResolvedModuleRevision)object7).getDescriptor().isDefault())) & true) {
                    Object object8 = object2;
                    return object8;
                }
            }
            object = dependencyDescriptor;
            DependencyDescriptor dependencyDescriptor2 = this.fromSystem(dependencyDescriptor);
            ivyContext.setDependencyDescriptor((DependencyDescriptor)object);
            ivyContext.setResolveData(resolveData);
            basicResolver = this;
            basicResolver.ivyattempts.clear();
            basicResolver.clearArtifactAttempts();
            this.clearArtifactAttempts();
            ModuleRevisionId moduleRevisionId = object.getDependencyRevisionId();
            ModuleRevisionId moduleRevisionId2 = dependencyDescriptor2.getDependencyRevisionId();
            object6 = moduleRevisionId;
            basicResolver = this;
            int n = ((ModuleRevisionId)object6).getRevision().indexOf("@");
            if (n != -1 && !((ModuleRevisionId)object6).getRevision().substring(n + 1).equals(basicResolver.workspaceName)) {
                throw new BasicResolver$UnresolvedDependencyException("\t" + basicResolver.getName() + ": unhandled revision => " + ((ModuleRevisionId)object6).getRevision());
            }
            object6 = moduleRevisionId;
            boolean bl = this.getSettings().getVersionMatcher().isDynamic((ModuleRevisionId)object6);
            ResolvedModuleRevision resolvedModuleRevision = this.findModuleInCache((DependencyDescriptor)object, resolveData);
            if (resolvedModuleRevision != null) {
                if (resolvedModuleRevision.getDescriptor().isDefault() && resolvedModuleRevision.getResolver() != this) {
                    Message.verbose("\t" + this.getName() + ": found revision in cache: " + moduleRevisionId + " (resolved by " + resolvedModuleRevision.getResolver().getName() + "): but it's a default one, maybe we can find a better one");
                } else {
                    Message.verbose("\t" + this.getName() + ": revision in cache: " + moduleRevisionId);
                    ResolvedModuleRevision resolvedModuleRevision2 = resolvedModuleRevision;
                    BasicResolver basicResolver2 = this;
                    ResolvedModuleRevision resolvedModuleRevision3 = this.checkLatest((DependencyDescriptor)object, resolvedModuleRevision2 == null ? null : resolvedModuleRevision2, resolveData);
                    return resolvedModuleRevision3;
                }
            }
            if (resolveData.getOptions().isUseCacheOnly()) {
                throw new BasicResolver$UnresolvedDependencyException("\t" + this.getName() + " (useCacheOnly) : no ivy file found for " + moduleRevisionId, false);
            }
            BasicResolver.checkInterrupted();
            ResolvedResource resolvedResource = this.findIvyFileRef(dependencyDescriptor2, resolveData);
            BasicResolver.checkInterrupted();
            if (resolvedResource == null) {
                if (!this.allownomd) {
                    throw new BasicResolver$UnresolvedDependencyException("\t" + this.getName() + ": no ivy file found for " + moduleRevisionId, false);
                }
                DefaultModuleDescriptor defaultModuleDescriptor = DefaultModuleDescriptor.newDefaultInstance(moduleRevisionId2, dependencyDescriptor2.getAllDependencyArtifacts());
                object4 = this.findFirstArtifactRef$125bbf72(defaultModuleDescriptor, resolveData);
                BasicResolver.checkInterrupted();
                if (object4 == null) {
                    throw new BasicResolver$UnresolvedDependencyException("\t" + this.getName() + ": no ivy file nor artifact found for " + moduleRevisionId, false);
                }
                long l = ((ResolvedResource)object4).getLastModified();
                if (l != 0L && defaultModuleDescriptor instanceof DefaultModuleDescriptor) {
                    defaultModuleDescriptor.setLastModified(l);
                }
                Message.verbose("\t" + this.getName() + ": no ivy file found for " + moduleRevisionId + ": using default data");
                if (bl) {
                    defaultModuleDescriptor.setResolvedModuleRevisionId(ModuleRevisionId.newInstance(moduleRevisionId2, ((ResolvedResource)object4).getRevision()));
                }
                moduleDescriptor = this.toSystem(defaultModuleDescriptor);
                MetadataArtifactDownloadReport metadataArtifactDownloadReport = new MetadataArtifactDownloadReport(moduleDescriptor.getMetadataArtifact());
                metadataArtifactDownloadReport.setDownloadStatus(DownloadStatus.NO);
                metadataArtifactDownloadReport.setSearched(true);
                resolvedModuleRevision = new ResolvedModuleRevision(this, this, moduleDescriptor, metadataArtifactDownloadReport, false);
                this.getRepositoryCacheManager().cacheModuleDescriptor(this, (ResolvedResource)object4, this.toSystem(dependencyDescriptor), moduleDescriptor.getAllArtifacts()[0], null, this.getCacheOptions(resolveData));
            } else {
                if (resolvedResource instanceof MDResolvedResource) {
                    resolvedModuleRevision = ((MDResolvedResource)resolvedResource).getResolvedModuleRevision();
                }
                if (resolvedModuleRevision == null && (resolvedModuleRevision = this.parse(resolvedResource, (DependencyDescriptor)object, resolveData)) == null) {
                    throw new BasicResolver$UnresolvedDependencyException();
                }
                if (!resolvedModuleRevision.getReport().isDownloaded() && resolvedModuleRevision.getReport().getLocalFile() != null) {
                    ResolvedModuleRevision resolvedModuleRevision4 = resolvedModuleRevision;
                    BasicResolver basicResolver3 = this;
                    ResolvedModuleRevision resolvedModuleRevision5 = this.checkLatest((DependencyDescriptor)object, resolvedModuleRevision4 == null ? null : resolvedModuleRevision4, resolveData);
                    return resolvedModuleRevision5;
                }
                ModuleDescriptor moduleDescriptor2 = resolvedModuleRevision.getDescriptor();
                moduleDescriptor = this.toSystem(moduleDescriptor2);
                if (this.checkconsistency) {
                    this.checkDescriptorConsistency(moduleRevisionId, moduleDescriptor, resolvedResource);
                    this.checkDescriptorConsistency(moduleRevisionId2, moduleDescriptor2, resolvedResource);
                } else if (moduleDescriptor instanceof DefaultModuleDescriptor) {
                    object4 = (DefaultModuleDescriptor)moduleDescriptor;
                    object5 = moduleDescriptor;
                    ModuleRevisionId moduleRevisionId3 = moduleRevisionId;
                    object6 = resolvedResource;
                    basicResolver = this;
                    HashMap hashMap = new HashMap();
                    hashMap.putAll(object5.getQualifiedExtraAttributes());
                    hashMap.putAll(moduleRevisionId3.getQualifiedExtraAttributes());
                    object3 = ((ResolvedResource)object6).getRevision();
                    if (object3 == null) {
                        Message.debug("no revision found in reference for " + moduleRevisionId3);
                        if (basicResolver.getSettings().getVersionMatcher().isDynamic(moduleRevisionId3)) {
                            if (object5.getModuleRevisionId().getRevision() == null) {
                                object3 = "working@" + basicResolver.getName();
                            } else {
                                Message.debug("using " + moduleRevisionId3);
                                object3 = moduleRevisionId3.getRevision();
                            }
                        } else {
                            Message.debug("using " + moduleRevisionId3);
                            object3 = moduleRevisionId3.getRevision();
                        }
                    }
                    ModuleRevisionId moduleRevisionId4 = ModuleRevisionId.newInstance(moduleRevisionId3.getOrganisation(), moduleRevisionId3.getName(), moduleRevisionId3.getBranch(), (String)object3, hashMap);
                    ((DefaultModuleDescriptor)object4).setModuleRevisionId(moduleRevisionId4);
                    ((DefaultModuleDescriptor)object4).setResolvedModuleRevisionId(moduleRevisionId4);
                } else {
                    Message.warn("consistency disabled with instance of non DefaultModuleDescriptor... module info can't be updated, so consistency check will be done");
                    this.checkDescriptorConsistency(moduleRevisionId2, moduleDescriptor2, resolvedResource);
                    this.checkDescriptorConsistency(moduleRevisionId, moduleDescriptor, resolvedResource);
                }
                resolvedModuleRevision = new ResolvedModuleRevision(this, this, moduleDescriptor, this.toSystem(resolvedModuleRevision.getReport()), false);
            }
            object5 = resolvedResource;
            ExtendableItem extendableItem = moduleRevisionId;
            object6 = moduleDescriptor;
            basicResolver = this;
            object3 = object6.getResolvedModuleRevisionId();
            if (((ModuleRevisionId)object3).getRevision() == null || ((ModuleRevisionId)object3).getRevision().length() == 0 || ((ModuleRevisionId)object3).getRevision().startsWith("working@")) {
                object3 = !bl ? ModuleRevisionId.newInstance((ModuleRevisionId)object3, ((ModuleRevisionId)extendableItem).getRevision()) : (object5 == null ? object6.getMetadataArtifact().getModuleRevisionId() : (((ResolvedResource)object5).getRevision() == null || ((ResolvedResource)object5).getRevision().length() == 0 ? ModuleRevisionId.newInstance((ModuleRevisionId)object3, "working@" + basicResolver.getName()) : ModuleRevisionId.newInstance((ModuleRevisionId)object3, ((ResolvedResource)object5).getRevision())));
            }
            if (bl) {
                Message.verbose("\t\t[" + basicResolver.toSystem((ModuleRevisionId)object3).getRevision() + "] " + ((ModuleRevisionId)extendableItem).getModuleId());
            }
            object6.setResolvedModuleRevisionId((ModuleRevisionId)object3);
            ModuleRevisionId moduleRevisionId5 = extendableItem;
            Object object9 = object6;
            Object object10 = basicResolver;
            if (!((AbstractResolver)object10).getSettings().getVersionMatcher().accept(moduleRevisionId5, (ModuleDescriptor)object9)) {
                throw new BasicResolver$UnresolvedDependencyException("\t" + ((AbstractResolver)object10).getName() + ": unacceptable revision => was=" + object9.getResolvedModuleRevisionId().getRevision() + " required=" + moduleRevisionId5.getRevision());
            }
            Object object11 = resolveData;
            object5 = moduleRevisionId;
            extendableItem = moduleDescriptor;
            basicResolver = this;
            if (((ResolveData)object11).getDate() != null) {
                ResolvedResource resolvedResource2;
                long l;
                ResolveData resolveData2 = object11;
                moduleRevisionId5 = extendableItem;
                object9 = basicResolver;
                if ((moduleRevisionId5.getPublicationDate() != null ? moduleRevisionId5.getPublicationDate().getTime() : (l = (resolvedResource2 = super.findFirstArtifactRef$125bbf72((ModuleDescriptor)((Object)moduleRevisionId5), resolveData2)) != null ? resolvedResource2.getLastModified() : -1L)) > ((ResolveData)object11).getDate().getTime()) {
                    throw new BasicResolver$UnresolvedDependencyException("\t" + basicResolver.getName() + ": unacceptable publication date => was=" + new Date(l) + " required=" + ((ResolveData)object11).getDate());
                }
                if (l == -1L) {
                    throw new BasicResolver$UnresolvedDependencyException("\t" + basicResolver.getName() + ": impossible to guess publication date: artifact missing for " + object5);
                }
                extendableItem.setResolvedPublicationDate(new Date(l));
            }
            object5 = resolveData;
            object6 = moduleDescriptor;
            if (!this.getNamespace().equals(Namespace.SYSTEM_NAMESPACE) && !object6.isDefault()) {
                ((ResolveData)object5).getSettings();
            }
            if (resolvedResource == null || resolvedResource.getResource() != null) {
                object11 = resolvedModuleRevision;
                object5 = resolvedResource;
                extendableItem = moduleRevisionId;
                object6 = moduleDescriptor;
                basicResolver = this;
                RepositoryCacheManager repositoryCacheManager = basicResolver.getRepositoryCacheManager();
                object10 = object6.getParser();
                object9 = object5 == null ? object6.getMetadataArtifact() : object10.getMetadataArtifact(ModuleRevisionId.newInstance((ModuleRevisionId)extendableItem, ((ResolvedResource)object5).getRevision()), ((ResolvedResource)object5).getResource());
                repositoryCacheManager.originalToCachedModuleDescriptor(basicResolver, (ResolvedResource)object5, (Artifact)object9, (ResolvedModuleRevision)object11, new BasicResolver$1((ModuleDescriptorParser)object10));
            }
            ResolvedModuleRevision resolvedModuleRevision6 = resolvedModuleRevision;
            BasicResolver basicResolver4 = this;
            object4 = this.checkLatest((DependencyDescriptor)object, resolvedModuleRevision6 == null ? null : resolvedModuleRevision6, resolveData);
            return object4;
        }
        catch (BasicResolver$UnresolvedDependencyException basicResolver$UnresolvedDependencyException) {
            object2 = basicResolver$UnresolvedDependencyException;
            if (basicResolver$UnresolvedDependencyException.getMessage().length() > 0) {
                if (((BasicResolver$UnresolvedDependencyException)object2).isError()) {
                    Message.error(((Throwable)object2).getMessage());
                } else {
                    Message.verbose(((Throwable)object2).getMessage());
                }
            }
            object = resolveData.getCurrentResolvedModuleRevision();
            return object;
        }
        finally {
            IvyContext.popContext();
        }
    }

    public final ResolvedModuleRevision parse(ResolvedResource resolvedResource, DependencyDescriptor dependencyDescriptor, ResolveData resolveData) {
        Object object;
        DependencyDescriptor dependencyDescriptor2 = dependencyDescriptor;
        dependencyDescriptor = this.toSystem(dependencyDescriptor2);
        ModuleRevisionId moduleRevisionId = dependencyDescriptor.getDependencyRevisionId();
        ModuleDescriptorParser moduleDescriptorParser = ModuleDescriptorParserRegistry.getInstance().getParser(resolvedResource.getResource());
        if (moduleDescriptorParser == null) {
            Message.warn("no module descriptor parser available for " + resolvedResource.getResource());
            return null;
        }
        Message.verbose("\t" + this.getName() + ": found md file for " + moduleRevisionId);
        Message.verbose("\t\t=> " + resolvedResource);
        Message.debug("\tparser = " + moduleDescriptorParser);
        ModuleRevisionId moduleRevisionId2 = moduleRevisionId;
        if (this.getSettings().getVersionMatcher().isDynamic(moduleRevisionId) && (object = resolveData.getNode(moduleRevisionId2 = ModuleRevisionId.newInstance(moduleRevisionId, resolvedResource.getRevision()))) != null && ((IvyNode)object).getModuleRevision() != null) {
            if (((IvyNode)object).getDescriptor() != null && ((IvyNode)object).getDescriptor().isDefault()) {
                Message.verbose("\t" + this.getName() + ": found already resolved revision: " + moduleRevisionId2 + ": but it's a default one, maybe we can find a better one");
            } else {
                Message.verbose("\t" + this.getName() + ": revision already resolved: " + moduleRevisionId2);
                ((IvyNode)object).getModuleRevision().getReport().setSearched(true);
                return ((IvyNode)object).getModuleRevision();
            }
        }
        object = moduleDescriptorParser.getMetadataArtifact(moduleRevisionId2, resolvedResource.getResource());
        return this.getRepositoryCacheManager().cacheModuleDescriptor(this, resolvedResource, dependencyDescriptor, (Artifact)object, this.downloader, this.getCacheOptions(resolveData));
    }

    protected final ResourceMDParser getRMDParser(DependencyDescriptor dependencyDescriptor, ResolveData resolveData) {
        return new BasicResolver$2(this, dependencyDescriptor, resolveData);
    }

    protected final ResourceMDParser getDefaultRMDParser(ModuleId moduleId) {
        return new BasicResolver$3(this, moduleId);
    }

    private void checkDescriptorConsistency(ModuleRevisionId moduleRevisionId, ModuleDescriptor moduleDescriptor, ResolvedResource resolvedResource) {
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        if (!moduleRevisionId.getOrganisation().equals(moduleDescriptor.getModuleRevisionId().getOrganisation())) {
            Message.error("\t" + this.getName() + ": bad organisation found in " + resolvedResource.getResource() + ": expected='" + moduleRevisionId.getOrganisation() + "' found='" + moduleDescriptor.getModuleRevisionId().getOrganisation() + "'");
            stringBuffer.append("bad organisation: expected='" + moduleRevisionId.getOrganisation() + "' found='" + moduleDescriptor.getModuleRevisionId().getOrganisation() + "'; ");
            bl = false;
        }
        if (!moduleRevisionId.getName().equals(moduleDescriptor.getModuleRevisionId().getName())) {
            Message.error("\t" + this.getName() + ": bad module name found in " + resolvedResource.getResource() + ": expected='" + moduleRevisionId.getName() + " found='" + moduleDescriptor.getModuleRevisionId().getName() + "'");
            stringBuffer.append("bad module name: expected='" + moduleRevisionId.getName() + "' found='" + moduleDescriptor.getModuleRevisionId().getName() + "'; ");
            bl = false;
        }
        if (moduleRevisionId.getBranch() != null && !moduleRevisionId.getBranch().equals(moduleDescriptor.getModuleRevisionId().getBranch())) {
            Message.error("\t" + this.getName() + ": bad branch name found in " + resolvedResource.getResource() + ": expected='" + moduleRevisionId.getBranch() + " found='" + moduleDescriptor.getModuleRevisionId().getBranch() + "'");
            stringBuffer.append("bad branch name: expected='" + moduleRevisionId.getBranch() + "' found='" + moduleDescriptor.getModuleRevisionId().getBranch() + "'; ");
            bl = false;
        }
        if (resolvedResource.getRevision() != null && !resolvedResource.getRevision().startsWith("working@")) {
            ModuleRevisionId moduleRevisionId2 = ModuleRevisionId.newInstance(moduleRevisionId, resolvedResource.getRevision());
            if (!this.getSettings().getVersionMatcher().accept(moduleRevisionId2, moduleDescriptor)) {
                Message.error("\t" + this.getName() + ": bad revision found in " + resolvedResource.getResource() + ": expected='" + resolvedResource.getRevision() + " found='" + moduleDescriptor.getModuleRevisionId().getRevision() + "'");
                stringBuffer.append("bad revision: expected='" + resolvedResource.getRevision() + "' found='" + moduleDescriptor.getModuleRevisionId().getRevision() + "'; ");
                bl = false;
            }
        }
        if (!this.getSettings().getStatusManager().isStatus(moduleDescriptor.getStatus())) {
            Message.error("\t" + this.getName() + ": bad status found in " + resolvedResource.getResource() + ": '" + moduleDescriptor.getStatus() + "'");
            stringBuffer.append("bad status: '" + moduleDescriptor.getStatus() + "'; ");
            bl = false;
        }
        for (Map.Entry entry : moduleRevisionId.getExtraAttributes().entrySet()) {
            if (entry.getValue() == null || entry.getValue().equals(moduleDescriptor.getExtraAttribute((String)entry.getKey()))) continue;
            String string = "bad " + entry.getKey() + " found in " + resolvedResource.getResource() + ": expected='" + entry.getValue() + "' found='" + moduleDescriptor.getExtraAttribute((String)entry.getKey()) + "'";
            Message.error("\t" + this.getName() + ": " + string);
            stringBuffer.append(string + ";");
            bl = false;
        }
        if (!bl) {
            throw new ParseException("inconsistent module descriptor file found in '" + resolvedResource.getResource() + "': " + stringBuffer, 0);
        }
    }

    public ResolvedResource findResource(ResolvedResource[] resolvedResourceArray, ResourceMDParser resourceMDParser, ModuleRevisionId moduleRevisionId, Date date) {
        String string = this.getName();
        VersionMatcher versionMatcher = this.getSettings().getVersionMatcher();
        ResolvedResource resolvedResource = null;
        List list = this.getLatestStrategy().sort(resolvedResourceArray);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<ModuleRevisionId> arrayList2 = new ArrayList<ModuleRevisionId>();
        IvyContext ivyContext = IvyContext.getContext();
        Object object = list.listIterator(list.size());
        while (object.hasPrevious()) {
            ResolvedResource resolvedResource2 = (ResolvedResource)object.previous();
            if (this.filterNames(new ArrayList<String>(Collections.singleton(resolvedResource2.getRevision()))).isEmpty()) {
                Message.debug("\t" + string + ": filtered by name: " + resolvedResource2);
                continue;
            }
            ModuleRevisionId moduleRevisionId2 = ModuleRevisionId.newInstance(moduleRevisionId, resolvedResource2.getRevision());
            ResolveData resolveData = ivyContext.getResolveData();
            if (resolveData != null && resolveData.getReport() != null && resolveData.isBlacklisted(resolveData.getReport().getConfiguration(), moduleRevisionId2)) {
                Message.debug("\t" + string + ": blacklisted: " + resolvedResource2);
                arrayList.add(resolvedResource2.getRevision() + " (blacklisted)");
                arrayList2.add(moduleRevisionId2);
                continue;
            }
            if (!versionMatcher.accept(moduleRevisionId, moduleRevisionId2)) {
                Message.debug("\t" + string + ": rejected by version matcher: " + resolvedResource2);
                arrayList.add(resolvedResource2.getRevision());
                continue;
            }
            if (resolvedResource2.getResource() != null && !resolvedResource2.getResource().exists()) {
                Message.debug("\t" + string + ": unreachable: " + resolvedResource2 + "; res=" + resolvedResource2.getResource());
                arrayList.add(resolvedResource2.getRevision() + " (unreachable)");
                continue;
            }
            if (date != null && resolvedResource2.getLastModified() > date.getTime()) {
                Message.verbose("\t" + string + ": too young: " + resolvedResource2);
                arrayList.add(resolvedResource2.getRevision() + " (" + resolvedResource2.getLastModified() + ")");
                continue;
            }
            if (versionMatcher.needModuleDescriptor(moduleRevisionId, moduleRevisionId2)) {
                MDResolvedResource mDResolvedResource = resourceMDParser.parse(resolvedResource2.getResource(), resolvedResource2.getRevision());
                if (mDResolvedResource == null) {
                    Message.debug("\t" + string + ": impossible to get module descriptor resource: " + resolvedResource2);
                    arrayList.add(resolvedResource2.getRevision() + " (no or bad MD)");
                    continue;
                }
                ModuleDescriptor moduleDescriptor = mDResolvedResource.getResolvedModuleRevision().getDescriptor();
                if (moduleDescriptor.isDefault()) {
                    Message.debug("\t" + string + ": default md rejected by version matcherrequiring module descriptor: " + resolvedResource2);
                    arrayList.add(resolvedResource2.getRevision() + " (MD)");
                    continue;
                }
                if (!versionMatcher.accept(moduleRevisionId, moduleDescriptor)) {
                    Message.debug("\t" + string + ": md rejected by version matcher: " + resolvedResource2);
                    arrayList.add(resolvedResource2.getRevision() + " (MD)");
                    continue;
                }
                resolvedResource = mDResolvedResource;
            } else {
                resolvedResource = resolvedResource2;
            }
            if (resolvedResource == null) continue;
        }
        if (resolvedResource == null && !arrayList.isEmpty()) {
            this.logAttempt(((Object)arrayList).toString());
        }
        if (resolvedResource == null && !arrayList2.isEmpty()) {
            object = ivyContext.getDependencyDescriptor();
            ivyContext.getResolveData().getNode(object.getParentRevisionId()).getConflictManager(moduleRevisionId.getModuleId()).handleAllBlacklistedRevisions$5b957239(arrayList2);
        }
        return resolvedResource;
    }

    protected Collection filterNames(Collection collection) {
        this.getSettings().filterIgnore(collection);
        return collection;
    }

    private void logArtifactAttempt(Artifact artifact, String string) {
        ArrayList<String> arrayList = (ArrayList<String>)this.artattempts.get(artifact);
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
            this.artattempts.put(artifact, arrayList);
        }
        arrayList.add(string);
        Message.verbose("\t\ttried " + string);
    }

    protected final void logAttempt(String string) {
        Artifact artifact = (Artifact)IvyContext.getContext().get(this.getName() + ".artifact");
        if (artifact != null) {
            this.logArtifactAttempt(artifact, string);
            return;
        }
        String string2 = string;
        this.ivyattempts.add(string2);
        Message.verbose("\t\ttried " + string2);
    }

    @Override
    public final void reportFailure() {
        Message.warn("==== " + this.getName() + ": tried");
        Iterator<Object> iterator2 = this.ivyattempts.listIterator();
        while (iterator2.hasNext()) {
            Object object = (String)iterator2.next();
            Message.warn("  " + (String)object);
        }
        for (Object object : this.artattempts.keySet()) {
            List list = (List)this.artattempts.get(object);
            if (list == null) continue;
            Message.warn("  -- artifact " + object + ":");
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                String string = (String)listIterator.next();
                Message.warn("  " + string);
            }
        }
    }

    @Override
    public final void reportFailure(Artifact artifact) {
        Message.warn("==== " + this.getName() + ": tried");
        List list = (List)this.artattempts.get(artifact);
        if (list != null) {
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                String string = (String)listIterator.next();
                Message.warn("  " + string);
            }
        }
    }

    @Override
    public DownloadReport download(Artifact[] artifactArray, DownloadOptions downloadOptions) {
        RepositoryCacheManager repositoryCacheManager = this.getRepositoryCacheManager();
        this.clearArtifactAttempts();
        DownloadReport downloadReport = new DownloadReport();
        for (int i = 0; i < artifactArray.length; ++i) {
            ArtifactDownloadReport artifactDownloadReport = repositoryCacheManager.download(artifactArray[i], this.artifactResourceResolver, this.downloader, this.getCacheDownloadOptions(downloadOptions));
            if (DownloadStatus.FAILED == artifactDownloadReport.getDownloadStatus()) {
                if (!"missing artifact".equals(artifactDownloadReport.getDownloadDetails())) {
                    Message.warn("\t" + artifactDownloadReport);
                }
            } else if (DownloadStatus.NO == artifactDownloadReport.getDownloadStatus()) {
                Message.verbose("\t" + artifactDownloadReport);
            } else if ("quiet".equals(downloadOptions.getLog())) {
                Message.verbose("\t" + artifactDownloadReport);
            } else {
                Message.info("\t" + artifactDownloadReport);
            }
            downloadReport.addArtifactReport(artifactDownloadReport);
            BasicResolver.checkInterrupted();
        }
        return downloadReport;
    }

    private void clearArtifactAttempts() {
        this.artattempts.clear();
    }

    @Override
    public ArtifactOrigin locate(Artifact artifact) {
        ArtifactOrigin artifactOrigin = this.getRepositoryCacheManager().getSavedArtifactOrigin(this.toSystem(artifact));
        if (!ArtifactOrigin.isUnknown(artifactOrigin)) {
            return artifactOrigin;
        }
        ResolvedResource resolvedResource = this.getArtifactRef(artifact, null);
        if (resolvedResource != null && resolvedResource.getResource().exists()) {
            return new ArtifactOrigin(artifact, resolvedResource.getResource().isLocal(), resolvedResource.getResource().getName());
        }
        return null;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    private ResolvedResource findFirstArtifactRef$125bbf72(ModuleDescriptor moduleDescriptor, ResolveData resolveData) {
        ResolvedResource resolvedResource = null;
        String[] stringArray = moduleDescriptor.getConfigurationsNames();
        for (int i = 0; i < stringArray.length; ++i) {
            Artifact[] artifactArray = moduleDescriptor.getArtifacts(stringArray[i]);
            for (int j = 0; j < artifactArray.length; ++j) {
                resolvedResource = this.getArtifactRef(artifactArray[j], resolveData.getDate());
                if (resolvedResource == null) continue;
                return resolvedResource;
            }
        }
        return null;
    }

    protected final long getAndCheck(Resource resource, File file2) {
        String[] stringArray;
        long l = this.get(resource, file2);
        String string = this.getSettings().getVariable("ivy.checksums");
        if (string == null) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = string.split(",");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < stringArray2.length; ++i) {
                String string2 = stringArray2[i].trim();
                if ("".equals(string2) || "none".equals(string2)) continue;
                arrayList.add(string2);
            }
            stringArray = arrayList.toArray(new String[arrayList.size()]);
        }
        String[] stringArray3 = stringArray;
        boolean bl = false;
        for (int i = 0; i < stringArray3.length && !bl; ++i) {
            bl = this.check(resource, file2, stringArray3[i]);
        }
        return l;
    }

    private boolean check(Resource resource, File file2, String string) {
        if (!ChecksumHelper.isKnownAlgorithm(string)) {
            throw new IllegalArgumentException("Unknown checksum algorithm: " + string);
        }
        Resource resource2 = resource.clone(resource.getName() + "." + string);
        if (resource2.exists()) {
            Message.debug(string + " file found for " + resource + ": checking...");
            File file3 = File.createTempFile("ivytmp", string);
            try {
                this.get(resource2, file3);
                try {
                    ChecksumHelper.check(file2, file3, string);
                    Message.verbose(string + " OK for " + resource);
                    return true;
                }
                catch (IOException iOException) {
                    file2.delete();
                    throw iOException;
                }
            }
            finally {
                file3.delete();
            }
        }
        return false;
    }

    protected final ResolvedResource getArtifactRef(Artifact artifact, Date date) {
        IvyContext.getContext().set(this.getName() + ".artifact", artifact);
        try {
            Object object;
            ResolvedResource resolvedResource = this.findArtifactRef(artifact, date);
            if (resolvedResource == null && artifact.getUrl() != null) {
                object = artifact.getUrl();
                Message.verbose("\tusing url for " + artifact + ": " + object);
                this.logArtifactAttempt(artifact, ((URL)object).toExternalForm());
                Resource resource = "file".equals(((URL)object).getProtocol()) ? new FileResource(new FileRepository(), new File(((URL)object).getPath())) : new URLResource((URL)object);
                resolvedResource = new ResolvedResource(resource, artifact.getModuleRevisionId().getRevision());
            }
            object = resolvedResource;
            return object;
        }
        finally {
            IvyContext.getContext().set(this.getName() + ".artifact", null);
        }
    }

    protected abstract ResolvedResource findArtifactRef(Artifact var1, Date var2);

    protected abstract long get(Resource var1, File var2);

    public final void setCheckconsistency(boolean bl) {
        this.checkconsistency = bl;
    }

    public static boolean isForce() {
        return false;
    }

    public final void setDescriptor(String string) {
        if ("required".equals(string)) {
            this.allownomd = false;
            return;
        }
        if ("optional".equals(string)) {
            this.allownomd = true;
            return;
        }
        throw new IllegalArgumentException("unknown descriptor rule '" + string + "'. Allowed rules are: " + Arrays.asList("required", "optional"));
    }

    static /* synthetic */ URLRepository access$000(BasicResolver basicResolver) {
        return basicResolver.extartifactrep;
    }

    static {
        new SimpleDateFormat("yyyyMMddHHmmss");
    }
}

