/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib;

import CH.ifa.draw.contrib.MDIDesktopManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.beans.PropertyVetoException;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;

public class MDIDesktopPane
extends JDesktopPane {
    private static int FRAME_OFFSET = 20;
    private MDIDesktopManager manager = new MDIDesktopManager(this);

    public MDIDesktopPane() {
        this.setDesktopManager(this.manager);
    }

    public Component add(JInternalFrame frame) {
        Point p;
        JInternalFrame[] array = this.getAllFrames();
        Component retval = super.add(frame);
        this.checkDesktopSize();
        if (array.length > 0) {
            p = array[0].getLocation();
            p.x += FRAME_OFFSET;
            p.y += FRAME_OFFSET;
        } else {
            p = new Point(0, 0);
        }
        frame.setLocation(p.x, p.y);
        if (frame.isResizable()) {
            int w = this.getWidth() - this.getWidth() / 3;
            int h = this.getHeight() - this.getHeight() / 3;
            if ((double)w < frame.getMinimumSize().getWidth()) {
                w = (int)frame.getMinimumSize().getWidth();
            }
            if ((double)h < frame.getMinimumSize().getHeight()) {
                h = (int)frame.getMinimumSize().getHeight();
            }
            frame.setSize(w, h);
        }
        this.moveToFront(frame);
        frame.setVisible(true);
        try {
            frame.setSelected(true);
        }
        catch (PropertyVetoException e) {
            frame.toBack();
        }
        return retval;
    }

    public void remove(Component c) {
        super.remove(c);
        this.checkDesktopSize();
    }

    public void cascadeFrames() {
        int x = 0;
        int y = 0;
        JInternalFrame[] allFrames = this.getAllFrames();
        this.manager.setNormalSize();
        int frameHeight = this.getBounds().height - 5 - allFrames.length * FRAME_OFFSET;
        int frameWidth = this.getBounds().width - 5 - allFrames.length * FRAME_OFFSET;
        for (int i = allFrames.length - 1; i >= 0; --i) {
            try {
                allFrames[i].setMaximum(false);
            }
            catch (PropertyVetoException e) {
                e.printStackTrace();
            }
            allFrames[i].setBounds(x, y, frameWidth, frameHeight);
            x += FRAME_OFFSET;
            y += FRAME_OFFSET;
        }
        this.checkDesktopSize();
    }

    public void tileFrames() {
        JInternalFrame[] allFrames = this.getAllFrames();
        this.manager.setNormalSize();
        int frameHeight = this.getBounds().height / allFrames.length;
        int y = 0;
        for (int i = 0; i < allFrames.length; ++i) {
            try {
                allFrames[i].setMaximum(false);
            }
            catch (PropertyVetoException e) {
                e.printStackTrace();
            }
            allFrames[i].setBounds(0, y, this.getBounds().width, frameHeight);
            y += frameHeight;
        }
        this.checkDesktopSize();
    }

    public void setAllSize(Dimension d) {
        this.setMinimumSize(d);
        this.setMaximumSize(d);
        this.setPreferredSize(d);
        this.setBounds(0, 0, d.width, d.height);
    }

    public void setAllSize(int width, int height) {
        this.setAllSize(new Dimension(width, height));
    }

    private void checkDesktopSize() {
        if (this.getParent() != null && this.isVisible()) {
            this.manager.resizeDesktop();
        }
    }
}

